/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.licensing.ClientKeyService;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.PreferenceMastHead;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.licensing.ProFeatureUtilities;
import com.aptana.ide.update.Activator;
import com.eaio.uuid.MACAddress;
import java.text.DateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;

public class LicensePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String RENEW_NOW_LINK = "<a>Renew Now</a>";
    private static final String BUY_NOW_LINK = "<a>Buy Now</a>";
    Composite displayArea;
    private Composite buffer;
    PreferenceMastHead header;
    private Label description;
    private Group activateGroup;
    private Label emailLabel;
    private Text emailText;
    private Label keyLabel;
    private Text keyText;
    private Button activateButton;
    private Button installButton;
    private Button tryLink;
    private Button buyLink;
    private Button learnLink;
    private Label statusLabel;
    private Link contactLink;
    private Link renewNow;
    private Label registeredTo;
    private Label expiresOn;
    private Label licenseType;
    private IPropertyChangeListener prepPropertyChangeListener;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.displayArea = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 400;
        this.displayArea.setLayoutData((Object)data);
        this.buffer = new Composite(this.displayArea, 0);
        this.header = new PreferenceMastHead(this.buffer, "Aptana Studio Professional License Page", 3, UnifiedEditorsPlugin.getImageDescriptor((String)"images/keys.png"));
        this.buffer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buffer.setBackground(PreferenceMastHead.HEADER_BG_COLOR);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        this.displayArea.setLayout((Layout)layout);
        this.buffer.setLayout((Layout)layout);
        this.buffer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = new GC((Drawable)LicensePreferencePage.this.buffer);
                gc.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
                if (((LicensePreferencePage)LicensePreferencePage.this).buffer.getSize().y - 4 >= 0) {
                    gc.fillRectangle(0, ((LicensePreferencePage)LicensePreferencePage.this).buffer.getSize().y - 5, ((LicensePreferencePage)LicensePreferencePage.this).buffer.getSize().x, 5);
                }
            }
        });
        GridData hData = (GridData)this.header.getControl().getLayoutData();
        hData.grabExcessVerticalSpace = false;
        this.header.getControl().setLayoutData((Object)hData);
        this.description = new Label(this.displayArea, 16448);
        GridData dData = new GridData(4, 4, false, false);
        dData.widthHint = 400;
        this.description.setLayoutData((Object)dData);
        this.description.setText("Aptana Studio Professional edition offers many new and exciting features as well as world-class support. The professional edition also delivers more updates and access to bleeding edge source code.");
        Composite topComp = new Composite(this.displayArea, 0);
        GridLayout tcLayout = new GridLayout(3, false);
        tcLayout.marginHeight = 0;
        tcLayout.marginWidth = 0;
        topComp.setLayout((Layout)tcLayout);
        topComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tryLink = new Button(topComp, 0);
        this.tryLink.setText("Try...");
        this.tryLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=try", (boolean)false, (String)"studio_pref");
            }
        });
        this.buyLink = new Button(topComp, 0);
        this.buyLink.setText("Buy...");
        this.buyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=buy", (boolean)false, (String)"studio_pref");
            }
        });
        this.learnLink = new Button(topComp, 0);
        this.learnLink.setText("Learn more...");
        this.learnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=learn", (boolean)true, (String)"studio_pref");
            }
        });
        this.activateGroup = new Group(this.displayArea, 0);
        this.activateGroup.setLayout((Layout)new GridLayout(1, false));
        this.activateGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.activateGroup.setText("License");
        Composite emailComp = new Composite((Composite)this.activateGroup, 0);
        GridLayout ecLayout = new GridLayout(2, false);
        ecLayout.marginHeight = 0;
        ecLayout.marginWidth = 0;
        emailComp.setLayout((Layout)ecLayout);
        emailComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.emailLabel = new Label(emailComp, 16448);
        this.emailLabel.setText("Username:");
        this.emailText = new Text(emailComp, 2052);
        GridData etData = new GridData(4, 4, true, false);
        this.emailText.setLayoutData((Object)etData);
        String emailPref = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_EMAIL_ADDRESS");
        ModifyListener mListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String initialEmail = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_EMAIL_ADDRESS");
                String initialKey = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_KEY");
                String currentEmail = LicensePreferencePage.this.emailText.getText();
                String currentKey = LicensePreferencePage.this.keyText.getText();
                if (currentEmail != null && currentEmail.equals(MACAddress.getMACAddress())) {
                    LicensePreferencePage.this.emailText.setEchoChar('*');
                    LicensePreferencePage.this.emailText.addModifyListener((ModifyListener)new TrialKeyModifyListener());
                }
                if (!currentEmail.equals(initialEmail) || !currentKey.equals(initialKey) || LicensePreferencePage.this.contactLink.getVisible()) {
                    LicensePreferencePage.this.setErrorMessage("Please validate before saving changes");
                    LicensePreferencePage.this.setValid(false);
                } else {
                    LicensePreferencePage.this.setErrorMessage(null);
                    LicensePreferencePage.this.setValid(true);
                }
            }
        };
        if (emailPref != null) {
            this.emailText.setText(emailPref);
        }
        this.emailText.addModifyListener(mListener);
        this.keyLabel = new Label((Composite)this.activateGroup, 16448);
        this.keyLabel.setText("License Key:");
        this.keyLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.keyText = new Text((Composite)this.activateGroup, 2882);
        String keyPref = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_KEY");
        if (keyPref != null) {
            this.keyText.setText(keyPref);
        }
        this.keyText.addModifyListener(mListener);
        GridData ktData = new GridData(4, 4, true, true);
        ktData.heightHint = 100;
        ktData.widthHint = 400;
        this.keyText.setLayoutData((Object)ktData);
        Composite activateComp = new Composite((Composite)this.activateGroup, 0);
        GridLayout acLayout = new GridLayout(4, false);
        acLayout.marginHeight = 0;
        acLayout.marginWidth = 0;
        activateComp.setLayout((Layout)acLayout);
        activateComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.activateButton = new Button(activateComp, 8);
        this.activateButton.setText("Validate");
        this.activateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.validate();
            }
        });
        this.statusLabel = new Label(activateComp, 16448);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.statusLabel.setText("Invalid key");
        this.statusLabel.setVisible(false);
        this.contactLink = new Link(activateComp, 0);
        this.contactLink.setText("<a>Licensing Help...</a>");
        this.contactLink.setVisible(false);
        this.contactLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithInfo((String)"http://www.aptana.com/support/licensehelp/", (boolean)true, (String)"studio_pref");
            }
        });
        this.installButton = new Button(activateComp, 8);
        this.installButton.setText("Install...");
        this.installButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProFeatureUtilities.scheduleProFeatureInstall();
            }
        });
        this.installButton.setEnabled(false);
        this.licenseType = new Label((Composite)this.activateGroup, 16448);
        this.licenseType.setLayoutData((Object)new GridData(4, 4, true, false));
        this.licenseType.setText("License Type:");
        this.registeredTo = new Label((Composite)this.activateGroup, 16448);
        this.registeredTo.setText("Registered to:");
        this.registeredTo.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite expiresComp = new Composite((Composite)this.activateGroup, 0);
        GridLayout excLayout = new GridLayout(2, false);
        excLayout.marginHeight = 0;
        excLayout.marginWidth = 0;
        expiresComp.setLayout((Layout)excLayout);
        expiresComp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.expiresOn = new Label(expiresComp, 16448);
        this.expiresOn.setText("Expires on:");
        this.expiresOn.setLayoutData((Object)new GridData(4, 4, false, false));
        this.renewNow = new Link(expiresComp, 0);
        this.renewNow.setText(RENEW_NOW_LINK);
        this.renewNow.setVisible(false);
        this.renewNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicensePreferencePage.RENEW_NOW_LINK.equals(LicensePreferencePage.this.renewNow.getText())) {
                    CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/store/renew/?item=studiopro", (boolean)false, (String)"studio_pref");
                } else if (LicensePreferencePage.BUY_NOW_LINK.equals(LicensePreferencePage.this.renewNow.getText())) {
                    CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/store/buy/?item=studiopro", (boolean)false, (String)"studio_pref");
                }
            }
        });
        this.renewNow.setLayoutData((Object)new GridData(4, 4, true, false));
        if (keyPref != null) {
            this.validate();
        }
        this.setupPreferencesListener();
        return this.displayArea;
    }

    private void setupPreferencesListener() {
        this.prepPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent event) {
                UIJob job = new UIJob("Setting licensing info in prefences page."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!LicensePreferencePage.this.emailText.isDisposed() && "com.aptana.ide.core.ui.ACTIVATION_EMAIL_ADDRESS".equals(event.getProperty())) {
                            LicensePreferencePage.this.emailText.setText((String)event.getNewValue());
                        } else if (!LicensePreferencePage.this.keyText.isDisposed() && "com.aptana.ide.core.ui.ACTIVATION_KEY".equals(event.getProperty())) {
                            LicensePreferencePage.this.keyText.setText((String)event.getNewValue());
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.schedule();
            }
        };
        ApplicationPreferences.getInstance().addPropertyChangeListener(this.prepPropertyChangeListener);
    }

    public void dispose() {
        ApplicationPreferences.getInstance().removePropertyChangeListener(this.prepPropertyChangeListener);
        super.dispose();
    }

    private final void installEnablePro() {
        if (this.keyText.getText().length() == 0 || this.emailText.getText().length() == 0) {
            this.statusLabel.setText("Invalid key");
            this.statusLabel.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
            this.statusLabel.getParent().layout(true, true);
            this.contactLink.setVisible(true);
            this.setErrorMessage("Error validating. Empty email or license.");
            this.setValid(false);
            return;
        }
        this.statusLabel.setText("Unknown");
        this.statusLabel.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
        this.statusLabel.getParent().layout(true, true);
        this.statusLabel.setVisible(true);
        ProFeatureUtilities.addProFunctionalityInteractive();
        this.installButton.setEnabled(true);
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private void validate() {
        if (!ClientKeyService.isClientKeyProviderAvail()) {
            this.installEnablePro();
            return;
        }
        ClientKey ck = ClientKeyService.createClientKey((String)this.keyText.getText(), (String)this.emailText.getText());
        boolean valid = ck.isValid();
        if (ck.isPro() && ck.isCloseToExpiring() && valid) {
            this.renewNow.setText(RENEW_NOW_LINK);
            this.renewNow.setVisible(true);
        } else if (ck.isTrial() && ck.isExpired() && valid) {
            this.renewNow.setText(BUY_NOW_LINK);
            this.renewNow.setVisible(true);
        } else {
            this.renewNow.setVisible(false);
        }
        if (ck.isPro() && valid) {
            this.licenseType.setText("License Type: Professional");
        } else if (ck.isTrial() && valid) {
            this.licenseType.setText("License Type: Trial");
        } else if (valid) {
            this.licenseType.setText("License Type: Unknown");
        } else {
            this.licenseType.setText("License Type: Invalid");
        }
        this.installButton.setEnabled(valid);
        if (valid) {
            this.contactLink.setVisible(false);
            this.keyText.setText(ClientKey.trimEncryptedLicense((String)this.keyText.getText()));
            this.statusLabel.setText("Valid key");
            this.statusLabel.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 175, 0)));
            String regString = StringUtils.format((String)"Registered to: {0}", (String)ck.getEmail());
            this.registeredTo.setText(regString);
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            String expString = StringUtils.format((String)"Expires on: {0}", (String)df.format(ck.getExpiration().getTime()));
            this.expiresOn.setText(expString);
            this.expiresOn.getParent().layout(true, true);
            String keyPref = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_KEY");
            if (keyPref == null) {
                try {
                    this.performOk();
                    if (ProFeatureUtilities.isUninstalledProFeaturesAvailable()) {
                        MessageDialog dialog = new MessageDialog(this.getShell(), "Download Pro Features", null, "Thank you for activating!\nWould you like to download and install Pro features now?", 3, new String[]{"Yes", "No"}, 0);
                        int rc = dialog.open();
                        if (rc == 0) {
                            ProFeatureUtilities.scheduleProFeatureInstall();
                        }
                    } else {
                        MessageDialog dialog = new MessageDialog(this.getShell(), "Update Pro Features", null, "Would you like to search for updates to Aptana Studio and your Pro features now?", 3, new String[]{"Yes", "No"}, 0);
                        int rc = dialog.open();
                        if (rc == 0) {
                            BusyIndicator.showWhile((Display)CoreUIUtils.getDisplay(), (Runnable)new Runnable(){

                                public void run() {
                                    Activator.getScheduler().startSearch(0L, true);
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error adding update site", (Throwable)e);
                }
            }
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            if (ck.isCloseToMatching()) {
                this.statusLabel.setText("Username did not match key");
            } else {
                this.statusLabel.setText("Invalid key");
            }
            this.statusLabel.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
            this.statusLabel.getParent().layout(true, true);
            this.contactLink.setVisible(true);
            this.setErrorMessage("Error validating. Select cancel to discard changes.");
            this.setValid(false);
        }
        if (valid && ck.isExpired()) {
            this.expiresOn.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
        } else {
            this.expiresOn.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
        }
        this.statusLabel.setVisible(true);
    }

    public boolean performOk() {
        String email;
        String key = this.keyText.getText();
        ClientKey ck = ClientKeyService.createClientKey((String)key, (String)(email = this.emailText.getText()));
        if (ck.isValid()) {
            ProFeatureUtilities.addProUpdateSites();
            ProFeatureUtilities.enableProFeature(true);
            ProFeatureUtilities.setPrefAndRegistry(key, email);
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        if (this.header != null) {
            this.header.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    private class TrialKeyModifyListener
    implements ModifyListener {
        private TrialKeyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            LicensePreferencePage.this.emailText.removeModifyListener((ModifyListener)this);
            LicensePreferencePage.this.emailText.setText("");
            LicensePreferencePage.this.emailText.setEchoChar('\u0000');
        }
    }
}

