/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.preferences;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.dialogs.IAddItemListener;
import com.aptana.ide.core.ui.dialogs.TableEditor;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.messaging.MessagingManager;
import com.aptana.ide.intro.preferences.FeedDescriptor;
import com.aptana.ide.intro.preferences.Messages;
import com.aptana.ide.server.jetty.JettyPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class IntroPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IAddItemListener {
    private BooleanFieldEditor portalBrowserEditor;
    private RadioGroupFieldEditor showStartPageEditor;
    private TableEditor _tableEditor;
    private FeedDescriptor[] oldFeeds;

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        entryTable.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        entryTable.setLayout((Layout)layout);
        Composite colorComposite = new Composite(entryTable, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        colorComposite.setLayoutData((Object)new GridData(768));
        this.showStartPageEditor = new RadioGroupFieldEditor("com.aptana.ide.intro.SHOW_STARTPAGE_ON_STARTUP", Messages.IntroPreferencePage_StartPageOptions, 1, (String[][])new String[][]{{Messages.IntroPreferencePage_AlwaysDisplayAtStart, "true"}, {Messages.IntroPreferencePage_AlwaysDisplayAfterAnyUpdates, "all"}, {Messages.IntroPreferencePage_AlwaysDisplayAfterAptanaUpdates, "aptana"}, {Messages.IntroPreferencePage_NeverDisplayAfterStartup, "false"}}, colorComposite, true);
        this.showStartPageEditor.setPage((DialogPage)this);
        this.showStartPageEditor.setPreferenceStore(this.getPreferenceStore());
        this.showStartPageEditor.load();
        if (CoreUIUtils.onWindows) {
            this.portalBrowserEditor = new BooleanFieldEditor("com.aptana.ide.server.jetty.preferences.USE_FIREFOX", "Use Firefox as the Aptana Home page browser", colorComposite);
            this.portalBrowserEditor.setPage((DialogPage)this);
            this.portalBrowserEditor.setPreferenceStore(JettyPlugin.getDefault().getPreferenceStore());
            this.portalBrowserEditor.load();
        }
        Group errorFilter = new Group(entryTable, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        errorFilter.setLayout((Layout)gridLayout);
        errorFilter.setLayoutData((Object)new GridData(4, 4, true, true));
        errorFilter.setText("RSS Feeds");
        this._tableEditor = new TableEditor((Composite)errorFilter, 0, true);
        this._tableEditor.setDescription("Description");
        data = new GridData(1808);
        data.heightHint = 150;
        this._tableEditor.setLayoutData((Object)data);
        this.oldFeeds = MessagingManager.getFeeds();
        ArrayList _items = new ArrayList(Arrays.asList(this.oldFeeds));
        this._tableEditor.setLabelProvider((ITableLabelProvider)new TableLabelProvider());
        this._tableEditor.addAddItemListener((IAddItemListener)this);
        new TableColumn(this._tableEditor.getTable(), 16384);
        this._tableEditor.setItems(_items);
        return entryTable;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(IntroPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.showStartPageEditor.loadDefault();
        if (CoreUIUtils.onWindows) {
            this.portalBrowserEditor.loadDefault();
        }
        FeedDescriptor[] descriptors = MessagingManager.getFeeds();
        ArrayList _items = new ArrayList(Arrays.asList(descriptors));
        this._tableEditor.setItems(_items);
    }

    public boolean performOk() {
        this.showStartPageEditor.store();
        if (CoreUIUtils.onWindows) {
            this.portalBrowserEditor.store();
        }
        List items = this._tableEditor.getItems();
        for (Object object : items) {
            FeedDescriptor fd = (FeedDescriptor)object;
            MessagingManager.addFeed(fd);
        }
        int i = 0;
        while (i < this.oldFeeds.length) {
            if (!items.contains(this.oldFeeds[i])) {
                MessagingManager.removeFeed(this.oldFeeds[i], true);
            }
            ++i;
        }
        MessagingManager.storeFeeds();
        MessagingManager.getNewMessages(new Date(0L));
        return super.performOk();
    }

    public Object editItem(Object item) {
        FeedDescriptor feed = (FeedDescriptor)item;
        InputDialog dialog = new InputDialog(CoreUIUtils.getActiveShell(), "Edit RSS Feed", "Enter the URL for a RSS 1.0 or RSS 2.0 feed:", feed.getUrl(), new IInputValidator(){

            public String isValid(String newText) {
                if ("".equals(newText.trim())) {
                    return "You must enter a feed URL (generally beginning with http:// or https://)";
                }
                return null;
            }
        });
        int rc = dialog.open();
        if (rc == 0) {
            feed.setUrl(dialog.getValue().trim());
            return feed;
        }
        return null;
    }

    public Object addItem() {
        InputDialog dialog = new InputDialog(CoreUIUtils.getActiveShell(), "Add a New RSS Feed", "Enter the URL for a RSS 1.0 or RSS 2.0 feed:", null, new IInputValidator(){

            public String isValid(String newText) {
                if ("".equals(newText.trim())) {
                    return "You must enter a feed URL (generally beginning with http:// or https://)";
                }
                return null;
            }
        });
        int rc = dialog.open();
        if (rc == 0) {
            FeedDescriptor feed = new FeedDescriptor();
            feed.setUrl(dialog.getValue().trim());
            return feed;
        }
        return null;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return IntroPlugin.getDefault().getPreferenceStore();
    }

    public class TableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String name = "";
            FeedDescriptor ed = (FeedDescriptor)element;
            switch (columnIndex) {
                case 0: {
                    name = ed.getUrl();
                    break;
                }
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableSorter
    extends ViewerSorter {
        TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return super.compare(viewer, e1, e2);
        }
    }
}

