/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.preferences;

import com.aptana.ide.core.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FeedDescriptor {
    private String _name;
    private String _url;
    private long _interval = 14400000L;
    private Date _lastPolled = new Date();
    private boolean _trans = false;
    public static String FIELD_SEPARATOR = "~~~~";
    public static String DESCRIPTOR_SEPARATOR = "####";

    public FeedDescriptor() {
    }

    public FeedDescriptor(String name, String url, long interval, Date lastPolled, boolean trans) {
        if (name == null) {
            this._name = url;
        }
        this._url = url;
        this._interval = interval;
        if (lastPolled != null) {
            this._lastPolled = lastPolled;
        }
        this._trans = trans;
    }

    public boolean isTransient() {
        return this._trans;
    }

    public void setTransient(boolean trans) {
        this._trans = trans;
    }

    public String getName() {
        return this._name;
    }

    public String getUrl() {
        return this._url;
    }

    public long getPollInterval() {
        return this._interval;
    }

    public Date getLastPoll() {
        return this._lastPolled;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setPollInterval(long interval) {
        this._interval = interval;
    }

    public void setLastPoll(Date lastPolled) {
        this._lastPolled = lastPolled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append(this.getUrl());
        }
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getUrl());
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getPollInterval());
        sb.append(FIELD_SEPARATOR);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sb.append(sdf.format(this.getLastPoll()));
        return sb.toString();
    }

    public void fromString(String values) {
        String[] vals = values.split(FIELD_SEPARATOR, 4);
        if (!"".equals(vals[0])) {
            this._name = vals[0];
        }
        if (!"".equals(vals[1])) {
            this._url = vals[1];
        }
        if (vals.length > 2 && !"".equals(vals[2])) {
            this._interval = Long.parseLong(vals[2]);
        }
        if (vals.length > 3 && !"".equals(vals[3])) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            try {
                this._lastPolled = sdf.parse(vals[3]);
            }
            catch (ParseException parseException) {
                this._lastPolled = new Date();
            }
        }
    }

    public static String serializeFeedDescriptors(FeedDescriptor[] errors) {
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < errors.length) {
            FeedDescriptor descriptor = errors[i];
            if (!descriptor.isTransient()) {
                al.add(descriptor.toString());
            }
            ++i;
        }
        return StringUtils.join((String)DESCRIPTOR_SEPARATOR, (String[])al.toArray(new String[0]));
    }

    public static FeedDescriptor[] deserializeFeedDescriptors(String errors) {
        if ("".equals(errors)) {
            return new FeedDescriptor[0];
        }
        ArrayList<FeedDescriptor> al = new ArrayList<FeedDescriptor>();
        String[] errorDescriptors = errors.split(DESCRIPTOR_SEPARATOR);
        int i = 0;
        while (i < errorDescriptors.length) {
            String descriptor = errorDescriptors[i];
            FeedDescriptor ed = new FeedDescriptor();
            ed.fromString(descriptor);
            al.add(ed);
            ++i;
        }
        return al.toArray(new FeedDescriptor[0]);
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 instanceof FeedDescriptor) {
            FeedDescriptor s = (FeedDescriptor)arg0;
            result = this.getUrl().equals(s.getUrl());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

