/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.messaging.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessagingPreferences {
    private static final String messasgingSettings = ".aptana-messaging";
    private static MessagingPreferences instance;
    private List<Message> messages = new ArrayList<Message>();
    private boolean _hasLoaded;

    private MessagingPreferences() {
    }

    static MessagingPreferences getInstance() {
        if (instance == null) {
            instance = new MessagingPreferences();
        }
        return instance;
    }

    private File getSettingsFile() {
        File config = CoreUIUtils.getConfigurationDirectory();
        return new File(config, messasgingSettings);
    }

    public List<Message> loadPreferences() {
        File settings = this.getSettingsFile();
        if (this._hasLoaded || !settings.exists()) {
            return this.messages;
        }
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(settings));
                Object obj = ois.readObject();
                if (obj instanceof List) {
                    this.messages = (List)obj;
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Unable to read messaging store", (Throwable)e);
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Unable to close messaging store", (Throwable)e);
                }
            }
            this._hasLoaded = true;
        }
        return this.messages;
    }

    public void savePreferences(List<Message> savedMessages) {
        ObjectOutputStream oos = null;
        try {
            try {
                File settings = this.getSettingsFile();
                oos = new ObjectOutputStream(new FileOutputStream(settings));
                oos.writeObject(savedMessages);
                oos.flush();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Unable to write messaging store", (Throwable)e);
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Unable to close messaging store", (Throwable)e);
                }
            }
        }
    }
}

