/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.messaging.IMessageListener;
import com.aptana.ide.intro.messaging.Message;
import com.aptana.ide.intro.messaging.MessagesReader;
import com.aptana.ide.intro.messaging.MessagingPreferences;
import com.aptana.ide.intro.preferences.FeedDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingManager {
    private static ListenerList listeners = new ListenerList();
    private static MessagesReader reader = null;
    private static List<Message> messages = null;
    private static ConcurrentHashMap<String, FeedDescriptor> feedMap = new ConcurrentHashMap();
    public static long INTERVAL_CHECK = 10000L;
    public static long INTERVAL_DAY = 86400000L;
    public static Date lastChecked = new Date(0L);

    public static void addListener(IMessageListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(IMessageListener listener) {
        listeners.remove((Object)listener);
    }

    public static void addFeed(String feedUrl, long interval) {
        if (feedMap.containsKey(feedUrl)) {
            feedMap.remove(feedUrl);
        }
        FeedDescriptor fd = new FeedDescriptor(null, feedUrl, interval, null, false);
        feedMap.put(feedUrl, fd);
    }

    public static void addFeed(FeedDescriptor feed) {
        if (feedMap.containsKey(feed.getUrl())) {
            feedMap.remove(feed.getUrl());
        }
        feedMap.put(feed.getUrl(), feed);
    }

    public static void removeFeed(FeedDescriptor feed, boolean clearMessages) {
        if (feedMap.containsKey(feed.getUrl())) {
            feedMap.remove(feed.getUrl());
            if (clearMessages) {
                MessagingManager.clearMessages(feed.getUrl());
            }
        }
    }

    public static void removeFeed(String feedUrl, boolean clearMessages) {
        if (feedMap.containsKey(feedUrl)) {
            feedMap.remove(feedUrl);
            if (clearMessages) {
                MessagingManager.clearMessages(feedUrl);
            }
        }
    }

    public static void clearMessages(final String feedUrl) {
        Job job = new Job("Clearing messages"){

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<Message> remove = new ArrayList<Message>();
                for (Message iterable_element : messages) {
                    if (!iterable_element.getSite().equals(feedUrl)) continue;
                    remove.add(iterable_element);
                }
                for (Message message : remove) {
                    MessagingManager.purgeMessage(message);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule(0L);
    }

    public static void notifyListeners(final Message changedMessage, final int eventType) {
        Object[] oListeners = listeners.getListeners();
        int i = 0;
        while (i < oListeners.length) {
            final IMessageListener listener = (IMessageListener)oListeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Error notifying message listener", (Throwable)exception);
                }

                public void run() throws Exception {
                    listener.messageChanged(changedMessage, eventType);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
        MessagingManager.storeMessages();
        MessagingManager.storeFeeds();
    }

    public static void loadRemoteMessages(FeedDescriptor[] feeds, IProgressMonitor monitor) {
        if (reader == null) {
            reader = new MessagesReader();
        }
        reader.loadMessages(feeds, monitor);
        Message[] retrieved = reader.getMessages();
        int i = 0;
        while (i < retrieved.length) {
            MessagingManager.addMessage(retrieved[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUnreadUrgentMessages() {
        List<Message> msgs;
        int urgentsUnread = 0;
        List<Message> list = msgs = messages;
        synchronized (list) {
            int i = 0;
            while (i < msgs.size()) {
                Message curr = msgs.get(i);
                if (curr != null && curr.isUrgent() && !curr.isRead()) {
                    ++urgentsUnread;
                }
                ++i;
            }
        }
        return urgentsUnread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUnreadMessages() {
        List<Message> msgs;
        int unread = 0;
        List<Message> list = msgs = messages;
        synchronized (list) {
            int i = 0;
            while (i < msgs.size()) {
                Message curr = msgs.get(i);
                if (curr != null && !curr.isRead()) {
                    ++unread;
                }
                ++i;
            }
        }
        return unread;
    }

    public static void addMessage(Message message) {
        boolean newMessage = true;
        int i = 0;
        while (i < messages.size()) {
            Message msg = messages.get(i);
            if (msg != null && message != null && msg.getId() != null && message.getId() != null && msg.getId().equals(message.getId())) {
                newMessage = false;
                break;
            }
            ++i;
        }
        if (newMessage) {
            messages.add(message);
            MessagingManager.sortMessages();
            MessagingManager.notifyListeners(message, 0);
        }
    }

    public static void removeMessage(Message message) {
        message.setDeleted(true);
        MessagingManager.notifyListeners(message, 1);
    }

    public static void purgeMessage(Message message) {
        message.setPurged(true);
        messages.remove(message);
        MessagingManager.notifyListeners(message, 4);
    }

    private static void sortMessages() {
        Collections.sort(messages, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                if (m1.isUrgent() && !m2.isUrgent()) {
                    return -1;
                }
                if (!m1.isUrgent() && m2.isUrgent()) {
                    return 1;
                }
                if (m1.getDate() == null && m2.getDate() != null) {
                    return 1;
                }
                if (m1.getDate() != null && m2.getDate() == null) {
                    return -1;
                }
                if (m1.getDate() != null && m2.getDate() != null) {
                    return m1.getDate().after(m2.getDate()) ? -1 : 1;
                }
                return 0;
            }
        });
    }

    public static void startMessageService() {
        MessagingManager.loadCustomFeeds();
        MessagingManager.loadUpdateSiteFeeds();
        Job job = new Job("Initializing message loader"){

            protected IStatus run(IProgressMonitor monitor) {
                MessagingManager.getNewMessages(lastChecked);
                lastChecked = new Date();
                this.schedule(INTERVAL_CHECK);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(30);
        job.schedule(180000L);
    }

    public static void loadCustomFeeds() {
        FeedDescriptor[] feeds = MessagingManager.getFeeds();
        int i = 0;
        while (i < feeds.length) {
            MessagingManager.addFeed(feeds[i]);
            ++i;
        }
    }

    public static void loadUpdateSiteFeeds() {
        Map<String, String> sites = MessagesReader.getUpdateSites();
        Set<String> keys = sites.keySet();
        for (String object : keys) {
            MessagingManager.addFeed(new FeedDescriptor(sites.get(object), object, INTERVAL_DAY, null, true));
        }
    }

    public static synchronized List<Message> loadStoredMessages() {
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Message> stored = MessagingPreferences.getInstance().loadPreferences();
        if (stored != null) {
            int i = 0;
            while (i < stored.size()) {
                Message curr = stored.get(i);
                String description = curr.getContent();
                if (description != null && !"null".equals(description.trim())) {
                    messages.add(curr);
                }
                ++i;
            }
        }
        return messages;
    }

    public static synchronized List<Message> getMessages() {
        if (messages == null) {
            messages = MessagingManager.loadStoredMessages();
            MessagingManager.sortMessages();
        }
        return messages;
    }

    public static synchronized void getNewMessages(final Date since) {
        Job job = new Job("Loading messages"){

            protected IStatus run(IProgressMonitor monitor) {
                FeedDescriptor[] overdue = MessagingManager.getOverdueFeeds(since);
                MessagingManager.loadRemoteMessages(overdue, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule(0L);
    }

    public static String[] extractFeedUrls(FeedDescriptor[] feeds) {
        ArrayList<String> list = new ArrayList<String>();
        FeedDescriptor[] feedDescriptorArray = feeds;
        int n = 0;
        int n2 = feedDescriptorArray.length;
        while (n < n2) {
            FeedDescriptor feedDescriptor = feedDescriptorArray[n];
            list.add(feedDescriptor.getUrl());
            ++n;
        }
        return list.toArray(new String[list.size()]);
    }

    public static FeedDescriptor[] getOverdueFeeds(Date date) {
        Collection<FeedDescriptor> feeds = feedMap.values();
        ArrayList<FeedDescriptor> overdue = new ArrayList<FeedDescriptor>();
        for (FeedDescriptor feedDescriptor : feeds) {
            if (Math.abs(date.getTime() - feedDescriptor.getLastPoll().getTime()) <= feedDescriptor.getPollInterval()) continue;
            overdue.add(feedDescriptor);
        }
        return overdue.toArray(new FeedDescriptor[overdue.size()]);
    }

    public static void storeMessages() {
        MessagingPreferences.getInstance().savePreferences(messages);
    }

    public static void storeFeeds() {
        IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
        if (store != null) {
            store.setValue("com.aptana.ide.intro.MESSAGE_CENTER_FEEDS", FeedDescriptor.serializeFeedDescriptors(feedMap.values().toArray(new FeedDescriptor[0])));
        }
    }

    public static FeedDescriptor[] getFeeds() {
        IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
        if (store == null) {
            return new FeedDescriptor[0];
        }
        String editors = store.getString("com.aptana.ide.intro.MESSAGE_CENTER_FEEDS");
        return FeedDescriptor.deserializeFeedDescriptors(editors);
    }
}

