/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.licensing;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.intro.FeatureInstallJob;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.preferences.FeatureDescriptor;
import com.aptana.ide.intro.preferences.FeatureRegistry;
import com.aptana.ide.intro.preferences.ProFeatureDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.standalone.EnableCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProFeatureUtilities {
    public static void setPrefAndRegistry(final String key, final String email) {
        UIJob job = new UIJob("Setting licensing info in prefences page."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ApplicationPreferences.getInstance().setString("com.aptana.ide.core.ui.ACTIVATION_EMAIL_ADDRESS", email);
                ApplicationPreferences.getInstance().setString("com.aptana.ide.core.ui.ACTIVATION_KEY", key);
                ApplicationPreferences.getInstance().savePreferences();
                String regPath = "HKCU\\Software\\Aptana\\Aptana Studio Professional";
                PlatformUtils.setRegestryStringValue((String)regPath, (String)"LicenseKey", (String)key);
                PlatformUtils.setRegestryStringValue((String)regPath, (String)"Registered", (String)email);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    public static final boolean areInstalledProFeaturesEnabled() {
        List<String> toEnable = ProFeatureUtilities.getUnabledProFeatures();
        return toEnable != null && toEnable.size() == 0;
    }

    static final boolean isProInstalled() {
        List<ProFeatureDescriptor> features = FeatureRegistry.getProFeatures();
        for (ProFeatureDescriptor descriptor : features) {
            if (!CoreUIUtils.isFeatureInstalled((String)descriptor.getFeatureId())) continue;
            return true;
        }
        return false;
    }

    private static final boolean isProInstalledButDisabled(String featureId) {
        return CoreUIUtils.isFeatureInstalled((String)featureId) && !CoreUIUtils.isFeatureEnabled((String)featureId);
    }

    static final List<String> getUnabledProFeatures() {
        ArrayList<String> toEnable = new ArrayList<String>();
        List<ProFeatureDescriptor> features = FeatureRegistry.getProFeatures();
        for (ProFeatureDescriptor descriptor : features) {
            if (!ProFeatureUtilities.isProInstalledButDisabled(descriptor.getFeatureId())) continue;
            toEnable.add(descriptor.getFeatureId());
        }
        return toEnable;
    }

    public static final void enableProFeature(boolean promptUser) {
        final List<String> toEnable = ProFeatureUtilities.getUnabledProFeatures();
        if (toEnable != null && toEnable.size() > 0) {
            if (!promptUser) {
                ProFeatureUtilities.enableFeatures(toEnable, promptUser);
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Pro Features enabled.");
            } else {
                UIJob job = new UIJob("Enable Pro Feature"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog dialog = new MessageDialog(CoreUIUtils.getActiveShell(), "Re-Enable Aptana Studio Pro", null, "The Professional feature is currently disabled. Once enabled, studio features will be visible upon restart.\n\nWould you like to enable it now?", 3, new String[]{"Yes", "No"}, 0);
                        int rc = dialog.open();
                        if (rc == 0) {
                            ProFeatureUtilities.enableFeatures(toEnable, true);
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Pro Features enabled.");
                        } else {
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Pro Features not enabled.");
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.schedule();
            }
        }
    }

    public static final void enableFeatures(List<String> toEnable, boolean promptUser) {
        for (String featureId : toEnable) {
            try {
                EnableCommand enabler = new EnableCommand(featureId, null, null, null);
                enabler.run();
                if (!promptUser) continue;
                ProFeatureUtilities.promptUserForRestart();
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)("Unable to enable professional feature: " + featureId), (Throwable)e);
            }
        }
        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Enabled Pro Features, user must restart.");
    }

    private static final void addUpdateSite(String name, String url) {
        try {
            if (!ProFeatureUtilities.siteBookmarkExists(name)) {
                UpdateModel model = UpdateUI.getDefault().getUpdateModel();
                SiteBookmark bookmark = new SiteBookmark(name, new URL(url), false);
                model.addBookmark((NamedModelObject)bookmark);
                model.saveBookmarks();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)("Error adding update site:" + url), (Throwable)e);
        }
    }

    private static final boolean siteBookmarkExists(String name) {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        NamedModelObject[] bookmarks = model.getBookmarks();
        if (bookmarks != null) {
            int i = 0;
            while (i < bookmarks.length) {
                SiteBookmark bm;
                if (bookmarks[i] instanceof SiteBookmark && name.equals((bm = (SiteBookmark)bookmarks[i]).getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final boolean isUninstalledProFeaturesAvailable() {
        List<FeatureDescriptor> proFeatures = FeatureRegistry.gatherUninstalledProFeatures();
        return proFeatures != null && proFeatures.size() != 0;
    }

    public static final void scheduleProFeatureInstall() {
        List<FeatureDescriptor> proFeatures = FeatureRegistry.gatherUninstalledProFeatures();
        FeatureInstallJob job = new FeatureInstallJob(proFeatures);
        job.schedule();
    }

    public static void addProUpdateSites() {
        List<ProFeatureDescriptor> features = FeatureRegistry.getProFeatures();
        for (ProFeatureDescriptor descriptor : features) {
            ProFeatureUtilities.addUpdateSite(descriptor.getLabel(), descriptor.getUrl());
        }
    }

    public static final void addProFunctionalityInteractive() {
        ProFeatureUtilities.addProUpdateSites();
        UIJob job = new UIJob("Turning on Professional Features"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ProFeatureUtilities.isUninstalledProFeaturesAvailable()) {
                    MessageDialog dialog = new MessageDialog(CoreUIUtils.getActiveShell(), "Download Pro Features", null, "Unable to validate your key without Pro features installed.\nWould you like to download and install Pro features now?", 3, new String[]{"Yes", "No"}, 0);
                    int rc = dialog.open();
                    if (rc == 0) {
                        ProFeatureUtilities.scheduleProFeatureInstall();
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"User accepted Pro feature install and restarting.");
                    } else {
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"User canceled Pro feature");
                    }
                } else if (!ProFeatureUtilities.areInstalledProFeaturesEnabled()) {
                    IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"User enabled Pro feature and needs to restart.");
                    ProFeatureUtilities.enableProFeature(true);
                } else {
                    IdeLog.logImportant((Plugin)IntroPlugin.getDefault(), (String)"No ClientKeyProvider available, but Pro is installed & enabled. User needs to restart.");
                    MessageDialog.openInformation((Shell)CoreUIUtils.getActiveShell(), (String)"Restart Aptana", (String)"Your Pro features are installed and enabled.  You must restart to make these features available.");
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    static final void promptUserForRestart() {
        UIJob job = new UIJob("Restarting IDE"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Job[] jobs = Platform.getJobManager().find((Object)"earlyStartup");
                if (jobs.length > 0) {
                    Job[] jobArray = jobs;
                    int n = 0;
                    int n2 = jobArray.length;
                    while (n < n2) {
                        Job job = jobArray[n];
                        if (job.getState() != 0) {
                            this.schedule(100L);
                            return Status.OK_STATUS;
                        }
                        ++n;
                    }
                }
                UpdateUI.getDefault();
                UpdateUI.requestRestart((boolean)true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }
}

