/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.intro.actions.StartPortalAction;
import com.aptana.ide.server.jetty.portal.PortalEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;
import org.eclipse.ui.progress.UIJob;

public class StartPageTrimWidget
extends AbstractWorkbenchTrimWidget {
    private static final String ICON = "icons/identity.png";
    private static final String HOME_ICON = "icons/aptana_home.png";
    private static final String UP_ARROW = "icons/up_arrow.png";
    private static final String DOWN_ARROW = "icons/down_arrow.png";
    static final String ID_URL = "http://www.aptana.com/aptana_id";
    private static final String MYCLOUD_ICON = "icons/my_cloud.png";
    private static final String MYACCOUNT_ICON = "icons/my_account.png";
    private static final String HOME_URL = "http://www.aptana.com";
    private static final String HOME_URL_DISPLAY = "www.aptana.com";
    private static final String HOME_URL_ICON = "icons/window1616.png";
    private Composite displayArea;
    private Link accountNameLabel;
    private Cursor hand;
    private User user = AptanaUser.getSignedInUser();

    public StartPageTrimWidget() {
        this.user.addListener(new IModelListener(){

            public void modelChanged(IModifiableObject object) {
                UIJob job = new UIJob("Updating label"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        StartPageTrimWidget.this.updateLabel();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (StartPageTrimWidget.this.displayArea != null && !StartPageTrimWidget.this.displayArea.isDisposed()) {
                    StartPageTrimWidget.this.displayArea.setVisible(WebPerspectiveFactory.isValidAptanaPerspective((IPerspectiveDescriptor)perspective));
                }
            }
        });
    }

    private void updateLabel() {
        if (this.accountNameLabel == null || this.accountNameLabel.isDisposed()) {
            return;
        }
        if (this.user.getUsername() != null && this.user.getUsername().length() > 0) {
            this.accountNameLabel.setText("<a>" + this.user.getUsername() + "</a>");
            this.accountNameLabel.setToolTipText(String.valueOf(this.user.getUsername()) + " @ " + Messages.StartPageTrimWidget_MyAptana);
        } else {
            this.accountNameLabel.setText("<a>" + Messages.StartPageTrimWidget_SignIn + "</a>");
            this.accountNameLabel.setToolTipText(Messages.StartPageTrimWidget_MyAptana);
        }
        this.adjustLink();
    }

    public void dispose() {
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.dispose();
        }
    }

    private void loadMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setImage(IntroPlugin.getImage(ICON));
        if (this.user.hasCredentials()) {
            item.setText(Messages.StartPageTrimWidget_SignOut);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AptanaUser.signOut();
                }
            });
        } else {
            item.setText(Messages.StartPageTrimWidget_SignIn);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StartPageTrimWidget.this.signIn();
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_ID_HELP);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CoreUIUtils.openBrowserURL((String)StartPageTrimWidget.ID_URL);
                }
            });
        }
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText(Messages.StartPageTrimWidget_MyAptana);
        item.setImage(IntroPlugin.getImage(HOME_ICON));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartPortalAction.openPortalEditor();
            }
        });
        if (this.user.hasCredentials()) {
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_MyCloud);
            item.setImage(IntroPlugin.getImage(MYCLOUD_ICON));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StartPortalAction.openPortalEditor("my_cloud");
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_MyAccount);
            item.setImage(IntroPlugin.getImage(MYACCOUNT_ICON));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StartPortalAction.openPortalEditor("my_account");
                }
            });
        }
        item = new MenuItem(menu, 8);
        item.setText(HOME_URL_DISPLAY);
        item.setImage(IntroPlugin.getImage(HOME_URL_ICON));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL((String)StartPageTrimWidget.HOME_URL);
            }
        });
    }

    private void signIn() {
        PortalEditor.signIn();
    }

    private void adjustLink() {
        GridData anlData = (GridData)this.accountNameLabel.getLayoutData();
        int size = this.accountNameLabel.computeSize((int)-1, (int)-1).x + 5;
        if (size > 120) {
            size = 120;
            GC gc = new GC((Drawable)this.accountNameLabel);
            int width = gc.getFontMetrics().getAverageCharWidth();
            int dotsSize = gc.stringExtent((String)"...").x;
            int remaining = size - dotsSize;
            int charCount = remaining / width;
            String label = this.accountNameLabel.getText();
            if (label.length() > charCount) {
                this.accountNameLabel.setText(String.valueOf(label.substring(0, charCount)) + "...</a>");
            }
            gc.dispose();
        }
        anlData.widthHint = size;
        this.displayArea.layout(true, true);
        this.displayArea.getParent().layout(true, true);
    }

    public void fill(Composite parent, int oldSide, int newSide) {
        if (this.hand == null || this.hand.isDisposed()) {
            this.hand = new Cursor((Device)Display.getDefault(), 21);
        }
        if (this.displayArea == null || this.displayArea.isDisposed()) {
            this.displayArea = new Composite(parent, 0);
            this.displayArea.setToolTipText(Messages.StartPageTrimWidget_MyAptana);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.displayArea.setLayout((Layout)layout);
            final Composite main = new Composite(this.displayArea, 0);
            main.setToolTipText(Messages.StartPageTrimWidget_MyAptana);
            layout = new GridLayout(3, false);
            layout.marginHeight = 2;
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            main.setLayout((Layout)layout);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 170;
            main.setLayoutData((Object)gridData);
            Label cloudIcon = new Label(main, 16384);
            cloudIcon.setCursor(this.hand);
            cloudIcon.setImage(IntroPlugin.getImage(HOME_ICON));
            cloudIcon.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    StartPortalAction.openPortalEditor();
                }
            });
            cloudIcon.setToolTipText(Messages.StartPageTrimWidget_MyAptana);
            this.accountNameLabel = new Link(main, 0);
            this.accountNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.accountNameLabel.setToolTipText(Messages.StartPageTrimWidget_MyAptana);
            this.accountNameLabel.setText("<a>" + Messages.StartPageTrimWidget_SignIn + "</a>");
            this.accountNameLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AptanaUser.getSignedInUser().hasCredentials()) {
                        StartPortalAction.openPortalEditor();
                    } else {
                        StartPageTrimWidget.this.signIn();
                    }
                }
            });
            this.updateLabel();
            final ToolBar arrowBar = new ToolBar(main, 64);
            ToolItem arrowItem = new ToolItem(arrowBar, 8);
            if (newSide == 1024) {
                arrowItem.setImage(IntroPlugin.getImage(UP_ARROW));
            } else {
                arrowItem.setImage(IntroPlugin.getImage(DOWN_ARROW));
            }
            arrowItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rectangle rect = arrowBar.getBounds();
                    Point pt = new Point(rect.x, rect.y);
                    pt = main.toDisplay(pt);
                    Menu menu = new Menu((Control)main);
                    menu.setLocation(pt);
                    StartPageTrimWidget.this.loadMenu(menu);
                    menu.setVisible(true);
                }
            });
            IWorkbenchPage page = CoreUIPlugin.getActivePage();
            if (page != null && page.getPerspective() != null) {
                this.displayArea.setVisible(WebPerspectiveFactory.isValidAptanaPerspective((IPerspectiveDescriptor)page.getPerspective()));
            }
        }
    }
}

