/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.intro.FeatureChange;
import com.aptana.ide.intro.FeatureChangeManager;
import com.aptana.ide.intro.FeatureInstallJob;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.StartPortalAction;
import com.aptana.ide.intro.preferences.FeatureDescriptor;
import com.aptana.ide.intro.preferences.FeatureRegistry;
import com.aptana.ide.server.portal.PortalPlugin;
import com.aptana.ide.server.portal.ui.MyAptanaEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;

public class IntroStartup
implements IStartup {
    public static final String IGNORE = "ignore.initial.my.aptana";

    public void earlyStartup() {
        this.showMyAptana();
        this.installFeatures();
    }

    protected void showMyAptana() {
        block25: {
            List<FeatureChange> changeList;
            boolean portalPreviouslyOpened;
            boolean shownPreviously;
            String showStartPage;
            IPreferenceStore store;
            block24: {
                store = IntroPlugin.getDefault().getPreferenceStore();
                showStartPage = store.getString("com.aptana.ide.intro.SHOW_STARTPAGE_ON_STARTUP");
                if (!store.getBoolean("com.aptana.ide.intro.SHOW_STARTPAGE_FORCED")) {
                    showStartPage = "true";
                    store.setValue("com.aptana.ide.intro.SHOW_STARTPAGE_ON_STARTUP", showStartPage);
                    store.setValue("com.aptana.ide.intro.SHOW_STARTPAGE_FORCED", true);
                }
                shownPreviously = store.getBoolean("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY") || "true".equals(System.getProperty(IGNORE));
                portalPreviouslyOpened = PortalPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.server.portal.MY_APTANA_PREVIOUSLY_OPENED");
                boolean changed = FeatureChangeManager.getManager().areFeaturesChanged();
                changeList = null;
                try {
                    try {
                        if (changed) {
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Features Changed");
                            changeList = FeatureChangeManager.getManager().getFeatureChangeList();
                            if (showStartPage.equals("aptana")) {
                                ArrayList<FeatureChange> aptanaList = new ArrayList<FeatureChange>();
                                int i = 0;
                                while (i < changeList.size()) {
                                    FeatureChange change = changeList.get(i);
                                    IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)("Feature ID: " + change.getId() + " Feature Label: " + change.getLabel() + " From version " + change.getOldVersion() + " to " + change.getNewVersion()));
                                    if (change.getProvider() != null && change.getProvider().indexOf("Aptana") != -1) {
                                        aptanaList.add(change);
                                    }
                                    ++i;
                                }
                                changeList = aptanaList;
                            }
                            if (showStartPage.equals("false")) {
                                changeList = null;
                            }
                        } else {
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Unchanged feature store");
                        }
                    }
                    catch (Exception exception) {
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (!shownPreviously) {
                        try {
                            store.setValue("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY", true);
                            IntroPlugin.getDefault().savePluginPreferences();
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error saving shown previously preference", (Throwable)e);
                        }
                    }
                    if (!MyAptanaEditor.isOpen() && (changeList != null && changeList.size() > 0 || showStartPage.equals("true") || !shownPreviously || portalPreviouslyOpened)) {
                        UIJob job = new UIJob("Showing My Aptana"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IWorkbenchPart activePart = null;
                                IWorkbenchPage page = null;
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                if (window != null) {
                                    page = window.getActivePage();
                                    activePart = page.getActivePart();
                                }
                                StartPortalAction.openPortalEditor(false);
                                if (activePart != null) {
                                    page.activate(activePart);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    throw throwable;
                }
                if (!shownPreviously) {
                    try {
                        store.setValue("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY", true);
                        IntroPlugin.getDefault().savePluginPreferences();
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error saving shown previously preference", (Throwable)e);
                    }
                }
                if (!MyAptanaEditor.isOpen() && (changeList != null && changeList.size() > 0 || showStartPage.equals("true") || !shownPreviously || portalPreviouslyOpened)) {
                    UIJob job = new /* invalid duplicate definition of identical inner class */;
                    job.schedule();
                }
                break block25;
            }
            if (!shownPreviously) {
                try {
                    store.setValue("com.aptana.ide.intro.IS_PORTAL_SHOWN_PREVIOUSLY", true);
                    IntroPlugin.getDefault().savePluginPreferences();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error saving shown previously preference", (Throwable)e);
                }
            }
            if (!MyAptanaEditor.isOpen() && (changeList != null && changeList.size() > 0 || showStartPage.equals("true") || !shownPreviously || portalPreviouslyOpened)) {
                UIJob job = new /* invalid duplicate definition of identical inner class */;
                job.schedule();
            }
        }
    }

    protected void installFeatures() {
        boolean check = CoreUIPlugin.getDefault().getPreferenceStore().getBoolean("enabled");
        if (check) {
            List<FeatureDescriptor> featuresToUpdate;
            UIJob job;
            ArrayList<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();
            String[] installedFeatures = CoreUIUtils.getInstalledFeatureIds();
            ClientKey key = CoreUIPlugin.getActivationKey();
            if (key != null && key.isValid() && (key.isPro() || !key.isTrial() || !key.isExpired())) {
                features.addAll(FeatureRegistry.gatherUninstalledProFeatures());
            }
            features.addAll(FeatureRegistry.gatherUninstalledRequiredFeatures());
            final IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
            String[] ignored = store.getString("com.aptana.ide.intro.IGNORE_INSTALL_FEATURES").split(",");
            final ArrayList<FeatureDescriptor> featuresToInstall = new ArrayList<FeatureDescriptor>();
            for (FeatureDescriptor featureDescriptor : features) {
                if (FeatureRegistry.isFeatureIgnored(featureDescriptor.getFeatureId(), ignored) || FeatureRegistry.doesFeatureConflict(featureDescriptor, installedFeatures)) continue;
                featuresToInstall.add(featureDescriptor);
            }
            if (featuresToInstall.size() > 0 && !store.getString("com.aptana.ide.intro.HIDE_DIALOG_INSTALL_PROMPT").equals("never")) {
                String tmp_str = "";
                for (FeatureDescriptor featureDesc : featuresToInstall) {
                    tmp_str = String.valueOf(tmp_str) + "\n\t" + featureDesc.getLabel();
                }
                final String str_features = tmp_str;
                job = new UIJob("Installing New Features"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        int returnCode = DialogUtils.openIgnoreMessageDialogConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Aptana Studio Feature Installation", (String)("Aptana Studio needs to install the following new functionality:\n" + str_features + "\n\n Continue?"), (IPreferenceStore)store, (String)"com.aptana.ide.intro.HIDE_DIALOG_INSTALL_PROMPT");
                        IntroPlugin.getDefault().savePluginPreferences();
                        if (returnCode == 1) {
                            return Status.OK_STATUS;
                        }
                        new FeatureInstallJob(featuresToInstall).schedule(0L);
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)MutexJobRule.getInstance());
                job.schedule(20000L);
            }
            if ((featuresToUpdate = FeatureRegistry.gatherInstalledRequiredFeatures()).size() > 0) {
                final StringBuilder featureToUpdateStr = new StringBuilder();
                for (FeatureDescriptor featureDesc : featuresToUpdate) {
                    featureToUpdateStr.append("\n\t" + featureDesc.getLabel());
                }
                job = new UIJob("Updating Features"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!this.needsUpdate(featuresToUpdate)) {
                            return Status.OK_STATUS;
                        }
                        boolean returnCode = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Aptana Studio Feature Update", (String)("Aptana Studio needs to update the following functionality:\n" + featureToUpdateStr.toString() + "\n\n Continue?"));
                        IntroPlugin.getDefault().savePluginPreferences();
                        if (!returnCode) {
                            return Status.OK_STATUS;
                        }
                        new FeatureInstallJob(featuresToUpdate).schedule(0L);
                        return Status.OK_STATUS;
                    }

                    private boolean needsUpdate(List<FeatureDescriptor> features) {
                        UpdateSearchScope scope = new UpdateSearchScope();
                        for (FeatureDescriptor descriptor : features) {
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)("Adding search site:" + descriptor.getUrl()));
                            try {
                                scope.addSearchSite(descriptor.getLabel(), new URL(descriptor.getUrl()), new String[0]);
                            }
                            catch (MalformedURLException malformedURLException) {
                                return false;
                            }
                        }
                        if (scope.getSearchSites().length == 0) {
                            return false;
                        }
                        UpdateSearchRequest request = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), scope);
                        request.addFilter((IUpdateSearchFilter)new BackLevelFilter());
                        request.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
                        UpdateJob job = new UpdateJob("Searching for update", request);
                        job.setSystem(true);
                        job.schedule();
                        try {
                            job.join();
                        }
                        catch (InterruptedException interruptedException) {
                            return false;
                        }
                        return job.getUpdates().length > 0;
                    }
                };
                job.setRule((ISchedulingRule)MutexJobRule.getInstance());
                job.schedule(20000L);
            }
        }
    }
}

