/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.views.console;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.viewers.IOConsoleViewer;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.framework.jaxer.views.console.BrowserCommunicator;
import com.aptana.ide.framework.jaxer.views.console.Communicator;
import com.aptana.ide.framework.jaxer.views.console.ICommunicatorListener;
import com.aptana.ide.framework.jaxer.views.console.JaxerConsoleView;
import com.aptana.ide.framework.jaxer.views.console.Messages;
import com.aptana.ide.server.ui.views.actions.OpenLogAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.themes.IThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxerLogViewer
extends Composite {
    private static final String VIEW_LOG = Messages.JaxerLogViewer_VIEW_LOG;
    private Color inputColor = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("com.aptana.ide.core.ui.apearance.jaxer.input");
    private Color outputColor = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("com.aptana.ide.core.ui.apearance.jaxer.output");
    private Color errorColor = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("com.aptana.ide.core.ui.apearance.jaxer.error");
    boolean lastError;
    private String hostName;
    private volatile boolean ignoreSend;
    private final IOConsole console = new IOConsole("Jaxer Console", "jaxer", null, false);
    private final IOConsoleOutputStream newOutputStream = this.console.newOutputStream();
    private IOConsoleViewer consoleViewer;
    private ColorSynchronizer colorSynchronizer;
    private String lastInput;
    private IAction copyActionHandler;
    private IAction cutActionHandler;
    private IAction pasteActionHandler;
    private static final String ERROR_COLOR_ID = "com.aptana.ide.core.ui.apearance.jaxer.error";
    private static final String OUTPUT_COLOR_ID = "com.aptana.ide.core.ui.apearance.jaxer.output";
    private static final String INPUT_COLOR_ID = "com.aptana.ide.core.ui.apearance.jaxer.input";
    private Communicator communicator;
    private JaxerConsoleView view;
    private JaxerServer server;
    private boolean connected;

    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener((IPropertyChangeListener)this.colorSynchronizer);
        super.dispose();
    }

    void hookCopyPasteToConsole() {
        if (this.copyActionHandler != null) {
            return;
        }
        IActionBars actionBars = this.view.getViewSite().getActionBars();
        this.copyActionHandler = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.cutActionHandler = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.pasteActionHandler = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                JaxerLogViewer.this.doCopy();
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new Action(){

            public void run() {
                JaxerLogViewer.this.doCopy();
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action(){

            public void run() {
                JaxerLogViewer.this.doPaste();
            }
        });
        this.view.getViewSite().getActionBars().updateActionBars();
    }

    void restoreCopyPaste() {
        if (this.copyActionHandler == null) {
            return;
        }
        IActionBars actionBars = this.view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteActionHandler);
        this.copyActionHandler = null;
        this.cutActionHandler = null;
        this.pasteActionHandler = null;
        this.view.getViewSite().getActionBars().updateActionBars();
    }

    public JaxerLogViewer(Composite parent, int style, JaxerConsoleView view) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        this.createLog(this);
        this.communicator = new BrowserCommunicator(parent);
        this.communicator.addListener(new ICommunicatorListener(){

            public void textReceived(String text) {
                try {
                    try {
                        if (text.length() == 0) {
                            return;
                        }
                        JaxerLogViewer.this.newOutputStream.setColor(JaxerLogViewer.this.outputColor);
                        JaxerLogViewer.this.lastError = false;
                        JaxerLogViewer.this.newOutputStream.write(StringUtils.format((String)"{0}\n", (String)text));
                    }
                    catch (IOException e) {
                        IdeLog.log((Plugin)JaxerPlugin.getDefault(), (int)4, (String)"IO Exception while writing to console", (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    return;
                }
            }

            public void connectionStateChange(boolean connected) {
                JaxerLogViewer.this.internalSetStatus(connected);
                if (!connected) {
                    try {
                        JaxerLogViewer.this.printConnectionFailed();
                    }
                    catch (IOException e) {
                        JaxerLogViewer.this.logIOException(e);
                    }
                } else {
                    try {
                        JaxerLogViewer.this.newOutputStream.write(StringUtils.format((String)"{0}\n", (String)Messages.BrowserCommunicator_IAMJAXER));
                    }
                    catch (IOException e) {
                        JaxerLogViewer.this.logIOException(e);
                    }
                }
            }
        });
        this.console.getInputStream().setColor(this.inputColor);
        this.consoleViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (JaxerLogViewer.this.consoleViewer != null) {
                    int len = event.getDocument().getLength();
                    StyledText textWidget = JaxerLogViewer.this.consoleViewer.getTextWidget();
                    if (textWidget != null && !textWidget.isDisposed()) {
                        textWidget.setCaretOffset(len);
                        JaxerLogViewer.this.consoleViewer.revealRange(len, 0);
                    }
                }
            }
        });
        PreferenceUtils.registerFontPreference((Control)this.consoleViewer.getTextWidget(), (String)"com.aptana.ide.framework.jaxer.consoleFont");
        PreferenceUtils.registerBackgroundColorPreference((Control)this.consoleViewer.getTextWidget(), (String)"com.aptana.ide.core.ui.background.color.jaxer");
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.colorSynchronizer = new ColorSynchronizer(themeManager);
        themeManager.addPropertyChangeListener((IPropertyChangeListener)this.colorSynchronizer);
    }

    private void createLog(Composite frm) {
        this.consoleViewer = new CustomIOViewer(frm, (TextConsole)this.console);
        this.consoleViewer.getTextWidget().setEditable(false);
        this.consoleViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001 && JaxerLogViewer.this.lastInput != null) {
                    try {
                        JaxerLogViewer.this.console.getDocument().replace(JaxerLogViewer.this.console.getDocument().getLength(), 0, JaxerLogViewer.this.lastInput);
                    }
                    catch (BadLocationException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        });
        this.newOutputStream.setColor(this.outputColor);
        try {
            this.newOutputStream.write(StringUtils.format((String)"{0}\n", (String)Messages.JaxerConsoleView_SERVER_NOT_CONNECTED));
        }
        catch (IOException e) {
            this.logIOException(e);
        }
    }

    void logIOException(IOException e) {
        IdeLog.log((Plugin)JaxerPlugin.getDefault(), (int)4, (String)"error while writing to console", (Throwable)e);
    }

    public void sendText(String string) {
        try {
            String lineDelimiter = this.console.getDocument().getLegalLineDelimiters()[0];
            this.ignoreSend = true;
            String toSend = string.trim();
            if (lineDelimiter.equals("\r")) {
                this.console.getDocument().replace(this.console.getDocument().getLength(), 0, String.valueOf(toSend) + lineDelimiter);
            } else {
                this.console.getDocument().replace(this.console.getDocument().getLength(), 0, toSend);
                this.console.getDocument().replace(this.console.getDocument().getLength(), 0, lineDelimiter);
            }
            this.communicator.sendText(toSend);
            this.ignoreSend = false;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public JaxerServer getServer() {
        return this.server;
    }

    public void setServer(JaxerServer server) {
        this.server = server;
        this.communicator.setServer(server);
    }

    public boolean initCommunicator(JaxerServer js) {
        this.setServer(js);
        this.hostName = js.getConsoleAddress();
        if (js.getServerState() != 2) {
            IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("js.getServerState() returned that server is not running - state(" + js.getServerState() + ")"));
            try {
                this.printConnectionFailed();
                return false;
            }
            catch (IOException e) {
                this.logIOException(e);
                return false;
            }
        }
        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("js.getServerState() returned that server is running - state(" + js.getServerState() + ")"));
        return this.communicator.initCommunicator(this.hostName);
    }

    public void clear() {
        this.console.clearConsole();
    }

    public void doSave() {
        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dlg.setText(Messages.JaxerLogViewer_SAVE_SESSION);
        dlg.setFilterExtensions(new String[]{"*.txt"});
        dlg.setFilterNames(new String[]{Messages.JaxerLogViewer_TEXT_FILE});
        String open = dlg.open();
        if (open != null) {
            try {
                FileWriter fl = new FileWriter(new File(open));
                try {
                    String string = this.consoleViewer.getDocument().get();
                    string = string.replace("\r\n", "\n");
                    string = string.replace("\r", "\n");
                    String replace = string.replace("\n", System.getProperty("line.separator"));
                    fl.write(replace);
                }
                finally {
                    fl.close();
                }
            }
            catch (IOException e) {
                this.logIOException(e);
            }
        }
    }

    void printConnectionFailed() throws IOException {
        this.lastError = true;
        if (this.server.getServerState() != 2) {
            this.newOutputStream.write(StringUtils.format((String)"{0} {1}\n", (Object[])new Object[]{Messages.JaxerLogViewer_ServerIsNotRunning, this.server.getLog() != null ? VIEW_LOG : ""}));
        } else if (!this.communicator.isConsoleAppAccessible()) {
            this.newOutputStream.write(StringUtils.format((String)"{0} {1}\n", (Object[])new Object[]{Messages.JaxerLogViewer_ConnectionFailed, this.server.getLog() != null ? VIEW_LOG : ""}));
        } else {
            this.newOutputStream.write(StringUtils.format((String)"{0} {1}\n", (Object[])new Object[]{Messages.JaxerLogViewer_EvaluationError, this.server.getLog() != null ? VIEW_LOG : ""}));
            this.internalSetStatus(true);
        }
    }

    public void refreshConnection() {
        this.lastError = false;
        if (this.server.getServerState() != 2) {
            try {
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("js.getServerState() returned that server is not running - state(" + this.server.getServerState() + ")"));
                this.printConnectionFailed();
            }
            catch (IOException e) {
                this.logIOException(e);
            }
            return;
        }
        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("js.getServerState() returned that server is running - state(" + this.server.getServerState() + ")"));
        this.newOutputStream.setColor(this.outputColor);
        if (!this.communicator.initCommunicator(this.hostName)) {
            try {
                this.printConnectionFailed();
                this.internalSetStatus(false);
                return;
            }
            catch (IOException e) {
                this.logIOException(e);
            }
        }
        this.internalSetStatus(true);
        this.communicator.sendText("print(\"Connected\")");
    }

    private void internalSetStatus(boolean b) {
        this.connected = b;
        this.consoleViewer.getTextWidget().setEnabled(true);
        this.view.internalSetStatus(b);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean setLogLevel(String module, boolean detailed) {
        return this.communicator.setLogLevel(module, detailed);
    }

    public BrowserCommunicator.ModuleLogLevel[] getModuleLogLevelPairs() {
        return this.communicator.getModuleLogLevelPairs();
    }

    public void setLogLevels(ArrayList<BrowserCommunicator.ModuleLogLevel> ls) {
        this.communicator.setLogLevels(ls);
    }

    public void appendError(String format) {
        try {
            this.newOutputStream.write(format);
            this.newOutputStream.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            this.logIOException(e);
        }
    }

    boolean supportsLogLevels() {
        return this.communicator.supportsLoglevels();
    }

    private void doCopy() {
        this.consoleViewer.doOperation(4);
    }

    private void doPaste() {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(this.consoleViewer.getTextWidget().getDisplay());
        String contents = (String)clipboard.getContents((Transfer)plainTextTransfer, 1);
        if (contents == null) {
            return;
        }
        this.sendText(contents);
        clipboard.dispose();
    }

    private void installMenu(final StyledText styledText) {
        MenuManager mn = new MenuManager();
        final RetargetAction paste = (RetargetAction)ActionFactory.PASTE.create(this.view.getViewSite().getWorkbenchWindow());
        final RetargetAction copy = (RetargetAction)ActionFactory.COPY.create(this.view.getViewSite().getWorkbenchWindow());
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JaxerLogViewer.this.restoreCopyPaste();
                copy.dispose();
                paste.dispose();
            }
        });
        mn.add((IAction)copy);
        mn.add((IAction)paste);
        paste.partActivated(this.view.getViewSite().getPart());
        copy.partActivated(this.view.getViewSite().getPart());
        mn.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                copy.setEnabled(styledText.getSelectionRange().y > 0);
                paste.setEnabled(true);
                manager.update();
            }
        });
        Menu createContextMenu = mn.createContextMenu((Control)styledText);
        styledText.setMenu(createContextMenu);
    }

    private final class ConsoleReader
    implements Runnable {
        private ConsoleReader() {
        }

        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)JaxerLogViewer.this.console.getInputStream()));
            while (true) {
                try {
                    String readLine;
                    while ((readLine = reader.readLine()) != null) {
                        if (JaxerLogViewer.this.ignoreSend) continue;
                        JaxerLogViewer.this.lastInput = readLine;
                        JaxerLogViewer.this.consoleViewer.getControl().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                JaxerLogViewer.this.consoleViewer.getTextWidget().setCursor(JaxerLogViewer.this.consoleViewer.getControl().getDisplay().getSystemCursor(1));
                            }
                        });
                        JaxerLogViewer.this.communicator.sendText(readLine);
                        JaxerLogViewer.this.consoleViewer.getControl().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                JaxerLogViewer.this.consoleViewer.getTextWidget().setCursor(null);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    IdeLog.log((Plugin)JaxerPlugin.getDefault(), (int)4, (String)"error while reading from console", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private final class CustomIOViewer
    extends IOConsoleViewer {
        private CustomIOViewer(Composite parent, TextConsole console) {
            super(parent, console);
        }

        protected StyledText createTextWidget(Composite parent, int styles) {
            final StyledText styledText = new StyledText(parent, styles){

                public void addLineStyleListener(LineStyleListener listener) {
                    super.addLineStyleListener((LineStyleListener)new CustomColorizer(listener));
                }
            };
            styledText.addFocusListener((FocusListener)new CommandAdapter());
            JaxerLogViewer.this.installMenu(styledText);
            styledText.addListener(5, new Listener(){
                boolean isHand = false;

                public void handleEvent(Event event) {
                    StyledTextContent content;
                    int indexOf;
                    int lineIndex = styledText.getLineIndex(event.y);
                    if (lineIndex != -1 && (indexOf = (content = styledText.getContent()).getLine(lineIndex).indexOf(VIEW_LOG)) != -1) {
                        int offsetAtLine = content.getOffsetAtLine(lineIndex);
                        try {
                            int offsetAtLocation = styledText.getOffsetAtLocation(new Point(event.x, event.y)) - offsetAtLine;
                            if (offsetAtLocation >= indexOf && offsetAtLocation < indexOf + VIEW_LOG.length()) {
                                styledText.setCursor(Display.getCurrent().getSystemCursor(21));
                                this.isHand = true;
                                return;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    if (this.isHand) {
                        styledText.setCursor(Display.getCurrent().getSystemCursor(19));
                        this.isHand = false;
                    }
                }
            });
            styledText.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    StyledTextContent content;
                    int indexOf;
                    if (JaxerLogViewer.this.server.getLog() == null) {
                        return;
                    }
                    int lineIndex = styledText.getLineIndex(event.y);
                    if (lineIndex != -1 && (indexOf = (content = styledText.getContent()).getLine(lineIndex).indexOf(VIEW_LOG)) != -1) {
                        int offsetAtLine = content.getOffsetAtLine(lineIndex);
                        int offsetAtLocation = styledText.getOffsetAtLocation(new Point(event.x, event.y)) - offsetAtLine;
                        if (offsetAtLocation >= indexOf && offsetAtLocation <= indexOf + VIEW_LOG.length()) {
                            styledText.setCursor(Display.getCurrent().getSystemCursor(21));
                            new OpenLogAction(new ISelectionProvider(this){
                                final /* synthetic */ 3 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                                }

                                public ISelection getSelection() {
                                    return new StructuredSelection((Object)JaxerLogViewer.access$7(CustomIOViewer.access$1(3.access$0(this.this$2))));
                                }

                                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                                }

                                public void setSelection(ISelection selection) {
                                }
                            }).run();
                            return;
                        }
                    }
                }

                static /* synthetic */ CustomIOViewer access$0(3 var0) {
                    return var0.CustomIOViewer.this;
                }
            });
            return styledText;
        }
    }

    private final class CommandAdapter
    implements FocusListener {
        private CommandAdapter() {
        }

        public void focusGained(FocusEvent e) {
            JaxerLogViewer.this.hookCopyPasteToConsole();
        }

        public void focusLost(FocusEvent e) {
            JaxerLogViewer.this.restoreCopyPaste();
        }
    }

    private final class CustomColorizer
    implements LineStyleListener {
        private final LineStyleListener listener;

        private CustomColorizer(LineStyleListener listener) {
            this.listener = listener;
        }

        public void lineGetStyle(LineStyleEvent event) {
            this.listener.lineGetStyle(event);
            int indexOf = event.lineText.indexOf(VIEW_LOG);
            if (indexOf != -1 && JaxerLogViewer.this.server.getLog() != null) {
                StyleRange styleRange = new StyleRange(event.lineOffset + indexOf + 1, VIEW_LOG.length() - 3, JaxerLogViewer.this.errorColor, null);
                styleRange.underline = true;
                event.styles = new StyleRange[]{new StyleRange(event.lineOffset, event.lineText.length(), JaxerLogViewer.this.errorColor, null), styleRange};
                return;
            }
            if (event.lineText.contains("Exception:") || event.lineText.contains("Connection Failed:")) {
                StyleRange styleRange = new StyleRange(event.lineOffset, event.lineText.length(), JaxerLogViewer.this.errorColor, null);
                event.styles = new StyleRange[]{styleRange};
            }
        }
    }

    private final class ColorSynchronizer
    implements IPropertyChangeListener {
        private final IThemeManager themeManager;

        private ColorSynchronizer(IThemeManager themeManager) {
            this.themeManager = themeManager;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(JaxerLogViewer.ERROR_COLOR_ID)) {
                JaxerLogViewer.this.errorColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.ERROR_COLOR_ID);
                if (JaxerLogViewer.this.lastError) {
                    JaxerLogViewer.this.newOutputStream.setColor(JaxerLogViewer.this.errorColor);
                }
            }
            if (event.getProperty().equals(JaxerLogViewer.OUTPUT_COLOR_ID)) {
                JaxerLogViewer.this.outputColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.OUTPUT_COLOR_ID);
                if (!JaxerLogViewer.this.lastError) {
                    JaxerLogViewer.this.newOutputStream.setColor(JaxerLogViewer.this.outputColor);
                }
            }
            if (event.getProperty().equals(JaxerLogViewer.INPUT_COLOR_ID)) {
                JaxerLogViewer.this.inputColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.INPUT_COLOR_ID);
                JaxerLogViewer.this.console.getInputStream().setColor(JaxerLogViewer.this.outputColor);
            } else if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                JaxerLogViewer.this.errorColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.ERROR_COLOR_ID);
                if (JaxerLogViewer.this.lastError) {
                    JaxerLogViewer.this.newOutputStream.setColor(JaxerLogViewer.this.errorColor);
                }
                JaxerLogViewer.this.outputColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.OUTPUT_COLOR_ID);
                if (!JaxerLogViewer.this.lastError) {
                    JaxerLogViewer.this.newOutputStream.setColor(JaxerLogViewer.this.outputColor);
                }
                JaxerLogViewer.this.inputColor = this.themeManager.getCurrentTheme().getColorRegistry().get(JaxerLogViewer.INPUT_COLOR_ID);
                JaxerLogViewer.this.console.getInputStream().setColor(JaxerLogViewer.this.outputColor);
            }
        }
    }
}

