/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.views.console;

import com.aptana.ide.core.Base64;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.framework.jaxer.views.console.Communicator;
import com.aptana.ide.framework.jaxer.views.console.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserCommunicator
extends Communicator {
    private static final int HTTP_READ_TIMEOUT = 10000;
    private static final String RESPONSE_FAILURE = "Failure:";
    private static final String RESPONSE_END = "</body>";
    private static final String RESPONSE_START = "<body>";
    private static final String RESPONSE_SUCCESS = "Success:";
    private static final String CMD_EXECUTE = "execute";
    private static final String CMD_GETLOGLEVELS = "getloglevels";
    private static final String CMD_SETLOGLEVEL = "setloglevel";
    private static final String CMD_SETLOGLEVELS = "setloglevels";
    private ArrayList<ModuleLogLevel> logLevels = new ArrayList();
    private String url;

    public BrowserCommunicator(Composite owner) {
    }

    @Override
    public boolean initCommunicator(String url) {
        this.url = url;
        if (url == null) {
            return false;
        }
        this.fireConnection(this.isConsoleAppAccessible());
        return true;
    }

    @Override
    public boolean isConsoleAppAccessible() {
        try {
            URL furl = new URL(this.url);
            URLConnection openConnection = furl.openConnection();
            openConnection.setReadTimeout(10000);
            InputStream inputStream = openConnection.getInputStream();
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean sendText(String text) {
        String result = this.sendToShellProxy(CMD_EXECUTE, text);
        if (result != null) {
            this.fireReceived(result);
            return true;
        }
        return false;
    }

    private String sendToShellProxy(String command, String data) {
        StringBuilder bld = new StringBuilder();
        try {
            String line;
            URL url = new URL(String.valueOf(this.url) + "?command=" + command);
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(10000);
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                bld.append(String.valueOf(line) + "\n");
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            return "Exception: " + e.getMessage() + " " + Messages.JaxerLogViewer_VIEW_LOG;
        }
        String htmlString = bld.toString();
        int beginBody = htmlString.indexOf(RESPONSE_START);
        int endBody = htmlString.indexOf(RESPONSE_END);
        if (beginBody == -1 || endBody == -1) {
            return "Exception: Invalid content in response, could not find <body>. " + Messages.JaxerLogViewer_VIEW_LOG;
        }
        String base64EncodedResult = htmlString.substring(beginBody += RESPONSE_START.length(), endBody).trim();
        boolean inErrorState = false;
        if (base64EncodedResult.startsWith(RESPONSE_SUCCESS)) {
            base64EncodedResult = base64EncodedResult.substring(RESPONSE_SUCCESS.length()).trim();
        } else if (base64EncodedResult.startsWith(RESPONSE_FAILURE)) {
            inErrorState = true;
            base64EncodedResult = base64EncodedResult.substring(RESPONSE_FAILURE.length()).trim();
        } else {
            inErrorState = true;
        }
        byte[] decodeResult = Base64.decode((String)base64EncodedResult);
        if (decodeResult == null) {
            int serverState = this.server.getServerState();
            if (serverState == 4 || serverState == 3 || serverState == 0) {
                return "Connection Failed: Server is not running. " + Messages.JaxerLogViewer_VIEW_LOG;
            }
            return "Exception: Invalid content in response, could not decode response string. " + Messages.JaxerLogViewer_VIEW_LOG;
        }
        String urlEncodedResult = new String(decodeResult);
        String finalResult = null;
        try {
            finalResult = URLDecoder.decode(urlEncodedResult, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Exception: " + e.getMessage() + " " + Messages.JaxerLogViewer_VIEW_LOG;
        }
        if (inErrorState) {
            if (finalResult == null || finalResult.length() == 0) {
                finalResult = "An undetermined error has occurred, could not process request.";
            }
            return "Exception: " + finalResult + " " + Messages.JaxerLogViewer_VIEW_LOG;
        }
        return finalResult;
    }

    @Override
    public ModuleLogLevel[] getModuleLogLevelPairs() {
        this.logLevels.clear();
        String levels = this.sendToShellProxy(CMD_GETLOGLEVELS, "");
        String[] pairs = levels.split(";");
        int i = 0;
        while (i < pairs.length) {
            String[] nameValueItem = pairs[i].split(",");
            String name = nameValueItem[0];
            boolean value = Boolean.parseBoolean(nameValueItem[1]);
            if (name.startsWith("\"")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            this.logLevels.add(new ModuleLogLevel(name, value));
            ++i;
        }
        ModuleLogLevel[] result = new ModuleLogLevel[this.logLevels.size()];
        this.logLevels.toArray(result);
        this.logLevels.clear();
        return result;
    }

    @Override
    public boolean setLogLevel(String module, boolean detailed) {
        String format = StringUtils.format((String)"\"{0}\",{1}", (Object[])new Object[]{module, detailed});
        String result = this.sendToShellProxy(CMD_SETLOGLEVEL, format);
        this.getModuleLogLevelPairs();
        return result.equals("");
    }

    @Override
    public boolean setLogLevels(List<ModuleLogLevel> ls) {
        int count = 0;
        StringBuilder bld = new StringBuilder();
        for (ModuleLogLevel l : ls) {
            if (count++ > 0) {
                bld.append(";");
            }
            bld.append(StringUtils.format((String)"\"{0}\",{1}", (Object[])new Object[]{l.moduleName, l.isVerbose}));
        }
        String result = this.sendToShellProxy(CMD_SETLOGLEVELS, bld.toString());
        if (result.equals("")) {
            this.getModuleLogLevelPairs();
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsLoglevels() {
        return true;
    }

    public static class ModuleLogLevel {
        String moduleName;
        boolean isVerbose;

        public ModuleLogLevel(String moduleName, boolean isVerbose) {
            this.moduleName = moduleName;
            this.isVerbose = isVerbose;
        }

        public String toString() {
            return this.moduleName;
        }
    }
}

