/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.dialogs;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.views.fileexplorer.FileExplorerView;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.framework.jaxer.server.dialogs.Messages;
import java.io.File;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class JaxerStatisticsDialog
extends Dialog {
    private Font boldFont;
    private Label fromJaxerLabel;
    private Label toJaxerLabel;
    private Label callbackLabel;
    private String extDir;
    private String configDir;
    private String dataDir;
    private String logFile;
    private String title;
    private String lastHearbeat;
    private String version;
    private String minProcesses;
    private String maxProcesses;
    private String timeout;
    private String fromJaxerRequests;
    private String toJaxerRequests;
    private String jaxerCallbacks;
    private JaxerServer jaxerServer;

    public JaxerStatisticsDialog(Shell parentShell, String extensionDir, String configDir, String dataDir, String logFile, String title, String lastHearbeat, String version, String minProcesses, String maxProcesses, String timeout, String fromJaxerRequests, String toJaxerRequests, String jaxerCallbacks) {
        super(parentShell);
        this.extDir = extensionDir;
        this.configDir = configDir;
        this.dataDir = dataDir;
        this.logFile = logFile;
        this.title = title;
        this.lastHearbeat = lastHearbeat;
        this.version = version;
        this.timeout = timeout;
        this.minProcesses = minProcesses;
        this.maxProcesses = maxProcesses;
        this.fromJaxerRequests = fromJaxerRequests;
        this.toJaxerRequests = toJaxerRequests;
        this.jaxerCallbacks = jaxerCallbacks;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    public boolean close() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout compLayout;
        Composite mpComp;
        FontData[] data = parent.getFont().getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        this.boldFont = new Font((Device)parent.getDisplay(), data);
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        displayArea.setLayout((Layout)new GridLayout());
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.version != null) {
            Composite vComp = new Composite(displayArea, 0);
            GridLayout vcLayout = new GridLayout(2, false);
            vcLayout.marginWidth = 0;
            vcLayout.marginHeight = 0;
            vcLayout.marginBottom = 10;
            vComp.setLayout((Layout)vcLayout);
            vComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label versionTitle = new Label(vComp, 16384);
            versionTitle.setFont(this.boldFont);
            versionTitle.setText(Messages.JaxerStatisticsDialog_Version);
            Label versionLabel = new Label(vComp, 16384);
            versionLabel.setText(this.version);
        }
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = e.widget.getData();
                if (data instanceof String) {
                    JaxerStatisticsDialog.this.showInFileExplorer((String)data);
                    JaxerStatisticsDialog.this.okPressed();
                }
            }
        };
        if (this.extDir != null) {
            Composite extComp = new Composite(displayArea, 0);
            GridLayout ecLayout = new GridLayout(2, false);
            ecLayout.marginWidth = 0;
            ecLayout.marginHeight = 0;
            ecLayout.marginBottom = 3;
            extComp.setLayout((Layout)ecLayout);
            extComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label extensionsTitle = new Label(extComp, 16384);
            extensionsTitle.setText(Messages.JaxerStatisticsDialog_Extentions);
            GridData etData = new GridData(4, 4, true, false);
            etData.horizontalSpan = 2;
            extensionsTitle.setLayoutData((Object)etData);
            extensionsTitle.setFont(this.boldFont);
            Label extensionsLabel = new Label(extComp, 16384);
            extensionsLabel.setText(FileUtils.compressPath((String)this.extDir, (int)60));
            Link extensionsButton = new Link(extComp, 8);
            extensionsButton.setData((Object)this.extDir);
            extensionsButton.setText("<a>" + Messages.JaxerStatisticsDialog_Show + "</a>");
            extensionsButton.setToolTipText(Messages.JaxerStatisticsDialog_ShowTooltip);
            extensionsButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            extensionsButton.addSelectionListener((SelectionListener)adapter);
        }
        if (this.configDir != null) {
            Composite cfgComp = new Composite(displayArea, 0);
            GridLayout ccLayout = new GridLayout(2, false);
            ccLayout.marginWidth = 0;
            ccLayout.marginHeight = 0;
            ccLayout.marginBottom = 3;
            cfgComp.setLayout((Layout)ccLayout);
            cfgComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label configTitle = new Label(cfgComp, 16384);
            configTitle.setText(Messages.JaxerStatisticsDialog_Configuration);
            GridData ctData = new GridData(4, 4, true, false);
            ctData.horizontalSpan = 2;
            configTitle.setLayoutData((Object)ctData);
            configTitle.setFont(this.boldFont);
            Label configLabel = new Label(cfgComp, 16384);
            configLabel.setText(FileUtils.compressPath((String)this.configDir, (int)60));
            Link configButton = new Link(cfgComp, 8);
            configButton.setData((Object)this.configDir);
            configButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            configButton.setText("<a>" + Messages.JaxerStatisticsDialog_Show + "</a>");
            configButton.setToolTipText(Messages.JaxerStatisticsDialog_ShowTooltip);
            configButton.addSelectionListener((SelectionListener)adapter);
        }
        if (this.dataDir != null) {
            Composite dataComp = new Composite(displayArea, 0);
            GridLayout dcLayout = new GridLayout(2, false);
            dcLayout.marginWidth = 0;
            dcLayout.marginHeight = 0;
            dcLayout.marginBottom = 3;
            dataComp.setLayout((Layout)dcLayout);
            dataComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label dataTitle = new Label(dataComp, 16384);
            dataTitle.setText(Messages.JaxerStatisticsDialog_DataDirectory);
            GridData dtData = new GridData(4, 4, true, false);
            dtData.horizontalSpan = 2;
            dataTitle.setLayoutData((Object)dtData);
            dataTitle.setFont(this.boldFont);
            Label dataLabel = new Label(dataComp, 16384);
            dataLabel.setText(FileUtils.compressPath((String)this.dataDir, (int)60));
            Link dataButton = new Link(dataComp, 8);
            dataButton.setData((Object)this.dataDir);
            dataButton.setText("<a>" + Messages.JaxerStatisticsDialog_Show + "</a>");
            dataButton.setToolTipText(Messages.JaxerStatisticsDialog_ShowTooltip);
            dataButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            dataButton.addSelectionListener((SelectionListener)adapter);
        }
        if (this.logFile != null) {
            Composite logComp = new Composite(displayArea, 0);
            GridLayout lcLayout = new GridLayout(2, false);
            lcLayout.marginWidth = 0;
            lcLayout.marginHeight = 0;
            lcLayout.marginBottom = 10;
            logComp.setLayout((Layout)lcLayout);
            logComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label logTitle = new Label(logComp, 16384);
            logTitle.setText(Messages.JaxerStatisticsDialog_LogFile);
            GridData ltData = new GridData(4, 4, true, false);
            ltData.horizontalSpan = 2;
            logTitle.setLayoutData((Object)ltData);
            logTitle.setFont(this.boldFont);
            Label logLabel = new Label(logComp, 16384);
            logLabel.setText(FileUtils.compressPath((String)this.logFile, (int)60));
            Link logButton = new Link(logComp, 8);
            logButton.setData((Object)this.logFile);
            logButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            logButton.setText("<a>" + Messages.JaxerStatisticsDialog_Show + "</a>");
            logButton.setToolTipText(Messages.JaxerStatisticsDialog_ShowTooltip);
            logButton.addSelectionListener((SelectionListener)adapter);
        }
        if (this.minProcesses != null) {
            mpComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            mpComp.setLayout((Layout)compLayout);
            mpComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label minProcessesTitle = new Label(mpComp, 16384);
            minProcessesTitle.setFont(this.boldFont);
            minProcessesTitle.setText(Messages.JaxerStatisticsDialog_MinProcesses);
            Label minProcessesLabel = new Label(mpComp, 16384);
            minProcessesLabel.setText(this.minProcesses);
        }
        if (this.maxProcesses != null) {
            mpComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            mpComp.setLayout((Layout)compLayout);
            mpComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label maxProcessesTitle = new Label(mpComp, 16384);
            maxProcessesTitle.setFont(this.boldFont);
            maxProcessesTitle.setText(Messages.JaxerStatisticsDialog_MaxProcesses);
            Label maxProcessesLabel = new Label(mpComp, 16384);
            maxProcessesLabel.setText(this.maxProcesses);
        }
        if (this.timeout != null) {
            Composite tlComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            tlComp.setLayout((Layout)compLayout);
            tlComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label timeoutTitle = new Label(tlComp, 16384);
            timeoutTitle.setFont(this.boldFont);
            timeoutTitle.setText(Messages.JaxerStatisticsDialog_Timeout);
            Label timeoutLabel = new Label(tlComp, 16384);
            timeoutLabel.setText(String.valueOf(this.timeout) + Messages.JaxerStatisticsDialog_Seconds);
        }
        if (this.lastHearbeat != null) {
            Composite lhComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            lhComp.setLayout((Layout)compLayout);
            lhComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label heartbeatTitle = new Label(lhComp, 16384);
            heartbeatTitle.setText(Messages.JaxerStatisticsDialog_LastPing);
            heartbeatTitle.setFont(this.boldFont);
            Label heartbeatLabel = new Label(lhComp, 16384);
            heartbeatLabel.setText(this.lastHearbeat);
        }
        if (this.fromJaxerRequests != null) {
            Composite fjrComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            fjrComp.setLayout((Layout)compLayout);
            fjrComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label fromJaxerTitle = new Label(fjrComp, 16384);
            fromJaxerTitle.setText(Messages.JaxerStatisticsDialog_FromJaxer);
            fromJaxerTitle.setFont(this.boldFont);
            this.fromJaxerLabel = new Label(fjrComp, 16384);
            this.fromJaxerLabel.setText(this.fromJaxerRequests);
        }
        if (this.toJaxerRequests != null) {
            Composite tjrComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            tjrComp.setLayout((Layout)compLayout);
            tjrComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label toJaxerTitle = new Label(tjrComp, 16384);
            toJaxerTitle.setText(Messages.JaxerStatisticsDialog_ToJaxer);
            toJaxerTitle.setFont(this.boldFont);
            this.toJaxerLabel = new Label(tjrComp, 16384);
            this.toJaxerLabel.setText(this.toJaxerRequests);
        }
        if (this.jaxerCallbacks != null) {
            Composite jcComp = new Composite(displayArea, 0);
            compLayout = new GridLayout(2, false);
            compLayout.marginWidth = 0;
            compLayout.marginHeight = 0;
            jcComp.setLayout((Layout)compLayout);
            jcComp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label callbackTitle = new Label(jcComp, 16384);
            callbackTitle.setText(Messages.JaxerStatisticsDialog_Callback);
            callbackTitle.setFont(this.boldFont);
            this.callbackLabel = new Label(jcComp, 16384);
            this.callbackLabel.setText(this.jaxerCallbacks);
        }
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        if (this.fromJaxerRequests != null || this.toJaxerRequests != null || this.jaxerCallbacks != null) {
            Button reset = new Button(parent, 8);
            reset.setText(Messages.JaxerStatisticsDialog_Reset);
            reset.setToolTipText(Messages.JaxerStatisticsDialog_ResetTooltip);
            reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (JaxerStatisticsDialog.this.jaxerServer != null) {
                        JaxerStatisticsDialog.this.jaxerServer.clearCallbacksSentFromJaxer();
                        JaxerStatisticsDialog.this.jaxerServer.clearRequestsSentFromJaxer();
                        JaxerStatisticsDialog.this.jaxerServer.clearRequestsSentToJaxer();
                        if (JaxerStatisticsDialog.this.fromJaxerRequests != null) {
                            JaxerStatisticsDialog.this.fromJaxerLabel.setText("0");
                        }
                        if (JaxerStatisticsDialog.this.toJaxerRequests != null) {
                            JaxerStatisticsDialog.this.toJaxerLabel.setText("0");
                        }
                        if (JaxerStatisticsDialog.this.jaxerCallbacks != null) {
                            JaxerStatisticsDialog.this.callbackLabel.setText("0");
                        }
                    }
                }
            });
            this.setButtonLayoutData(reset);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void showInFileExplorer(String path) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        LocalFile file = new LocalFile(null, new File(path));
        IWorkbench bench = JaxerPlugin.getDefault().getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            try {
                IViewPart part = page.showView("com.aptana.ide.js.ui.views.FileExplorerView");
                if (part instanceof FileExplorerView) {
                    ((FileExplorerView)part).selectAndReveal(file);
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error showing File view", (Throwable)e);
            }
        }
    }

    public JaxerServer getJaxerServer() {
        return this.jaxerServer;
    }

    public void setJaxerServer(JaxerServer jaxerServer) {
        this.jaxerServer = jaxerServer;
    }
}

