/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.project;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.project.JaxerSamplesBrowserInput;
import com.aptana.ide.framework.jaxer.project.Messages;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.browser.CoreBrowserEditor;
import com.aptana.ide.samples.handlers.IPreviewHandler;
import com.aptana.ide.samples.model.SamplesEntry;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.JettyDocumentRootResolver;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import com.aptana.ide.server.jetty.builder.JettyServerBuilder;
import com.aptana.jaxer.connectors.servlet.interfaces.IDocumentRootResolver;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.Bundle;

public class JaxerPreviewHandler
implements IPreviewHandler {
    private DisposeListener createDisposeListener(final Server endServer) {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (endServer != null) {
                    Job killJob = new Job("Stopping preview server"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                endServer.stop();
                                endServer.destroy();
                            }
                            catch (Exception e1) {
                                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Error stopping jetty preview server", (Throwable)e1);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    killJob.schedule();
                }
            }
        };
    }

    private boolean handleJaxerStarting(IServer js) {
        boolean initPreview = true;
        boolean start = MessageDialog.openQuestion((Shell)CoreUIUtils.getActiveShell(), (String)"Jaxer Server must be started to preview", (String)"The internal Jaxer server must be started to preview Jaxer samples.\nWould you like to start that server now?");
        if (start) {
            try {
                js.start("run", null, null);
            }
            catch (Exception e) {
                initPreview = false;
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Error starting internal jaxer server", (Throwable)e);
            }
        } else {
            initPreview = false;
        }
        return initPreview;
    }

    private File findIndexFile(SamplesEntry entry) {
        List entries = entry.getSubEntries();
        File index = null;
        int i = 0;
        while (i < entries.size()) {
            SamplesEntry sub = (SamplesEntry)entries.get(i);
            String name = sub.getFile().getName();
            if (name.equalsIgnoreCase("index.html") || name.equalsIgnoreCase("index.htm") || name.equalsIgnoreCase("index.HTML") || name.equalsIgnoreCase("index.HTM")) {
                index = sub.getFile();
                break;
            }
            ++i;
        }
        return index;
    }

    private UIJob createUpdateJob(final File fileIndex, final int endPort, final Server endServer, final CoreBrowserEditor editor) {
        UIJob update = new UIJob(Messages.JaxerPreviewHandler_UpdatingPreview){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                editor.addDisposeListener(JaxerPreviewHandler.this.createDisposeListener(endServer));
                String url = "http://127.0.0.1:" + endPort + "/" + fileIndex.getName();
                editor.setURL(url);
                return Status.OK_STATUS;
            }
        };
        return update;
    }

    public void previewRequested(SamplesEntry entry) {
        File index;
        ServerManager.getInstance();
        if (entry.isRoot() && (index = this.findIndexFile(entry)) != null) {
            try {
                URL url = index.toURI().toURL();
                if (url != null) {
                    Bundle b = Platform.getBundle((String)"com.aptana.ide.documentation");
                    URL content = b.getEntry("/content");
                    if (content != null) {
                        FileLocator.toFileURL((URL)content);
                    }
                    URL loading = b.getEntry("/content/loading_sample.html");
                    loading = FileLocator.toFileURL((URL)loading);
                    JaxerSamplesBrowserInput input = new JaxerSamplesBrowserInput(entry, loading);
                    input.setScript("if(document.getElementById('sampleSourceLink')) document.getElementById('sampleSourceLink').style.display='none'");
                    IWorkbenchWindow window = IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        IServer js = ServerManager.getInstance().findServer("jaxerInternalServer");
                        boolean initPreview = true;
                        if (js == null) {
                            initPreview = false;
                        } else if (js.getServerState() != 2 && js.getServerState() != 1) {
                            initPreview = this.handleJaxerStarting(js);
                        }
                        if (initPreview) {
                            IWorkbenchPage page = window.getActivePage();
                            final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"com.aptana.ide.intro.browserEditor");
                            final File fileIndex = index;
                            Job job = new Job(Messages.JaxerPreviewHandler_GeneratingPreview){

                                protected IStatus run(IProgressMonitor monitor) {
                                    Server server = null;
                                    int port = ServerManager.findFreePort((int)8100, (int)8500);
                                    try {
                                        server = new Server(port);
                                        server.getConnectors()[0].setHost("127.0.0.1");
                                        Context context = new Context((HandlerContainer)server, "/", 1);
                                        ResourceBaseServlet servlet = new ResourceBaseServlet(fileIndex.getParentFile().getAbsolutePath());
                                        context.addServlet(new ServletHolder((Servlet)servlet), "/");
                                        Path serverPath = new Path(fileIndex.getParentFile().getAbsolutePath());
                                        IServer js = ServerManager.getInstance().findServer("jaxerInternalServer");
                                        if (js != null && (js.getServerState() == 2 || js.getServerState() == 1)) {
                                            JettyDocumentRootResolver resolver = new JettyDocumentRootResolver(serverPath.makeAbsolute().toString());
                                            JettyServerBuilder.getInstance().buildServer(context, "com.aptana.ide.editor.html.preview.server", "jaxerInternalServer", js.getHostname(), js.getPort(), (IDocumentRootResolver)resolver);
                                            server.setStopAtShutdown(true);
                                            server.start();
                                        } else {
                                            server = null;
                                        }
                                    }
                                    catch (Exception e) {
                                        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Error starting preview server", (Throwable)e);
                                        server = null;
                                    }
                                    Server endServer = server;
                                    int endPort = port;
                                    if (endServer != null) {
                                        UIJob update = JaxerPreviewHandler.this.createUpdateJob(fileIndex, endPort, endServer, (CoreBrowserEditor)editor);
                                        update.schedule();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
    }
}

