/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.outline;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.framework.jaxer.ParseNodeUtils;
import com.aptana.ide.views.outline.BaseFilter;

public abstract class JaxerBaseFilter
extends BaseFilter {
    protected String getRunatValue(HTMLParseNode node) {
        String result = null;
        HTMLElementNode script = this.findScriptElement(node);
        if (script != null) {
            result = script.hasAttribute("runat") ? script.getAttribute("runat") : "client";
        }
        return result;
    }

    protected HTMLElementNode findScriptElement(HTMLParseNode node) {
        HTMLElementNode result = null;
        HTMLParseNode current = node;
        while (current != null) {
            HTMLElementNode htmlElement;
            if (current instanceof HTMLElementNode && "script".equals((htmlElement = (HTMLElementNode)current).getName())) {
                result = htmlElement;
                break;
            }
            current = current.getParent();
        }
        return result;
    }

    protected boolean isFilterType(HTMLElementNode scriptElement, String runat, String typePrefix) {
        boolean result = true;
        if (runat != null) {
            result = runat.startsWith(typePrefix) || runat.startsWith("both");
            String[] containedRunatValues = ParseNodeUtils.getUniqueRunatValues(scriptElement);
            if (result) {
                if (containedRunatValues.length == 1) {
                    runat = containedRunatValues[0];
                    result = runat.startsWith(typePrefix) || runat.startsWith("both");
                }
            } else {
                String[] stringArray = containedRunatValues;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String testValue = stringArray[n];
                    if (testValue.startsWith(typePrefix) || runat.startsWith("both")) {
                        result = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        return result;
    }
}

