/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.handlers;

import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsHandler;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class JaxerStatisticsHandler
implements IStatisticsHandler {
    private String id = null;
    private JaxerServer server;
    private List<String> paths;

    public boolean isCallback(String path) {
        if (path != null && this.paths != null) {
            for (String callbackPath : this.paths) {
                if (!path.matches(callbackPath)) continue;
                return true;
            }
        }
        return false;
    }

    public void parseStatistics(ServletRequest request, ServletResponse response) {
        if (this.server == null) {
            this.loadServer();
        }
        if (this.server != null && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String path = httpRequest.getServletPath();
            if (this.isCallback(path)) {
                this.server.callbackSentFromJaxer();
                return;
            }
            String userAgent = httpRequest.getHeader("User-Agent");
            if (userAgent != null && userAgent.indexOf("Jaxer") != -1) {
                this.server.requestSentFromJaxer();
                return;
            }
        }
    }

    public void eventOccurred(ServletRequest request, ServletResponse response, String event) {
        HttpServletRequest httpRequest;
        String path;
        if (this.server == null) {
            this.loadServer();
        }
        if (this.server != null && request instanceof HttpServletRequest && !this.isCallback(path = (httpRequest = (HttpServletRequest)request).getServletPath()) && event == "JAXER_PROCESSED") {
            this.server.requestSentToJaxer();
        }
    }

    private void loadServer() {
        IServer server;
        if (this.id != null && (server = ServerManager.getInstance().findServer(this.id)) != null && server instanceof JaxerServer) {
            this.server = (JaxerServer)server;
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
        this.loadServer();
    }

    public void setData(String key, Object value) {
        if ("REQUEST_PATH".equals(key) && value instanceof List) {
            this.paths = (List)value;
        }
    }
}

