/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.editor;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.IColorizerHandler;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.ParseNodeUtils;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class JaxerHTMLColorizer
implements IColorizerHandler {
    private Color BOTH_COLOR;
    private Color SERVER_COLOR;
    private IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
            if ("com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR".equals(event.getProperty())) {
                RGB serverRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR");
                JaxerHTMLColorizer.this.SERVER_COLOR = UnifiedColorManager.getInstance().getColor(serverRGB);
            } else if ("com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR".equals(event.getProperty())) {
                RGB bothRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR");
                JaxerHTMLColorizer.this.BOTH_COLOR = UnifiedColorManager.getInstance().getColor(bothRGB);
            }
        }
    };

    public JaxerHTMLColorizer() {
        IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
        RGB serverRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR");
        this.SERVER_COLOR = UnifiedColorManager.getInstance().getColor(serverRGB);
        RGB bothRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR");
        this.BOTH_COLOR = UnifiedColorManager.getInstance().getColor(bothRGB);
        JaxerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.prefListener);
    }

    public Color getBackground(IParseState parseState, Lexeme lexeme) {
        if (!JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING")) {
            return null;
        }
        if (lexeme.getToken().getTypeIndex() == 51 && lexeme.getToken().getCategoryIndex() == 5) {
            if (!lexeme.getText().matches("\\s*")) {
                return this.getEmptyLineColor(parseState, lexeme.offset);
            }
            LexemeList list = parseState.getLexemeList();
            int index = list.getLexemeIndex(lexeme);
            if (index + 1 < list.size()) {
                lexeme = list.get(index + 1);
            }
        }
        return this.getEmptyLineColor(parseState, lexeme.offset);
    }

    public String getLanguage() {
        return "text/html";
    }

    public Color getEmptyLineColor(IParseState parseState, int offset) {
        if (!JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING")) {
            return null;
        }
        IParseNode rootNode = parseState.getParseResults();
        IParseNode node = rootNode.getNodeAtOffset(offset);
        if (node instanceof HTMLParseNode) {
            IParseNode parent = node;
            if (!(parent instanceof HTMLElementNode)) {
                parent = node.getParent();
                while (parent != null && !(parent instanceof HTMLElementNode)) {
                    parent = parent.getParent();
                }
            }
            if (parent instanceof HTMLElementNode && ((HTMLElementNode)parent).getText().equals("script")) {
                ParseNodeUtils.update(parseState);
                String type = ParseNodeUtils.getRunatValue((HTMLElementNode)parent);
                if ("both".equals(type) || "both-proxy".equals(type) || "both-nocache".equals(type)) {
                    return this.BOTH_COLOR;
                }
                if ("server".equals(type) || "server-proxy".equals(type) || "server-nocache".equals(type)) {
                    return this.SERVER_COLOR;
                }
                return LanguageRegistry.getLanguageColorizer((String)"text/javascript").getBackground();
            }
        }
        return null;
    }

    public StyleRange getStyleRange(IParseState parseState, Lexeme lexeme) {
        return null;
    }
}

