/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.editor;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.core.ui.widgets.Accordion;
import com.aptana.ide.editor.js.JSEditor;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedColorizer;
import com.aptana.ide.editors.unified.colorizer.UnifiedCursorLinePainter;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.editor.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import com.aptana.ide.views.outline.UnifiedQuickOutlinePage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class JaxerEditor
extends EditorPart
implements ITextEditor,
ITextEditorExtension,
IUnifiedEditor {
    private JSEditor source;
    private JSEditor jaxerServer;
    private JSEditor clientBrowser;
    private JSEditor jaxerServerCallback;
    private Composite displayArea;
    private Accordion accordion;
    private UnifiedColorizer colorizer = UnifiedColorizer.getInstance();

    public JaxerEditor() {
        this.source = new JSEditor();
        this.jaxerServer = new JSEditor();
        this.clientBrowser = new JSEditor();
        this.jaxerServerCallback = new JSEditor();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.source != null) {
            this.source.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.source != null) {
            this.source.doSaveAs();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (this.source != null) {
            this.source.init(site, input);
        }
    }

    public boolean isDirty() {
        if (this.source != null) {
            return this.source.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        if (this.source != null) {
            return this.source.isSaveAsAllowed();
        }
        return false;
    }

    private TextViewer createTextViewer(Composite parent, String content) {
        IParser parser = LanguageRegistry.getParser((String)"text/javascript");
        final IParseState parseState = parser.createParseState(null);
        parseState.setEditState(content, null, 0, 0);
        try {
            parser.parse(parseState);
            LexemeList lexemeList = parseState.getLexemeList();
            int a = 0;
            while (a < lexemeList.size()) {
                LanguageRegistry.getLanguageColorizer((String)lexemeList.get(a).getLanguage());
                ++a;
            }
        }
        catch (ParseException e1) {
            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)e1.getMessage());
        }
        catch (LexerException e1) {
            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)e1.getMessage());
        }
        LineStyleListener styleListener = new LineStyleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lineGetStyle(LineStyleEvent e) {
                int lineLength;
                int orgOffset;
                if (parseState == null) {
                    return;
                }
                LexemeList lexemeList = parseState.getLexemeList();
                if (lexemeList == null) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.JaxerEditor_LexemeListIsNull);
                    return;
                }
                int offset = orgOffset = e.lineOffset;
                int extra = 0;
                int maxLineLength = lineLength = e.lineText.length();
                Lexeme[] lexemes = null;
                LexemeList lexemeList2 = lexemeList;
                synchronized (lexemeList2) {
                    int startingIndex = lexemeList.getLexemeCeilingIndex(offset);
                    int endingIndex = lexemeList.getLexemeFloorIndex(offset + maxLineLength);
                    if (startingIndex == -1 && endingIndex != -1) {
                        startingIndex = endingIndex;
                    }
                    if (endingIndex == -1 && startingIndex != -1) {
                        endingIndex = startingIndex;
                    }
                    if (startingIndex != -1 && endingIndex != -1) {
                        lexemes = lexemeList.cloneRange(startingIndex, endingIndex);
                    }
                }
                if (lexemes != null) {
                    Vector styles = new Vector();
                    JaxerEditor.this.colorizer.createStyles(parseState, styles, lexemes, true);
                    StyleRange[] styleResults = styles.toArray(new StyleRange[0]);
                    if (extra > 0) {
                        int i = 0;
                        while (i < styleResults.length) {
                            StyleRange range = styleResults[i];
                            range.start -= extra;
                            ++i;
                        }
                    }
                    e.styles = styleResults;
                }
            }
        };
        Document document = new Document(content);
        TextViewer sourceViewer = new TextViewer(parent, 2824);
        sourceViewer.setDocument((IDocument)document);
        sourceViewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        sourceViewer.getTextWidget().addLineStyleListener(styleListener);
        final UnifiedCursorLinePainter painter = new UnifiedCursorLinePainter((IUnifiedEditor)this, (ITextViewer)sourceViewer);
        sourceViewer.addPainter((IPainter)painter);
        painter.setHighlightColor(LanguageRegistry.getLanguageColorizer((String)"text/javascript").getLineHighlightColor());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledText text = JaxerEditor.this.getViewer().getTextWidget();
                painter.paintLines(0, text.getLineCount());
            }
        };
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                StyledText text = JaxerEditor.this.getViewer().getTextWidget();
                if (painter != null && text != null && !text.isDisposed()) {
                    Point p = text.getSelectionRange();
                    if (p.y > 0) {
                        painter.paintLines(0, text.getLineCount());
                    }
                }
            }
        };
        ITextListener textListener = new ITextListener(){

            public void textChanged(TextEvent event) {
                StyledText text = JaxerEditor.this.getViewer().getTextWidget();
                if (painter != null && text != null && !text.isDisposed()) {
                    Point p = text.getSelectionRange();
                    if (p.y > 0) {
                        painter.paintLines(0, text.getLineCount());
                    }
                }
            }
        };
        sourceViewer.addTextListener(textListener);
        sourceViewer.getTextWidget().addFocusListener((FocusListener)focusListener);
        sourceViewer.getTextWidget().addSelectionListener((SelectionListener)selectionListener);
        sourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        sourceViewer.getDocument().set(sourceViewer.getDocument().get());
        return sourceViewer;
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.accordion = new Accordion(25, 512, 150, true);
        this.accordion.setHideWhileSliding(false);
        this.accordion.setDrawerText(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
        this.accordion.createAccordion(this.displayArea);
        Composite sourceDrawer = this.accordion.addDrawer(Messages.JaxerEditor_Source, UnifiedColorManager.getInstance().getColor(new RGB(157, 169, 212)), null, -1);
        Composite sourceComp = this.accordion.getDrawerArea(sourceDrawer);
        GridLayout cLayout = new GridLayout(1, true);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        sourceComp.setLayout((Layout)cLayout);
        this.source.createPartControl(sourceComp);
        Composite jaxerServerDrawer = this.accordion.addDrawer(Messages.JaxerEditor_JaxerServer, UnifiedColorManager.getInstance().getColor(new RGB(108, 133, 159)), null, -1);
        Composite jaxerServerComp = this.accordion.getDrawerArea(jaxerServerDrawer);
        jaxerServerComp.setLayout((Layout)cLayout);
        String content = "function foo() { var i = 3; var j = 5;}";
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                content = FileUtils.readContent((File)file.getLocation().makeAbsolute().toFile());
            }
            catch (IOException iOException) {}
        }
        this.createTextViewer(jaxerServerComp, content);
        Composite clientBrowserDrawer = this.accordion.addDrawer(Messages.JaxerEditor_ClientBrowser);
        Composite clientBrowserComp = this.accordion.getDrawerArea(clientBrowserDrawer);
        clientBrowserComp.setLayout((Layout)cLayout);
        this.createTextViewer(clientBrowserComp, content);
        Composite jaxerServerCallbackDrawer = this.accordion.addDrawer(Messages.JaxerEditor_JaxerServerCallback, UnifiedColorManager.getInstance().getColor(new RGB(108, 133, 159)), null, -1);
        Composite jaxerServerCallbackComp = this.accordion.getDrawerArea(jaxerServerCallbackDrawer);
        jaxerServerCallbackComp.setLayout((Layout)cLayout);
        this.createTextViewer(jaxerServerCallbackComp, content);
        this.accordion.setInitialDrawerOpen(sourceDrawer);
    }

    public void setFocus() {
        if (this.source != null) {
            this.source.setFocus();
        }
    }

    public void close(boolean save) {
        if (this.source != null) {
            this.source.close(save);
        }
    }

    public void doRevertToSaved() {
        if (this.source != null) {
            this.source.doRevertToSaved();
        }
    }

    public IAction getAction(String actionId) {
        if (this.source != null) {
            return this.source.getAction(actionId);
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.source != null) {
            return this.source.getDocumentProvider();
        }
        return null;
    }

    public IRegion getHighlightRange() {
        if (this.source != null) {
            return this.source.getHighlightRange();
        }
        return null;
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.source != null) {
            return this.source.getSelectionProvider();
        }
        return null;
    }

    public boolean isEditable() {
        if (this.source != null) {
            return this.source.isEditable();
        }
        return false;
    }

    public void removeActionActivationCode(String actionId) {
        if (this.source != null) {
            this.source.removeActionActivationCode(actionId);
        }
    }

    public void resetHighlightRange() {
        if (this.source != null) {
            this.source.resetHighlightRange();
        }
    }

    public void selectAndReveal(int offset, int length) {
        if (this.source != null) {
            this.source.selectAndReveal(offset, length);
        }
    }

    public void setAction(String actionID, IAction action) {
        if (this.source != null) {
            this.source.setAction(actionID, action);
        }
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        if (this.source != null) {
            this.source.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
        }
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        if (this.source != null) {
            this.source.setHighlightRange(offset, length, moveCursor);
        }
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        if (this.source != null) {
            this.source.showHighlightRangeOnly(showHighlightRangeOnly);
        }
    }

    public boolean showsHighlightRangeOnly() {
        if (this.source != null) {
            return this.source.showsHighlightRangeOnly();
        }
        return false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.source != null) {
            this.source.addRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.source != null) {
            return this.source.isEditorInputReadOnly();
        }
        return false;
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.source != null) {
            this.source.removeRulerContextMenuListener(listener);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.source != null) {
            this.source.setStatusField(field, category);
        }
    }

    public void addFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.source != null) {
            this.source.addFileServiceChangeListener(listener);
        }
    }

    public IUnifiedEditorContributor getBaseContributor() {
        if (this.source != null) {
            return this.source.getBaseContributor();
        }
        return null;
    }

    public SourceViewerConfiguration getConfiguration() {
        if (this.source != null) {
            return this.source.getConfiguration();
        }
        return null;
    }

    public IContextAwareness getContextAwareness() {
        if (this.source != null) {
            return this.source.getContextAwareness();
        }
        return null;
    }

    public String getDefaultFileExtension() {
        if (this.source != null) {
            return this.source.getDefaultFileExtension();
        }
        return null;
    }

    public IEditorPart getEditor() {
        if (this.source != null) {
            return this.source.getEditor();
        }
        return null;
    }

    public EditorFileContext getFileContext() {
        if (this.source != null) {
            return this.source.getFileContext();
        }
        return null;
    }

    public UnifiedOutlinePage getOutlinePage() {
        if (this.source != null) {
            return this.source.getOutlinePage();
        }
        return null;
    }

    public UnifiedQuickOutlinePage createQuickOutlinePage() {
        return this.source != null ? this.source.createQuickOutlinePage() : null;
    }

    public PairMatch getPairMatch(int offset) {
        if (this.source != null) {
            return this.source.getPairMatch(offset);
        }
        return null;
    }

    public String getParentDirectoryHint() {
        if (this.source != null) {
            return this.source.getParentDirectoryHint();
        }
        return null;
    }

    public ISourceViewer getViewer() {
        if (this.source != null) {
            return this.source.getViewer();
        }
        return null;
    }

    public void removeFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.source != null) {
            this.source.removeFileServiceChangeListener(listener);
        }
    }

    public void setParentDirectoryHint(String hint) {
        if (this.source != null) {
            this.source.setParentDirectoryHint(hint);
        }
    }

    public void showPianoKeys(boolean state) {
        if (this.source != null) {
            this.source.showPianoKeys(state);
        }
        if (this.clientBrowser != null) {
            this.clientBrowser.showPianoKeys(state);
        }
        if (this.jaxerServer != null) {
            this.jaxerServer.showPianoKeys(state);
        }
        if (this.jaxerServerCallback != null) {
            this.jaxerServerCallback.showPianoKeys(state);
        }
    }

    public void showWhitespace(boolean state) {
        if (this.source != null) {
            this.source.showWhitespace(state);
        }
        if (this.clientBrowser != null) {
            this.clientBrowser.showWhitespace(state);
        }
        if (this.jaxerServer != null) {
            this.jaxerServer.showWhitespace(state);
        }
        if (this.jaxerServerCallback != null) {
            this.jaxerServerCallback.showWhitespace(state);
        }
    }

    public void addSaveAsListener(ISaveAsEvent listener) {
        if (this.source != null) {
            this.source.addSaveAsListener(listener);
        }
    }

    public void addSaveListener(ISaveEvent listener) {
        if (this.source != null) {
            this.source.addSaveListener(listener);
        }
    }

    public void removeSaveAsListener(ISaveAsEvent listener) {
        if (this.source != null) {
            this.source.removeSaveAsListener(listener);
        }
    }

    public void removeSaveListener(ISaveEvent listener) {
        if (this.source != null) {
            this.source.removeSaveListener(listener);
        }
    }
}

