/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.editor;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.editor.js.parsing.nodes.JSFunctionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.IColorizerHandler;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.ParseNodeUtils;
import com.aptana.ide.framework.jaxer.outline.OutlineColors;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class JaxerColorizer
implements IColorizerHandler {
    private Color BOTH_COLOR;
    private Color SERVER_COLOR;
    private Comparator<JSParseNode> comparator;
    private IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
            if ("com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR".equals(event.getProperty())) {
                RGB serverRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR");
                JaxerColorizer.this.SERVER_COLOR = UnifiedColorManager.getInstance().getColor(serverRGB);
            } else if ("com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR".equals(event.getProperty())) {
                RGB bothRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR");
                JaxerColorizer.this.BOTH_COLOR = UnifiedColorManager.getInstance().getColor(bothRGB);
            }
        }
    };

    public JaxerColorizer() {
        IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
        RGB serverRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR");
        this.SERVER_COLOR = UnifiedColorManager.getInstance().getColor(serverRGB);
        RGB bothRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR");
        this.BOTH_COLOR = UnifiedColorManager.getInstance().getColor(bothRGB);
        JaxerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.prefListener);
        this.comparator = new Comparator<JSParseNode>(){

            @Override
            public int compare(JSParseNode o1, JSParseNode o2) {
                int offset = o2.getStartingOffset();
                int result = 0;
                if (offset < o1.getStartingOffset()) {
                    result = 1;
                } else if (o1.getStartingOffset() + o1.getStartingLexeme().length <= offset) {
                    result = -1;
                }
                return result;
            }
        };
    }

    public String getLanguage() {
        return "text/javascript";
    }

    public Color getBackground(IParseState parseState, Lexeme lexeme) {
        return this.getEmptyLineColor(parseState, lexeme.offset);
    }

    private Color getHTMLElementColor(IParseState parseState, IParseNode node) {
        if (node == null) {
            return null;
        }
        IParseNode parent = node;
        if (!(parent instanceof HTMLElementNode)) {
            parent = node.getParent();
            while (parent != null && !(parent instanceof HTMLElementNode)) {
                parent = parent.getParent();
            }
        }
        if (parent instanceof HTMLElementNode) {
            ParseNodeUtils.update(parseState);
            String type = ParseNodeUtils.getRunatValue((HTMLElementNode)parent);
            if ("both".equals(type) || "both-proxy".equals(type) || "both-nocache".equals(type)) {
                return this.BOTH_COLOR;
            }
            if ("server".equals(type) || "server-proxy".equals(type) || "server-nocache".equals(type)) {
                return this.SERVER_COLOR;
            }
        }
        return null;
    }

    public Color getEmptyLineColor(IParseState parseState, int offset) {
        if (!JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING")) {
            return null;
        }
        if (JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_ADVANCED_JAXER_COLORING")) {
            IParseNode rootNode = parseState.getParseResults();
            IParseNode node = rootNode.getNodeAtOffset(offset);
            if (node instanceof JSParseNode) {
                Lexeme value;
                String type;
                IParseNode sub1;
                Lexeme ender;
                JSParseNode nnode;
                int foundNode = Collections.binarySearch(ParseNodeUtils.ASSIGNMENTS, (JSParseNode)node, this.comparator);
                if (foundNode >= 0 && (nnode = ParseNodeUtils.ASSIGNMENTS.get(foundNode)).getChildCount() == 2 && "runat".equals((ender = (sub1 = nnode.getChild(0)).getEndingLexeme()).getText()) && (type = (value = nnode.getEndingLexeme()).getText()).length() > 2) {
                    if ("both".equals(type = type.substring(1, type.length() - 1)) || "both-proxy".equals(type) || "both-nocache".equals(type)) {
                        return this.BOTH_COLOR;
                    }
                    if ("server".equals(type) || "server-proxy".equals(type) || "server-nocache".equals(type)) {
                        return this.SERVER_COLOR;
                    }
                    return null;
                }
                IParseNode parent = node;
                if (!(parent instanceof JSFunctionNode)) {
                    parent = node.getParent();
                    while (parent != null && !(parent instanceof JSFunctionNode)) {
                        parent = parent.getParent();
                    }
                }
                if (!(parent instanceof JSParseNode)) {
                    parent = node;
                }
                ParseNodeUtils.update(parseState);
                String type2 = ParseNodeUtils.getRunatValue((JSParseNode)parent);
                if ("both".equals(type2) || "both-proxy".equals(type2) || "both-nocache".equals(type2)) {
                    return this.BOTH_COLOR;
                }
                if ("server".equals(type2) || "server-proxy".equals(type2) || "server-nocache".equals(type2)) {
                    return this.SERVER_COLOR;
                }
            } else if (node instanceof HTMLParseNode) {
                return this.getHTMLElementColor(parseState, node);
            }
        } else {
            IParseNode node = parseState.getParseResults().getNodeAtOffset(offset);
            return this.getHTMLElementColor(parseState, node);
        }
        return null;
    }

    public StyleRange getStyleRange(IParseState parseState, Lexeme lexeme) {
        Lexeme functionNameLexeme;
        Lexeme functionLexeme;
        LexemeList list;
        int index;
        if (!JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING")) {
            return null;
        }
        IParseNode rootNode = parseState.getParseResults();
        IParseNode node = rootNode.getNodeAtOffset(lexeme.offset);
        if (node instanceof JSFunctionNode && (index = (list = parseState.getLexemeList()).getLexemeIndex(functionLexeme = node.getStartingLexeme())) + 1 < list.size() && "function".equals(functionLexeme.getText()) && (functionNameLexeme = list.get(index + 1)) == lexeme) {
            ParseNodeUtils.update(parseState);
            String type = ParseNodeUtils.getRunatValue((JSParseNode)((JSFunctionNode)node));
            StyleRange range = new StyleRange(lexeme.offset, lexeme.length, OutlineColors.getForeground(type), null);
            if ("server-nocache".equals(type) || "both-nocache".equals(type)) {
                range.fontStyle = JaxerPlugin.getDefault().getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.NO_CACHE_FOREGROUND_STYLE");
                return range;
            }
            if ("server-proxy".equals(type) || "both-proxy".equals(type)) {
                range.fontStyle = JaxerPlugin.getDefault().getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.PROXY_FOREGROUND_STYLE");
                return range;
            }
            if ("both".equals(type) || "both-proxy".equals(type) || "both-nocache".equals(type) || "server".equals(type) || "server-proxy".equals(type) || "server-nocache".equals(type)) {
                return range;
            }
        }
        return null;
    }
}

