/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.actions.Messages;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.impl.Configuration;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLogAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection instanceof StructuredSelection && !this.selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            JaxerServer oo = (JaxerServer)ss.getFirstElement();
            ILog log = oo.getLog();
            if (log == null || !log.exists()) {
                FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dlg.setText(Messages.OpenLogAction_CHOOSE_LOG_TITLE);
                dlg.setFilterPath(new File(log.getURI()).getParent());
                dlg.setFilterNames(new String[]{Messages.OpenLogAction_JAXER_LOG});
                dlg.setFilterExtensions(new String[]{"*.log"});
                String sm = dlg.open();
                if (sm == null) {
                    return;
                }
                File fl = new File(sm);
                String string = fl.toURI().toString();
                Configuration config = new Configuration();
                oo.storeConfiguration((IAbstractConfiguration)config);
                config.setStringAttribute("logpath", string);
                try {
                    oo.reconfigure((IAbstractConfiguration)config);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Core exception while setting log location for jaxer server", (Throwable)e);
                }
                log = oo.getLog();
            }
            try {
                LogView showView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.aptana.ide.logging.LogView");
                showView.addTab(log.getURI(), StringUtils.format((String)Messages.OpenLogAction_LOG_NAME, (String)oo.getName()), false);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Part init exception while opening log view", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

