/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.actions.AbstractWorkbenchWindowPulldownDelegate;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.actions.JaxerInfoDialog;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.intro.browser.BrowserEditorHelper;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.samples.SamplesPlugin;
import com.aptana.ide.samples.SamplesView;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.ILogOpener;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.Messages;
import com.aptana.ide.server.ui.views.actions.NewServerAction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Bundle;

public class JaxerToolbarAction
extends AbstractWorkbenchWindowPulldownDelegate {
    private JaxerServer server;
    private IAction action;
    private Menu menu;

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
        IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
        if (jaxer != null && jaxer instanceof JaxerServer) {
            this.server = (JaxerServer)jaxer;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        MenuItem docMenu = new MenuItem(this.menu, 8);
        docMenu.setText("Online Jaxer Documentation");
        docMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.Aptana.com/jaxer/guide", (boolean)true, (String)"jaxer_toolbar");
            }
        });
        docMenu.setImage(JaxerPlugin.getImage("icons/browser_aptana.png"));
        MenuItem help = new MenuItem(this.menu, 8);
        help.setText("Jaxer API Documentation");
        help.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bundle bundle = JaxerPlugin.getDefault().getBundle();
                URL url = bundle.getEntry("html/reference/api/Jaxer.index-frame.html");
                if (url != null) {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        BrowserEditorHelper.openBrowserEditor((URL)url, (String)"Jaxer API", (ImageDescriptor)JaxerPlugin.getImageDescriptor("icons/jaxerHelp.png"), (String)"Jaxer API documentation", null);
                    }
                    catch (IOException e1) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error opening Jaxer API page", (Throwable)e1);
                    }
                    catch (PartInitException e2) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error opening Jaxer API page", (Throwable)e2);
                    }
                }
            }
        });
        help.setImage(JaxerPlugin.getImage("icons/jaxerHelp.png"));
        MenuItem openJaxerPreferences = new MenuItem(this.menu, 8);
        openJaxerPreferences.setText("Open Jaxer Preferences...");
        openJaxerPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)e.display.getActiveShell(), (String)"com.aptana.ide.framework.jaxer.preferences.JaxerPreferencePage", (String[])new String[0], null);
                dialog.open();
            }
        });
        openJaxerPreferences.setImage(JaxerPlugin.getImage("icons/configure.png"));
        new MenuItem(this.menu, 2);
        MenuItem showServersView = new MenuItem(this.menu, 8);
        showServersView.setText("Servers View");
        showServersView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CoreUIUtils.showView((String)"com.aptana.ide.server.ui.serversView");
                }
                catch (PartInitException partInitException) {}
            }
        });
        final Image serversViewImage = ServerUIPlugin.getImageDescriptor((String)"icons/server/server.gif").createImage();
        showServersView.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                serversViewImage.dispose();
            }
        });
        showServersView.setImage(serversViewImage);
        MenuItem openJaxerInternalServerLog = new MenuItem(this.menu, 8);
        openJaxerInternalServerLog.setText("Jaxer Internal Server Log");
        openJaxerInternalServerLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
                if (jaxer != null && jaxer instanceof JaxerServer) {
                    JaxerServer oo = (JaxerServer)jaxer;
                    Object logOpener = oo.getAdapter(ILogOpener.class);
                    ILog log = oo.getLog();
                    if (log == null) {
                        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                        dlg.setText(Messages.OpenLogAction_CHOOSE_LOG_TITLE);
                        dlg.setFilterNames(new String[]{""});
                        dlg.setFilterExtensions(new String[]{"*.log"});
                        String sm = dlg.open();
                        if (sm == null) {
                            return;
                        }
                        File fl = new File(sm);
                        String string = fl.getAbsolutePath();
                        Configuration config = new Configuration();
                        oo.storeConfiguration((IAbstractConfiguration)config);
                        config.setStringAttribute("logpath", string);
                        try {
                            oo.reconfigure((IAbstractConfiguration)config);
                        }
                        catch (CoreException coreException) {
                            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Core exception while setting log location for server", (Throwable)coreException);
                        }
                        log = oo.getLog();
                    }
                    if (logOpener instanceof ILogOpener) {
                        ((ILogOpener)logOpener).openLog(log);
                    } else {
                        JaxerToolbarAction.this.openLogView(log.getURI(), oo.getName());
                    }
                }
            }
        });
        openJaxerInternalServerLog.setImage(JaxerPlugin.getImage("icons/windowlist.png"));
        MenuItem showJaxerShellView = new MenuItem(this.menu, 8);
        showJaxerShellView.setText("Jaxer Shell View");
        showJaxerShellView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CoreUIUtils.showView((String)"com.aptana.ide.framework.jaxer.interactiveConsole");
                }
                catch (PartInitException partInitException) {}
            }
        });
        showJaxerShellView.setImage(JaxerPlugin.getImage("icons/jaxer_shell.png"));
        MenuItem showJaxerActivityMonitor = new MenuItem(this.menu, 8);
        showJaxerActivityMonitor.setText("Jaxer Activity Monitor");
        showJaxerActivityMonitor.setImage(JaxerPlugin.getImage("icons/activity.png"));
        showJaxerActivityMonitor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CoreUIUtils.showView((String)"com.aptana.ide.framework.jaxer.monitor");
                }
                catch (PartInitException partInitException) {}
            }
        });
        MenuItem showSamplesView = new MenuItem(this.menu, 8);
        showSamplesView.setText("Jaxer Samples");
        showSamplesView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IViewPart part = CoreUIUtils.showView((String)"com.aptana.ide.samples.SamplesView");
                    if (part != null && part instanceof SamplesView) {
                        ((SamplesView)part).selectAndReveal("Aptana Jaxer Samples");
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
        showSamplesView.setImage(SamplesPlugin.getImage((String)"icons/samples.gif"));
        new MenuItem(this.menu, 2);
        MenuItem newJaxerPackage = new MenuItem(this.menu, 8);
        newJaxerPackage.setText("Connect to Jaxer+Apache Server...");
        newJaxerPackage.setImage(JaxerPlugin.getImage("icons/jaxer_package.png"));
        newJaxerPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServerType type = ServerManager.getInstance().getServerType("com.aptana.ide.framework.jaxer.jamFakeType");
                NewServerAction action = new NewServerAction(type);
                action.run();
            }
        });
        if (this.server != null) {
            MenuItem changeState = new MenuItem(this.menu, 8);
            int state = this.server.getServerState();
            if (state != 4) {
                changeState.setText("Stop Internal Jaxer Server");
                changeState.setImage(JaxerPlugin.getImage("icons/stop.gif"));
                changeState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (JaxerToolbarAction.this.server != null) {
                            JaxerToolbarAction.this.server.stop(true, null, null);
                        }
                    }
                });
            } else {
                changeState.setText("Start Jaxer Server");
                changeState.setImage(JaxerPlugin.getImage("icons/start.gif"));
                changeState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (JaxerToolbarAction.this.server != null) {
                            JaxerToolbarAction.this.server.start("run", null, null);
                        }
                    }
                });
            }
        }
        new MenuItem(this.menu, 2);
        MenuItem learnMore = new MenuItem(this.menu, 8);
        learnMore.setText("About Jaxer");
        learnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxerInfoDialog dialog = new JaxerInfoDialog(CoreUIUtils.getActiveShell());
                dialog.open();
            }
        });
        learnMore.setImage(JaxerPlugin.getImage("icons/information.png"));
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void openLogView(URI uri, String tabName) {
        try {
            LogView showView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.aptana.ide.logging.LogView");
            showView.addTab(uri, StringUtils.format((String)Messages.OpenLogAction_LOG_NAME, (String)tabName), true);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Part init exception while opening log view", (Throwable)e);
        }
    }
}

