/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.actions.Messages;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerListener;
import com.aptana.ide.server.core.OperationCompletionEvent;
import com.aptana.ide.server.core.ServerEvent;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.comet.CometClient;
import com.aptana.ide.server.jetty.comet.CometResponderClient;
import dojox.cometd.Channel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class JaxerControlClient
extends CometResponderClient {
    public static final String CONTROLLER = "/portal/jaxer/jaxerController";
    public static final String SERVER_STATUS = "serverStatus";
    public static final String STATUS = "status";
    public static final String SET_STATE = "setState";
    public static final String CONTROL_SERVER = "controlServer";
    public static final String TAIL_LOG = "tailLog";
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String DONE = "done";
    public static final String RUNNING = "running";
    public static final String STOPPED = "stopped";
    private IServerListener jaxerListener = new IServerListener(){

        public void serverChanged(ServerEvent event) {
            IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
            if (jaxer != null && jaxer instanceof JaxerServer) {
                HashMap<String, String> responseData = new HashMap<String, String>();
                responseData.put("response", JaxerControlClient.SERVER_STATUS);
                if (jaxer.getServerState() == 2 || jaxer.getServerState() == 1) {
                    responseData.put(JaxerControlClient.STATUS, JaxerControlClient.RUNNING);
                } else {
                    responseData.put(JaxerControlClient.STATUS, JaxerControlClient.STOPPED);
                }
                Channel channel = ((CometClient)JaxerControlClient.this).bayeux.getChannel(JaxerControlClient.CONTROLLER, true);
                if (channel != null) {
                    channel.publish(((CometClient)JaxerControlClient.this).client, responseData, JaxerControlClient.this.getID(null));
                }
            }
        }
    };

    public JaxerControlClient() {
        IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
        if (jaxer != null && jaxer instanceof JaxerServer) {
            JaxerServer server = (JaxerServer)jaxer;
            server.addServerListener(this.jaxerListener);
        }
    }

    public void destroy() {
        IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
        if (jaxer != null && jaxer instanceof JaxerServer) {
            JaxerServer server = (JaxerServer)jaxer;
            server.removeServerListener(this.jaxerListener);
        }
        super.destroy();
    }

    protected Object getResponse(String toChannel, Object request) {
        if (CONTROLLER.equals(toChannel) && request instanceof Map) {
            IServer jaxer;
            Map requestData = (Map)request;
            if (SERVER_STATUS.equals(requestData.get("request"))) {
                IServer jaxer2 = ServerManager.getInstance().findServer("jaxerInternalServer");
                if (jaxer2 != null && jaxer2 instanceof JaxerServer) {
                    HashMap<String, String> response = new HashMap<String, String>();
                    response.put("response", SERVER_STATUS);
                    if (jaxer2.getServerState() == 2 || jaxer2.getServerState() == 1) {
                        response.put(STATUS, RUNNING);
                    } else {
                        response.put(STATUS, STOPPED);
                    }
                    return response;
                }
            } else if (CONTROL_SERVER.equals(requestData.get("request")) && requestData.containsKey(SET_STATE)) {
                String setState = (String)requestData.get(SET_STATE);
                IServer jaxer3 = ServerManager.getInstance().findServer("jaxerInternalServer");
                if (jaxer3 != null && jaxer3 instanceof JaxerServer) {
                    final HashMap<String, String> response = new HashMap<String, String>();
                    response.put("response", CONTROL_SERVER);
                    IOperationListener listener = new IOperationListener(){
                        private boolean isDone = false;

                        public boolean isDone() {
                            return this.isDone;
                        }

                        public void done(OperationCompletionEvent operation) {
                            this.isDone = true;
                            response.put(JaxerControlClient.SET_STATE, JaxerControlClient.DONE);
                            Channel channel = ((CometClient)JaxerControlClient.this).bayeux.getChannel(JaxerControlClient.CONTROLLER, true);
                            if (channel != null) {
                                channel.publish(((CometClient)JaxerControlClient.this).client, (Object)response, "R" + JaxerControlClient.this.getID());
                            }
                        }
                    };
                    if (START.equals(setState)) {
                        jaxer3.start("run", listener, null);
                    } else if (STOP.equals(setState)) {
                        jaxer3.stop(true, listener, null);
                    }
                }
            } else if (TAIL_LOG.equals(requestData.get("request")) && (jaxer = ServerManager.getInstance().findServer("jaxerInternalServer")) != null) {
                final ILog log = jaxer.getLog();
                if (log != null) {
                    UIJob uijob = new UIJob(TAIL_LOG){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                LogView showView = (LogView)CoreUIUtils.showView((String)"com.aptana.ide.logging.LogView");
                                showView.addTab(log.getURI(), StringUtils.format((String)Messages.OpenLogAction_LOG_NAME, (String)jaxer.getName()), false);
                            }
                            catch (PartInitException e) {
                                IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Part init exception while opening log view", (Throwable)e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uijob.setPriority(10);
                    uijob.schedule();
                }
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("response", TAIL_LOG);
                return response;
            }
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{CONTROLLER};
    }
}

