/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.js.outline.JSOutlineItem;
import com.aptana.ide.editor.js.parsing.nodes.JSFunctionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSNaryNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.xpath.ParseNodeXPath;
import com.aptana.ide.views.outline.OutlineRefreshHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseNodeUtils
implements OutlineRefreshHandler {
    private static final Map<String, String> PROPERTY_VALUE_MAP;
    private static final Map<String, String> RUNAT_MAP;
    private static final Map<String, String> PROXY_MAP;
    private static final String NAME_ATTR = "name";
    private static final HTMLElementNode[] NO_HTML_ELEMENTS;
    private static final JSParseNode[] NO_ASSIGNMENTS;
    private static final String[] NO_STRINGS;
    private static Map<HTMLElementNode, AssignmentInfo> SCRIPT_ASSIGNMENTS;
    public static List<JSParseNode> ASSIGNMENTS;
    private static final Object PROCESS_LOCK;
    private static IParseNode LAST_PROCESSED_ROOT;
    private static final ParseNodeUtils instance;

    static {
        NO_HTML_ELEMENTS = new HTMLElementNode[0];
        NO_ASSIGNMENTS = new JSParseNode[0];
        NO_STRINGS = new String[0];
        SCRIPT_ASSIGNMENTS = new HashMap<HTMLElementNode, AssignmentInfo>();
        ASSIGNMENTS = new ArrayList<JSParseNode>();
        PROCESS_LOCK = new Object();
        instance = new ParseNodeUtils();
        PROPERTY_VALUE_MAP = new HashMap<String, String>();
        PROPERTY_VALUE_MAP.put("client-false", "client");
        PROPERTY_VALUE_MAP.put("client-true", "client");
        PROPERTY_VALUE_MAP.put("server-false", "server");
        PROPERTY_VALUE_MAP.put("server-true", "server-proxy");
        PROPERTY_VALUE_MAP.put("server-proxy-false", "server");
        PROPERTY_VALUE_MAP.put("server-proxy-true", "server-proxy");
        PROPERTY_VALUE_MAP.put("server-nocache-false", "server-nocache");
        PROPERTY_VALUE_MAP.put("server-nocache-true", "server-proxy");
        PROPERTY_VALUE_MAP.put("both-false", "both");
        PROPERTY_VALUE_MAP.put("both-true", "both-proxy");
        PROPERTY_VALUE_MAP.put("both-proxy-false", "both");
        PROPERTY_VALUE_MAP.put("both-proxy-true", "both-proxy");
        PROPERTY_VALUE_MAP.put("both-nocache-false", "both-nocache");
        PROPERTY_VALUE_MAP.put("both-nocache-true", "both-proxy");
        RUNAT_MAP = new HashMap<String, String>();
        RUNAT_MAP.put("client", "client");
        RUNAT_MAP.put("server-proxy", "server-proxy");
        RUNAT_MAP.put("server", "server");
        RUNAT_MAP.put("server-nocache", "server-nocache");
        RUNAT_MAP.put("both-proxy", "both-proxy");
        RUNAT_MAP.put("both", "both");
        RUNAT_MAP.put("both-nocache", "both-nocache");
        PROXY_MAP = new HashMap<String, String>();
        PROXY_MAP.put("client", "false");
        PROXY_MAP.put("server-proxy", "true");
        PROXY_MAP.put("server", "false");
        PROXY_MAP.put("server-nocache", "false");
        PROXY_MAP.put("both-proxy", "true");
        PROXY_MAP.put("both", "false");
        PROXY_MAP.put("both-nocache", "false");
    }

    public static JSParseNode[] getFunctionDeclarations(HTMLElementNode scriptElement) {
        JSParseNode[] result = NO_ASSIGNMENTS;
        try {
            String functionDeclarations = "./statements//function[@name != '']";
            ParseNodeXPath expr = new ParseNodeXPath(functionDeclarations);
            Object xpathResult = expr.evaluate((Object)scriptElement);
            if (xpathResult instanceof List) {
                List values = (List)xpathResult;
                result = values.toArray(new JSParseNode[values.size()]);
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static JSFunctionNode getFunctionNode(JSOutlineItem item) {
        IParseNode parent;
        JSParseNode parseNode = (JSParseNode)item.getReferenceNode();
        JSFunctionNode result = null;
        if (parseNode instanceof JSNaryNode && (parent = parseNode.getParent()) instanceof JSFunctionNode) {
            result = (JSFunctionNode)parent;
        }
        return result;
    }

    private static String getMapValue(String value, String key, String defaultValue, Map<String, String> map) {
        String result = value == null ? (map.containsKey(key) ? map.get(key) : defaultValue) : value;
        return result;
    }

    public static String getRunatValue(HTMLElementNode elementNode) {
        String result = "client";
        if (elementNode != null && elementNode.getName().equals("script") && elementNode.hasAttribute("runat") && (result = elementNode.getAttribute("runat")) == null) {
            result = "client";
        }
        return result;
    }

    public static String getRunatValue(JSParseNode parseNode) {
        String result = "client";
        if (parseNode != null) {
            JSFunctionNode functionNode;
            HTMLElementNode scriptElement;
            IParseNode parent = parseNode.getParent();
            while (parent != null && !parent.getLanguage().equals("text/html")) {
                parent = parent.getParent();
            }
            if (parent != null && parent instanceof HTMLElementNode && !(result = ParseNodeUtils.getRunatValue(scriptElement = (HTMLElementNode)parent)).equals("client") && parseNode instanceof JSFunctionNode && (functionNode = (JSFunctionNode)parseNode).hasAttribute(NAME_ATTR)) {
                String effectiveRunat;
                String name = functionNode.getAttribute(NAME_ATTR);
                AssignmentInfo info = SCRIPT_ASSIGNMENTS.get(scriptElement);
                if (info != null && (effectiveRunat = info.getFunctionRunatValue(name)) != null) {
                    result = effectiveRunat;
                }
            }
        }
        return result;
    }

    public static String getRunatValue(IParseState parseState, Lexeme lexeme) {
        String language;
        String result = "client";
        if (parseState != null && lexeme != null && "text/scriptdoc".equals(language = lexeme.getLanguage())) {
            LexemeList lexemes = parseState.getLexemeList();
            Lexeme followingLexeme = null;
            int i = lexemes.getLexemeIndex(lexeme) + 1;
            while (i < lexemes.size()) {
                Lexeme candidateLexeme = lexemes.get(i);
                String candidateLanguage = candidateLexeme.getLanguage();
                if (!"text/scriptdoc".equals(candidateLanguage)) {
                    if (!"text/javascript".equals(candidateLanguage)) break;
                    followingLexeme = candidateLexeme;
                    break;
                }
                ++i;
            }
            if (followingLexeme != null) {
                IParseNode rootNode = parseState.getParseResults();
                IParseNode candidateNode = rootNode.getNodeAtOffset(followingLexeme.offset);
                if (candidateNode != null && candidateNode instanceof JSParseNode) {
                    result = ParseNodeUtils.getRunatValue((JSParseNode)candidateNode);
                }
            } else {
                IParseNode parent = parseState.getParseResults().getNodeAtOffset(lexeme.offset);
                while (parent != null && !parent.getLanguage().equals("text/html")) {
                    parent = parent.getParent();
                }
                if (parent != null && parent instanceof HTMLElementNode) {
                    HTMLElementNode scriptElement = (HTMLElementNode)parent;
                    result = ParseNodeUtils.getRunatValue(scriptElement);
                }
            }
        }
        return result;
    }

    public static HTMLElementNode[] getScriptElements(IParseNode rootNode) {
        HTMLElementNode[] result = NO_HTML_ELEMENTS;
        try {
            String xpath = "//script";
            ParseNodeXPath expr = new ParseNodeXPath(xpath);
            Object xpathResult = expr.evaluate((Object)rootNode);
            if (xpathResult instanceof List) {
                List values = (List)xpathResult;
                ArrayList<HTMLElementNode> nodes = new ArrayList<HTMLElementNode>();
                for (Object obj : values) {
                    if (!(obj instanceof HTMLElementNode)) continue;
                    nodes.add((HTMLElementNode)obj);
                }
                result = nodes.toArray(new HTMLElementNode[nodes.size()]);
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static JSParseNode[] getSpecialAssignments(HTMLElementNode scriptElement) {
        JSParseNode[] result = NO_ASSIGNMENTS;
        try {
            String specialAssignment = ".//assignment[get-property/identifier[2]/@text='runat' or get-property/identifier[2]/@text='proxy']";
            ParseNodeXPath expr = new ParseNodeXPath(specialAssignment);
            Object xpathResult = expr.evaluate((Object)scriptElement);
            if (xpathResult instanceof List) {
                List values = (List)xpathResult;
                result = values.toArray(new JSParseNode[values.size()]);
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String[] getUniqueRunatValues(HTMLElementNode scriptElement) {
        String[] result = NO_STRINGS;
        if (SCRIPT_ASSIGNMENTS.containsKey(scriptElement)) {
            AssignmentInfo info = SCRIPT_ASSIGNMENTS.get(scriptElement);
            result = info.getUniqueRunatValues();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(IParseState parseState) {
        IParseNode root = parseState.getParseResults();
        Object object = PROCESS_LOCK;
        synchronized (object) {
            if (LAST_PROCESSED_ROOT != root) {
                HTMLElementNode[] scripts;
                SCRIPT_ASSIGNMENTS.clear();
                ASSIGNMENTS.clear();
                HTMLElementNode[] hTMLElementNodeArray = scripts = ParseNodeUtils.getScriptElements(root);
                int n = 0;
                int n2 = hTMLElementNodeArray.length;
                while (n < n2) {
                    HTMLElementNode scriptElement = hTMLElementNodeArray[n];
                    String runat = "client";
                    if (scriptElement.hasAttribute("runat") && (runat = scriptElement.getAttribute("runat")) == null) {
                        runat = "client";
                    }
                    JSParseNode[] functionDeclarations = ParseNodeUtils.getFunctionDeclarations(scriptElement);
                    JSParseNode[] assignments = ParseNodeUtils.getSpecialAssignments(scriptElement);
                    ParseNodeUtils parseNodeUtils = instance;
                    parseNodeUtils.getClass();
                    AssignmentInfo info = parseNodeUtils.new AssignmentInfo(runat, functionDeclarations, assignments);
                    SCRIPT_ASSIGNMENTS.put(scriptElement, info);
                    ASSIGNMENTS.addAll((Collection<JSParseNode>)Arrays.asList(assignments));
                    ++n;
                }
                LAST_PROCESSED_ROOT = root;
            }
        }
    }

    public void run(EditorFileContext fileContext) {
        IParseState parseState = fileContext.getParseState();
        ParseNodeUtils.update(parseState);
    }

    private class AssignmentInfo {
        private Map<String, Map<String, String>> _namePropertyValue;
        private Map<String, String> _nameRunatValue;
        public JSParseNode[] assignments;

        public AssignmentInfo(String runat, JSParseNode[] functionDeclarations, JSParseNode[] assignments) {
            Object functionName;
            this.assignments = assignments;
            this._namePropertyValue = new HashMap<String, Map<String, String>>();
            String defaultProxy = Boolean.toString(runat.endsWith("proxy"));
            JSParseNode[] jSParseNodeArray = functionDeclarations;
            int n = 0;
            int n2 = jSParseNodeArray.length;
            while (n < n2) {
                JSParseNode declaration = jSParseNodeArray[n];
                functionName = declaration.getAttribute(ParseNodeUtils.NAME_ATTR);
                if (!this._namePropertyValue.containsKey(functionName)) {
                    HashMap<String, String> propertyValue = new HashMap<String, String>();
                    propertyValue.put("runat", runat);
                    propertyValue.put("proxy", defaultProxy);
                    this._namePropertyValue.put((String)functionName, propertyValue);
                }
                ++n;
            }
            HashSet<String> overrides = new HashSet<String>();
            functionName = assignments;
            n2 = 0;
            int n3 = ((JSParseNode[])functionName).length;
            while (n2 < n3) {
                JSParseNode assignment = functionName[n2];
                IParseNode getProperty = assignment.getChild(0);
                String value = assignment.getChild(1).getAttribute("text");
                String functionName2 = getProperty.getChild(0).getAttribute("text");
                String propertyName = getProperty.getChild(1).getAttribute("text");
                if (this._namePropertyValue.containsKey(functionName2)) {
                    this._namePropertyValue.get(functionName2).put(propertyName, value);
                    overrides.add(functionName2);
                }
                ++n2;
            }
            this._nameRunatValue = new HashMap<String, String>();
            for (String functionName3 : this._namePropertyValue.keySet()) {
                String runatValue = this.getFunctionPropertyValue(functionName3, "runat");
                String proxyValue = this.getFunctionPropertyValue(functionName3, "proxy");
                String effectiveRunat = runat;
                if (runatValue != null || proxyValue != null) {
                    runatValue = ParseNodeUtils.getMapValue(runatValue, runat, "client", RUNAT_MAP);
                    proxyValue = ParseNodeUtils.getMapValue(proxyValue, runat, "true", PROXY_MAP);
                    String key = String.valueOf(runatValue) + "-" + proxyValue;
                    if (PROPERTY_VALUE_MAP.containsKey(key)) {
                        effectiveRunat = (String)PROPERTY_VALUE_MAP.get(key);
                    }
                }
                this._nameRunatValue.put(functionName3, effectiveRunat);
            }
            JSParseNode[] jSParseNodeArray2 = functionDeclarations;
            int n4 = 0;
            int n5 = jSParseNodeArray2.length;
            while (n4 < n5) {
                JSParseNode declaration = jSParseNodeArray2[n4];
                String functionName4 = declaration.getAttribute(ParseNodeUtils.NAME_ATTR);
                if (!overrides.contains(functionName4)) {
                    IParseNode parent = declaration.getParent();
                    while (parent != null && parent instanceof JSParseNode) {
                        String parentFunctionName;
                        if (parent.getTypeIndex() == 47 && overrides.contains(parentFunctionName = ((JSParseNode)parent).getAttribute(ParseNodeUtils.NAME_ATTR))) {
                            this._nameRunatValue.put(functionName4, this._nameRunatValue.get(parentFunctionName));
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
                ++n4;
            }
        }

        public String getFunctionPropertyValue(String functionName, String propertyName) {
            Map<String, String> propertyValue;
            String result = null;
            if (this._namePropertyValue.containsKey(functionName) && (propertyValue = this._namePropertyValue.get(functionName)).containsKey(propertyName)) {
                result = propertyValue.get(propertyName);
            }
            return result;
        }

        public String getFunctionRunatValue(String functionName) {
            String result = null;
            if (this._nameRunatValue.containsKey(functionName)) {
                result = this._nameRunatValue.get(functionName);
            }
            return result;
        }

        public String[] getUniqueRunatValues() {
            Collection<String> values = this._nameRunatValue.values();
            HashSet<String> uniqueValues = new HashSet<String>(values);
            Object[] result = uniqueValues.toArray(new String[uniqueValues.size()]);
            Arrays.sort(result);
            return result;
        }
    }
}

