/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer;

import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.actions.JaxerInfoDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JaxerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ide.framework.jaxer";
    public static final String JAXER_NATURE_ID = "com.aptana.ide.framework.jaxernature";
    public static final String HAS_BEEN_SHOWN = "com.aptana.ide.framework.jaxer.HAS_BEEN_SHOWN";
    public static final String PREFERENCE_DELIMITER = ";";
    public static final String PREVIEW_LOG_MESSAGE = "Jaxer";
    private static JaxerPlugin plugin;
    private static Map<String, Image> images;

    static {
        images = new HashMap<String, Image>();
    }

    public JaxerPlugin() {
        plugin = this;
    }

    public static void showInfoDialog(boolean block) {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean hasbeenShown = JaxerPlugin.getDefault().getPreferenceStore().getBoolean(JaxerPlugin.HAS_BEEN_SHOWN);
                if (!hasbeenShown) {
                    JaxerPlugin.getDefault().getPreferenceStore().setValue(JaxerPlugin.HAS_BEEN_SHOWN, true);
                    EventLogger.getInstance().logEvent("PREVIEW", JaxerPlugin.PREVIEW_LOG_MESSAGE);
                    JaxerInfoDialog dialog = new JaxerInfoDialog(CoreUIUtils.getActiveShell());
                    dialog.open();
                }
            }
        };
        if (block) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (CoreUIUtils.onMacOSX) {
            this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    JaxerPlugin.this.savePluginPreferences();
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JaxerPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = JaxerPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

