/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jam.dialogs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.framework.jam.dialogs.Messages;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JAMConfigurationDialog
extends TitleAreaDialog
implements IConfigurationDialog,
IValidator {
    private static final String PORT_MUST_BE_AN_INTEGER = Messages.JAMConfigurationDialog_PORT_SHOULD_BE_INTEGER;
    private static final String PORT_MUST_BE_IN_RANGE_0_TO_65534 = Messages.JAMConfigurationDialog_POST_SHOULD_BE_IN_RANGE;
    Text name;
    Text desription;
    Text directory;
    String initialHealthURL = "http://127.0.0.1:8081/aptana";
    Text healthURL;
    String hostName = "127.0.0.1";
    Text hostNameText;
    String port = "8081";
    Text portText;
    int admin = 4328;
    Text adminText;
    int webPort = 4327;
    Text webPortText;
    private HashSet<String> serverNames = new HashSet();
    private IAbstractConfiguration configuration;

    public JAMConfigurationDialog() {
        super(Display.getDefault().getActiveShell());
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_jam");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.JAMConfigurationDialog_TITLE);
        this.getShell().setText(Messages.JAMConfigurationDialog_SHELL_TITLE);
        this.setMessage(Messages.JAMConfigurationDialog_DESCRIPTION);
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 10;
        daLayout.marginWidth = 10;
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        displayArea.setLayoutData((Object)daData);
        this.name = this.createText(Messages.JAMConfigurationDialog_NAME, displayArea, null);
        this.desription = this.createText(Messages.JAMConfigurationDialog_DESCRIPTION_FIELD, displayArea, null);
        this.hostNameText = this.createText(Messages.JAMConfigurationDialog_HOSTNAME_FIELD, displayArea, null);
        this.hostNameText.setText(this.hostName);
        this.directory = this.createOpenDir(Messages.JAMConfigurationDialog_JAXER_PACKAGE_DIRECTORY, displayArea, null);
        new Label(displayArea, 0);
        Label banner = new Label(displayArea, 0);
        GridData gridData = new GridData();
        gridData.verticalIndent = -5;
        banner.setLayoutData((Object)gridData);
        banner.setText(Messages.JAMConfigurationDialog_PATH_HINT);
        new Label(displayArea, 0);
        Font smallFont = SWTUtils.getDefaultSmallFont();
        banner.setFont(smallFont);
        this.healthURL = this.createText("Heartbeat URL", displayArea, null);
        this.healthURL.setText(this.initialHealthURL);
        new Label(displayArea, 0);
        Label healthBanner = new Label(displayArea, 0);
        GridData hbData = new GridData();
        hbData.verticalIndent = -5;
        healthBanner.setLayoutData((Object)gridData);
        healthBanner.setText("(HEAD requests made at regular intervals to determine server status)");
        new Label(displayArea, 0);
        healthBanner.setFont(smallFont);
        Label lm = new Label(displayArea, 0);
        lm.setLayoutData((Object)new GridData());
        lm.setText(Messages.JAMConfigurationDialog_PORT);
        Composite cm = new Composite(displayArea, 0);
        lm.moveAbove((Control)cm);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cm);
        GridLayoutFactory.fillDefaults().numColumns(9).margins(0, 0).spacing(0, 0).applyTo(cm);
        this.portText = this.createText("", cm, null);
        this.portText.setText(this.port);
        this.portText.setFont(smallFont);
        this.adminText = this.createText(Messages.JAMConfigurationDialog_ADMIN_PORT, cm, null);
        this.adminText.setText(Integer.toString(this.admin));
        this.adminText.setFont(smallFont);
        this.webPortText = this.createText(Messages.JAMConfigurationDialog_WEB_PORT, cm, null);
        this.webPortText.setText(Integer.toString(this.webPort));
        this.webPortText.setFont(smallFont);
        boolean first = true;
        Control[] controlArray = cm.getChildren();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            GridData lData;
            Control c = controlArray[n];
            Object layoutData = c.getLayoutData();
            if (layoutData == null) {
                lData = new GridData();
                if (!first) {
                    lData.horizontalIndent = 6;
                }
                c.setLayoutData((Object)lData);
            } else {
                lData = (GridData)layoutData;
                if (!first) {
                    lData.horizontalIndent = 6;
                }
                first = false;
            }
            ++n;
        }
        return parent;
    }

    public IAbstractConfiguration getConfiguration() {
        return this.configuration;
    }

    public Dialog getDialog() {
        return this;
    }

    public boolean isEdit() {
        return false;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
    }

    public void setEdit(boolean isEdit) {
    }

    private void initDublicateNames() {
        IServer[] servers;
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer s = iServerArray[n];
            this.serverNames.add(s.getName());
            ++n;
        }
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.initDublicateNames();
        this.validate();
        return c;
    }

    public void validate() {
        Integer i;
        String name = this.name.getText();
        String hostname = this.hostNameText.getText();
        Button ok = this.getButton(0);
        if (ok == null) {
            return;
        }
        boolean error = false;
        if (name.trim().length() == 0) {
            this.setErrorMessage(Messages.JAMConfigurationDialog_NAME_SHOULD_BE_DEFINED);
            error = true;
            ok.setEnabled(false);
        } else {
            String string = String.valueOf(name) + "-Web";
            if (this.serverNames.contains(string)) {
                this.setErrorMessage(StringUtils.format((String)Messages.JAMConfigurationDialog_WEBSERVER_ALLREADY_EXISTS, (String)string));
                error = true;
            }
            if (this.serverNames.contains(string = String.valueOf(name) + "-Jaxer")) {
                this.setErrorMessage(StringUtils.format((String)Messages.JAMConfigurationDialog_JAXERSERVER_ALLREADY_EXISTS, (String)string));
                error = true;
            } else if (hostname.trim().length() == 0) {
                this.setErrorMessage(Messages.JAMConfigurationDialog_HOSTNAME_SHOULDNOT_BE_BLANK);
                error = true;
            }
        }
        if (!error) {
            try {
                i = Integer.parseInt(this.portText.getText());
                if (i < 0 || i > 65535) {
                    this.setErrorMessage(PORT_MUST_BE_IN_RANGE_0_TO_65534);
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(PORT_MUST_BE_AN_INTEGER);
                error = true;
            }
        }
        if (!error) {
            try {
                i = Integer.parseInt(this.adminText.getText());
                if (i < 0 || i > 65535) {
                    this.setErrorMessage(PORT_MUST_BE_IN_RANGE_0_TO_65534);
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(PORT_MUST_BE_AN_INTEGER);
                error = true;
            }
        }
        if (!error) {
            try {
                i = Integer.parseInt(this.webPortText.getText());
                if (i < 0 || i > 65535) {
                    this.setErrorMessage(PORT_MUST_BE_IN_RANGE_0_TO_65534);
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(PORT_MUST_BE_AN_INTEGER);
                error = true;
            }
        }
        if (!error) {
            File file = new File(this.directory.getText());
            if (file.exists()) {
                if (!file.isFile()) {
                    error = false;
                } else {
                    error = true;
                    this.setErrorMessage(Messages.JAMConfigurationDialog_WRONG_PATH);
                }
            } else {
                error = true;
                this.setErrorMessage(Messages.JAMConfigurationDialog_NOT_EXISTING_PATH);
            }
        }
        if (!error && this.healthURL.getText().trim().length() > 0) {
            try {
                new URL(this.healthURL.getText().trim());
            }
            catch (MalformedURLException malformedURLException) {
                error = true;
                this.setErrorMessage("Invalid heartbeat URL syntax. A valid HTTP address must be used (i.e http://127.0.0.1:8000/index.html");
            }
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        ok.setEnabled(!error);
    }

    protected Text createText(String label, Composite parent, String key) {
        Label ll = new Label(parent, 0);
        ll.setText(label);
        Text t = new Text(parent, 2052);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.horizontalSpan = 2;
        t.setLayoutData((Object)ptData);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JAMConfigurationDialog.this.validate();
            }
        };
        t.addModifyListener(modifyListener);
        return t;
    }

    protected Text createOpenDir(String label, Composite parent, String key) {
        Label ll = new Label(parent, 0);
        ll.setText(label);
        final Text t = new Text(parent, 2052);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.horizontalSpan = 1;
        t.setLayoutData((Object)ptData);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JAMConfigurationDialog.this.validate();
            }
        };
        t.addModifyListener(modifyListener);
        Button browser = new Button(parent, 8);
        browser.setText(Messages.JAMConfigurationDialog_BROWSE);
        browser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String open;
                File file;
                File parentFile;
                DirectoryDialog fdlg = new DirectoryDialog(JAMConfigurationDialog.this.getShell(), 4096);
                String text = t.getText();
                if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                    fdlg.setFilterPath(parentFile.getPath());
                }
                if ((open = fdlg.open()) != null) {
                    t.setText(open);
                }
            }
        });
        return t;
    }

    protected void okPressed() {
        IAbstractConfiguration initialServerConfiguration = ServerCore.getServerManager().getInitialServerConfiguration("com.aptana.ide.server.jaxer.jaxerHttpServer");
        IAbstractConfiguration generalServerConfiguration = ServerCore.getServerManager().getInitialServerConfiguration("com.aptana.ide.server.generic.genericHttpServer");
        initialServerConfiguration.setStringAttribute("name", StringUtils.format((String)"{0}-Jaxer", (String)this.name.getText()));
        generalServerConfiguration.setStringAttribute("name", StringUtils.format((String)"{0}-Web", (String)this.name.getText()));
        initialServerConfiguration.setStringAttribute("description", this.desription.getText());
        generalServerConfiguration.setStringAttribute("description", this.desription.getText());
        initialServerConfiguration.setStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY", this.hostNameText.getText());
        initialServerConfiguration.setBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY", false);
        initialServerConfiguration.setStringAttribute("JAXER_JETTY_ASSOCIATION", generalServerConfiguration.getStringAttribute("name"));
        generalServerConfiguration.setStringAttribute("association_id", initialServerConfiguration.getStringAttribute("id"));
        generalServerConfiguration.setStringAttribute("health_url", this.healthURL.getText());
        generalServerConfiguration.setIntAttribute("polling_interval", 20000);
        generalServerConfiguration.setStringAttribute("host", this.hostNameText.getText());
        initialServerConfiguration.setStringAttribute("JAXER_SERVER_ADMIN_PORT_KEY", this.adminText.getText());
        initialServerConfiguration.setStringAttribute("JAXER_SERVER_WEB_PORT_KEY", this.webPortText.getText());
        generalServerConfiguration.setStringAttribute("port", this.portText.getText());
        File file = new File(this.directory.getText());
        file = new File(file, "jaxer");
        initialServerConfiguration.setStringAttribute("logpath", new File(new File(file, "framework"), "JaxerCoreJSConsole.log").getAbsolutePath());
        this.configuration = generalServerConfiguration;
        try {
            ServerManager.getInstance().addServer(initialServerConfiguration);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error while adding server", (String)e.getMessage());
            IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)"exception while opening new server dialog", (Throwable)e);
        }
        super.okPressed();
    }

    public void setServer(IServer server) {
    }
}

