/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.macosx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.core.UpdateCore;

public class ExecutePermissionsInstallHandler
extends BaseInstallHandler {
    public static final String JAXER_CONFIGURE_FIREWALL_SHOWN = "com.aptana.ide.framework.jaxer.preferences.JAXER_CONFIGURE_FIREWALL_SHOWN";
    private File logFile;
    private IFeature targetFeature;

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        block6: {
            super.completeInstall(consumer);
            try {
                this.targetFeature = consumer.getFeature();
                this.warn("Install Completed. Feature is: " + this.targetFeature.getVersionedIdentifier().getIdentifier());
                this.warn("Install site URL: " + this.targetFeature.getSite().getURL().toExternalForm());
                this.setBundlePermissions("com.aptana.ide.framework.jaxer.server.macosx", this.targetFeature);
                this.setBundlePermissions("com.aptana.ide.framework.jaxer.server.linux", this.targetFeature);
                if (!Platform.getOS().equals("win32")) break block6;
                Preferences preferences = UpdateCore.getPlugin().getPluginPreferences();
                boolean alreadyRun = preferences.getBoolean(JAXER_CONFIGURE_FIREWALL_SHOWN);
                if (!alreadyRun) {
                    preferences.setValue(JAXER_CONFIGURE_FIREWALL_SHOWN, true);
                    UpdateCore.getPlugin().savePluginPreferences();
                    IPluginEntry pluginEntry = this.findEntry("com.aptana.ide.framework.jaxer.server.win32", this.feature);
                    try {
                        String pluginPath = this.getPluginPath(pluginEntry, "resources/ConfigureFirewall.exe", this.targetFeature);
                        Runtime.getRuntime().exec(pluginPath);
                    }
                    catch (MalformedURLException e) {
                        this.log(e);
                    }
                    catch (IOException e) {
                        this.log(e);
                    }
                }
                return;
            }
            catch (Exception ex) {
                this.warn("Exception: " + ex.getMessage());
            }
        }
    }

    private void setBundlePermissions(String bundleName, IFeature targetFeature) {
        IPluginEntry pluginEntry = this.findEntry(bundleName, this.feature);
        if (pluginEntry == null) {
            this.warn("Unable to find the plugin entry for " + bundleName + ". Can't force executable permission.");
            return;
        }
        try {
            ContentReference[] refs = this.feature.getFeatureContentProvider().getPluginEntryContentReferences(pluginEntry, this.monitor);
            int j = 0;
            while (j < refs.length) {
                ContentReference contentReference = refs[j];
                if (contentReference.getPermission() != 0) {
                    this.warn("found content reference that needs executable bit set: " + contentReference.getIdentifier());
                    this.warn("content reference isLocalReference: " + contentReference.isLocalReference());
                    this.warn("content reference url: " + contentReference.toString());
                    String pluginPath = this.getPluginPath(pluginEntry, contentReference.getIdentifier(), targetFeature);
                    this.setExecutableBit(contentReference, pluginPath);
                }
                ++j;
            }
        }
        catch (CoreException e) {
            this.log((Exception)((Object)e));
        }
    }

    private IPluginEntry findEntry(String string, IFeature targetFeature) {
        IPluginEntry[] entries = targetFeature.getPluginEntries();
        int i = 0;
        while (i < entries.length) {
            String id = entries[i].getVersionedIdentifier().getIdentifier();
            this.warn("Testing Entry ID: " + id);
            if (id.equals(string)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    private String getPluginPath(IPluginEntry pluginEntry, String contentKey, IFeature targetFeature) {
        ISite site;
        block3: {
            try {
                site = targetFeature.getSite();
                if (site != null) break block3;
                this.log("No site");
                return null;
            }
            catch (MalformedURLException e) {
                this.log(e);
                return null;
            }
        }
        this.log("default plugin path is plugins/");
        this.log("pluginEntry.getVersionedIdentifier() is " + pluginEntry.getVersionedIdentifier().toString());
        URL newURL = new URL(site.getURL(), "plugins/" + pluginEntry.getVersionedIdentifier().toString());
        String pluginPath = newURL.getFile();
        this.log("contentKey is " + contentKey);
        pluginPath = String.valueOf(pluginPath) + (pluginPath.endsWith(File.separator) ? contentKey : String.valueOf(File.separator) + contentKey);
        this.log("pluginPath is " + pluginPath);
        return pluginPath;
    }

    private void log(String string) {
        this.warn(string);
    }

    private void setExecutableBit(ContentReference reference, String filePath) {
        this.warn("Setting executable bit for: " + filePath);
        if (filePath == null) {
            return;
        }
        try {
            Process pr = Runtime.getRuntime().exec(new String[]{"/bin/chmod", "a+x", filePath});
            StreamConsumer chmodOutput = new StreamConsumer(pr.getInputStream());
            chmodOutput.setName("chmod output reader");
            chmodOutput.start();
            StreamConsumer chmodError = new StreamConsumer(pr.getErrorStream());
            chmodError.setName("chmod error reader");
            chmodError.start();
        }
        catch (IOException ioe) {
            this.log(ioe);
        }
    }

    private void warn(String string) {
        File log = this.getLogFile();
        if (log == null || !log.exists()) {
            return;
        }
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(log, true);
                writer.write(String.valueOf(string) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getLogFile() {
        if (this.logFile == null) {
            this.logFile = new File("/tmp/studio_install_handler.log");
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.logFile;
    }

    private void log(Exception ioe) {
        this.warn(ioe.getMessage());
    }

    public static class StreamConsumer
    extends Thread {
        InputStream is;
        byte[] buf;

        public StreamConsumer(InputStream inputStream) {
            this.setDaemon(true);
            this.is = inputStream;
            this.buf = new byte[512];
        }

        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                String output = sb.toString();
                System.out.println("install handler output: " + output);
            }
            catch (IOException iOException) {}
        }
    }
}

