/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.rcp.main;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.rcp.main.MainPlugin;
import com.aptana.ide.rcp.main.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;

public class LaunchHelper {
    private String dotAptanaFile = null;
    private String[] initialFiles;
    private static LaunchHelper _instance;

    public void openStartupFiles(IWorkbenchWindow window) {
        if (this.initialFiles != null) {
            if (this.initialFiles.length > 0) {
                try {
                    IntroPlugin.closeIntro();
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_UnableToCLoseWelcome, (Throwable)ex);
                }
            }
            int i = 0;
            while (i < this.initialFiles.length) {
                File file = new File(this.initialFiles[i]);
                try {
                    if (file.exists()) {
                        String editorID = this.getEditorID(file);
                        if (editorID == null) {
                            WorkbenchHelper.openFile((File)file, (IWorkbenchWindow)window);
                        } else {
                            WorkbenchHelper.openFile((String)editorID, (File)file, (IWorkbenchWindow)window);
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_ErrorOpeningFileOnStartup, (String)this.initialFiles[i]), (Throwable)e);
                }
                ++i;
            }
            this.initialFiles = null;
        }
    }

    private String getEditorID(File file) {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".js") || name.endsWith(".css")) {
            return null;
        }
        String contents = this.getFileContents(file);
        if (contents == null) {
            return null;
        }
        if ((contents = contents.toLowerCase()).indexOf("<!doctype html") != -1 || contents.indexOf("<html") != -1) {
            return "com.aptana.ide.editors.HTMLEditor";
        }
        return null;
    }

    private String getFileContents(File file) {
        int fileLength = (int)file.length();
        if (fileLength == 0) {
            return null;
        }
        if (fileLength > 100) {
            fileLength = 100;
        }
        char[] chars = new char[fileLength];
        try {
            FileReader fr = new FileReader(file);
            fr.read(chars);
            fr.close();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToGetFileContents, (String)file.getAbsolutePath()), (Throwable)e);
            return null;
        }
        return new String(chars);
    }

    public LaunchHelper getInstance() {
        if (_instance == null) {
            _instance = new LaunchHelper();
        }
        return _instance;
    }

    public void setLaunchFileCmdLineArgs(String[] args) {
        int startIndex = 0;
        String[] argList = args;
        if (argList.length > 0 && argList[0].toLowerCase().matches(".*?(aptana.exe|aptanastudio.exe)")) {
            startIndex = 1;
            String newDotAptanaFile = argList[0].replaceFirst("(?i)(aptana.exe|aptanastudio.exe)", ".aptana");
            if (this.dotAptanaFile == null) {
                this.dotAptanaFile = newDotAptanaFile;
                IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_AptanaPortCachedInFile, (String)this.dotAptanaFile));
            } else {
                IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_PortCacheFile, (Object[])new String[]{this.dotAptanaFile, newDotAptanaFile}));
            }
        }
        ArrayList<String> filesList = new ArrayList<String>();
        int i = startIndex;
        while (i < argList.length) {
            File file;
            if (!argList[i].startsWith("-") && (file = new File(argList[i])).exists()) {
                filesList.add(argList[i]);
            }
            ++i;
        }
        String[] fileList = filesList.toArray(new String[0]);
        this.initialFiles = fileList;
    }

    public boolean checkForRunningInstance() {
        int port = this.readCurrentPort();
        if (port != -1 && this.sendInitialFiles(port)) {
            return true;
        }
        CommandLineArgsServer server = null;
        try {
            server = new CommandLineArgsServer(this);
            server.start();
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_ErrorInChdeckingForCurrentInstance, (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readCurrentPort() {
        FileReader fr = null;
        if (this.dotAptanaFile == null) {
            this.dotAptanaFile = ".aptana";
        }
        try {
            fr = new FileReader(this.dotAptanaFile);
            BufferedReader br = new BufferedReader(fr);
            String sPort = br.readLine().trim();
            if (sPort.length() == 0) {
                return -1;
            }
            int n = Integer.parseInt(sPort);
            return n;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return -1;
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_UnableToFindCurrentPort, (Throwable)e);
            return 9980;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_ErrorInClosingFileReader, (Throwable)e);
                }
            }
        }
    }

    private boolean sendInitialFiles(int port) {
        Socket socket = null;
        DataOutputStream os = null;
        DataInputStream is = null;
        try {
            socket = new Socket(InetAddress.getByName("localhost"), port);
            os = new DataOutputStream(socket.getOutputStream());
            is = new DataInputStream(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_UnknownLocalHost);
            return false;
        }
        catch (IOException iOException) {
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_CouldNotGetIOConnection);
            return false;
        }
        if (socket != null && os != null && is != null) {
            try {
                int i = 0;
                while (i < this.initialFiles.length) {
                    os.writeBytes("\"" + this.initialFiles[i] + "\" ");
                    ++i;
                }
                os.writeBytes("\n");
                os.flush();
                os.close();
                is.close();
                socket.close();
                return true;
            }
            catch (UnknownHostException unknownHostException) {
                IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_TryingToConnectToUnknownHost);
            }
            catch (IOException iOException) {
                IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_IOExceptionEncountered);
            }
        }
        return false;
    }

    public void hookStartupListener() {
        try {
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass("com.aptana.ide.startup.WorkbenchStartupManager");
            Method startupListener = cls.getMethod("setStartupListener", Object.class);
            startupListener.invoke(null, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_TheStartupListenerClassIsNotAvailable);
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)MainPlugin.getDefault(), (String)Messages.LaunchHelper_ErrorHookingStartupListener, (Throwable)e);
        }
    }

    public void startupPerformed(String args) {
        String[] startupArgs = this.parseCommandLineArgs(args);
        this.setLaunchFileCmdLineArgs(startupArgs);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                LaunchHelper.this.openStartupFiles(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        });
    }

    private String[] parseCommandLineArgs(String cmdLine) {
        char quote = '\"';
        char flagStart = '-';
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        try {
            char[] chars = cmdLine.toCharArray();
            boolean quoteMode = false;
            int i = 0;
            while (i < chars.length) {
                boolean endWord = false;
                char ch = chars[i];
                if (ch == quote) {
                    if (quoteMode) {
                        quoteMode = false;
                        endWord = true;
                    } else {
                        quoteMode = true;
                    }
                } else if (Character.isWhitespace(ch) && !quoteMode) {
                    endWord = true;
                } else {
                    word.append(ch);
                }
                if (endWord) {
                    if (word.length() > 0 && word.charAt(0) != flagStart) {
                        args.add(word.toString());
                    }
                    word.setLength(0);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            IdeLog.logError((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToRecognizeCommandLineLaunchArguments, (String)cmdLine));
        }
        if (word.length() > 0 && word.charAt(0) != flagStart) {
            args.add(word.toString());
        }
        String[] argArray = args.toArray(new String[0]);
        return argArray;
    }

    class CommandLineArgsServer
    extends Thread {
        public static final int STARTING_PORT = 9980;
        LaunchHelper helper;
        ServerSocket server;
        String line;
        DataInputStream is;
        PrintStream os;
        Socket clientSocket;

        public CommandLineArgsServer(LaunchHelper helper) throws IOException {
            super("CommandLineArgsServer");
            this.server = null;
            this.clientSocket = null;
            this.helper = helper;
            int port = this.getPort();
            if (port == -1) {
                throw new IOException(StringUtils.format((String)Messages.LaunchHelper_CouldNotFindOpenPort, (Object[])new String[]{String.valueOf(9980), String.valueOf(9990)}));
            }
            IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_BoundAptanaToPort, (int)port));
            try {
                FileWriter f = new FileWriter(LaunchHelper.this.dotAptanaFile);
                BufferedWriter out = new BufferedWriter(f);
                out.write("" + port);
                out.close();
                new File(LaunchHelper.this.dotAptanaFile).deleteOnExit();
            }
            catch (IOException iOException) {}
        }

        public int getPort() {
            int tries = 10;
            int port = 9980;
            while (tries > 0) {
                try {
                    this.server = new ServerSocket(port, 0, null);
                    this.server.setSoTimeout(1000);
                    return port;
                }
                catch (IOException iOException) {
                    IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchHelper_UnableToBindToPort, (int)port));
                    --tries;
                    ++port;
                }
            }
            return -1;
        }

        public void run() {
            while (!this.server.isClosed()) {
                try {
                    this.clientSocket = this.server.accept();
                    BufferedReader r = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
                    this.line = r.readLine().trim();
                    w.write("pong");
                    w.flush();
                    this.clientSocket.close();
                    if (this.line.length() <= 0) continue;
                    this.helper.startupPerformed(this.line);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (Exception e) {
                    IdeLog.logInfo((Plugin)MainPlugin.getDefault(), (String)CoreStrings.ERROR, (Throwable)e);
                }
            }
        }
    }
}

