/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex.nfa;

import com.aptana.ide.regex.inputs.Input;
import com.aptana.ide.regex.nfa.NFANode;
import com.aptana.ide.regex.sets.CharacterSet;
import java.util.Stack;

public class NFAGraph {
    static Stack<Integer> recycle = new Stack();
    static NFANode[] nodes = new NFANode[0];
    int _start;
    int _end;

    public int getAcceptState(int nodeIndex) {
        return this.getItem(nodeIndex).getAcceptState();
    }

    public NFANode getItem(int index) {
        return nodes[index];
    }

    public int getEnd() {
        return this._end;
    }

    public CharacterSet getInputSet() {
        CharacterSet result = new CharacterSet();
        int i = 0;
        while (i < nodes.length) {
            Input input = this.getItem(i).getInput();
            if (input != null) {
                result.addMembers(input.getCharacters());
            }
            ++i;
        }
        return result;
    }

    public int getStart() {
        return this._start;
    }

    public NFAGraph(int acceptState) {
        this._end = this._start = this.createNewState();
        this.getItem(this._end).setAcceptState(acceptState);
    }

    public void add(Input input) {
        NFANode previousEnd = this.getItem(this._end);
        this._end = this.createNewState();
        this.getItem(this._end).setAcceptState(previousEnd.getAcceptState());
        previousEnd.setInput(input);
        previousEnd.setNext(this._end);
        previousEnd.setAcceptState(-1);
    }

    public void andMachines(NFAGraph rhs) {
        this.getItem(this._end).copy(rhs.getItem(rhs._start));
        rhs.recycleNode(rhs._start);
        rhs._start = this._end;
        this._end = rhs._end;
    }

    private void applyClosure(int type) {
        int front = this.createNewState();
        int back = this.createNewState();
        this.getItem(front).addEpsilon(this._start);
        if (type == 0 || type == 2) {
            this.getItem(front).addEpsilon(back);
        }
        if (type == 0 || type == 1) {
            this.getItem(this._end).addEpsilon(this._start);
        }
        this.getItem(back).setAcceptState(this.getItem(this._end).getAcceptState());
        this.getItem(this._end).addEpsilon(back);
        this.getItem(this._end).setAcceptState(-1);
        this._start = front;
        this._end = back;
    }

    public int createNewState() {
        int result;
        if (recycle.size() > 0) {
            result = recycle.pop();
        } else {
            result = nodes.length;
            NFANode[] newNodes = new NFANode[result + 1];
            System.arraycopy(nodes, 0, newNodes, 0, result);
            newNodes[result] = new NFANode();
            nodes = newNodes;
        }
        return result;
    }

    public void kleeneClosure() {
        this.applyClosure(0);
    }

    public void option() {
        this.applyClosure(2);
    }

    public void orMachines(NFAGraph rhs) {
        int front = this.createNewState();
        int back = this.createNewState();
        this.getItem(front).addEpsilon(this._start);
        this.getItem(front).addEpsilon(rhs._start);
        this.getItem(back).setAcceptState(this.getItem(this._end).getAcceptState());
        this.getItem(this._end).addEpsilon(back);
        rhs.getItem(rhs._end).addEpsilon(back);
        this.getItem(this._end).setAcceptState(-1);
        rhs.getItem(rhs._end).setAcceptState(-1);
        this._start = front;
        this._end = back;
    }

    public void positiveClosure() {
        this.applyClosure(1);
    }

    public void recycleNode(int index) {
        this.getItem(index).reset();
        recycle.push(new Integer(index));
    }

    public static void reset() {
        nodes = new NFANode[0];
        recycle.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NFA\n===\n");
        int i = 0;
        while (i < nodes.length) {
            if (i == this._start && i == this._end) {
                sb.append("<->").append(i).append(" : ");
            } else if (i == this._start) {
                sb.append(" ->").append(i).append(" : ");
            } else if (i == this._end) {
                sb.append("<- ").append(i).append(" : ");
            } else {
                sb.append("   ").append(i).append(" : ");
            }
            sb.append(this.getItem(i));
            sb.append("\n");
            ++i;
        }
        sb.append("\nInputs\n======\n").append(this.getInputSet()).append("\n");
        return sb.toString();
    }
}

