/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.matcher;

import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.ILexerBuilder;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ILanguageChangeListener;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.Messages;
import com.aptana.ide.parsing.ParseStateChild;
import com.aptana.ide.parsing.ParsingPlugin;
import com.aptana.ide.parsing.matcher.RuleMatcher;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.text.ParseException;

public class MatcherParser
implements IParser {
    private static final String DEFAULT_GROUP = "default";
    private String _language;
    private ILanguageChangeListener _languageChangeListener;
    private ILexer _lexer;
    private IParseState _parseState;
    private RuleMatcher _startRule;

    public MatcherParser(String language) {
        this._language = language;
    }

    public void addLexerGrammar(ILexerBuilder builder) throws LexerException {
    }

    public void changeLanguage(String mimeType, int offset, IParseNode parentNode) throws LexerException, ParseException {
    }

    public IParseState createParseState(IParseState parent) {
        ParseStateChild result = parent == null ? new ParseStateChild(this.getLanguage()) : new ParseStateChild(this.getLanguage(), parent);
        return result;
    }

    public String getLanguage() {
        return this._language;
    }

    public ILanguageChangeListener getLanguageChangeListener() {
        return this._languageChangeListener;
    }

    protected LexemeList getLexemeList() {
        IParseState parseState = this.getParseState();
        LexemeList result = null;
        if (parseState != null) {
            result = parseState.getLexemeList();
        }
        return result;
    }

    public ILexer getLexer() {
        return this._lexer;
    }

    public IParser getParserForMimeType(String language) {
        MatcherParser result = null;
        if (this._language.equals(language)) {
            result = this;
        }
        return result;
    }

    protected IParseNodeFactory getParseNodeFactory() {
        IParseState parseState = this.getParseState();
        IParseNodeFactory result = null;
        if (parseState != null) {
            result = parseState.getParseNodeFactory();
        }
        return result;
    }

    protected IParseState getParseState() {
        return this._parseState;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setLanguageAndGroup(language, DEFAULT_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseNode parse(IParseState parseState) throws ParseException, LexerException {
        IParseNode result = null;
        LexemeList lexemeList = parseState.getLexemeList();
        synchronized (lexemeList) {
            this._parseState = parseState;
            IParseNodeFactory nodeFactory = this.getParseNodeFactory();
            if (nodeFactory != null) {
                result = nodeFactory.createRootNode();
            }
            ILexer lexer = this.getLexer();
            lexer.setLexemeCache(this.getLexemeList());
            lexer.setSource(parseState.getSource());
            lexer.setCurrentOffset(0);
            parseState.onBeforeParse();
            try {
                this.parseAll(result);
            }
            catch (ParseException parseException) {
            }
            catch (Exception e) {
                ParsingPlugin.logInfo(Messages.ParserBase_UnexpectedErrorDuringParse, e);
                System.err.println(Messages.ParserBase_UnexpectedErrorDuringParse);
                e.printStackTrace();
            }
            this._parseState.setParseResults(result);
            parseState.onAfterParse();
        }
        return result;
    }

    public void parseAll(IParseNode parentNode) throws ParseException, LexerException {
        LexemeList lexemeList;
        if (this._startRule != null && (lexemeList = this.getLexemeList()) != null && lexemeList.size() > 0) {
            IParseNode result;
            Lexeme[] lexemes = lexemeList.copyRange(0, lexemeList.size() - 1);
            this._startRule.match(lexemes, 0, lexemes.length);
            if (parentNode != null && (result = this._startRule.getParseResults()) != null) {
                parentNode.appendChild(result);
            }
        }
    }

    public void setLanguageChangeListener(ILanguageChangeListener eventHandler) {
        this._languageChangeListener = eventHandler;
    }
}

