/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.bnf.IReductionContext;
import com.aptana.ide.parsing.bnf.nodes.SequenceNode;
import java.util.List;
import java.util.Map;

public class ReductionContext
implements IReductionContext {
    private static final Object[] NO_NODES = new Object[0];
    private IParser _parser;
    private String _productionName;
    private String _action;
    private Map<String, List<Integer>> _nameIndex;
    private int _nodeCount;
    private Object[] _nodes;

    public ReductionContext(String productionName, SequenceNode rule, IParser parser) {
        this(productionName, rule);
        this._parser = parser;
    }

    public ReductionContext(String productionName, SequenceNode rule) {
        this._productionName = productionName;
        this._action = rule.getActionName();
        this._nameIndex = rule.getNameIndexMap();
        this._nodeCount = rule.getChildCount();
        this._nodes = NO_NODES;
    }

    public String getAction() {
        return this._action;
    }

    public Object getNode(int index) {
        Object result = null;
        if (index >= 0 && index < this._nodes.length) {
            result = this._nodes[index];
        }
        return result;
    }

    public Object getNode(String name) {
        return this.getNode(name, 0);
    }

    public Object getNode(String name, int index) {
        int nodeIndex = this.getNodeIndex(name, index);
        Object result = null;
        if (nodeIndex != -1) {
            result = this._nodes[nodeIndex];
        }
        return result;
    }

    public int getNodeCount() {
        return this._nodeCount;
    }

    private int getNodeIndex(String name, int index) {
        int result = -1;
        if (this._nameIndex != null && this._nameIndex.containsKey(name)) {
            List<Integer> indexes = this._nameIndex.get(name);
            if (index >= 0 && index < indexes.size()) {
                result = indexes.get(index);
            }
        }
        return result;
    }

    public Object[] getNodes() {
        return this._nodes;
    }

    public IParser getParser() {
        return this._parser;
    }

    public String getProductionName() {
        return this._productionName;
    }

    public void setNodes(Object[] nodes) {
        this._nodes = nodes == null ? NO_NODES : nodes;
    }
}

