/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata;

import com.aptana.ide.metadata.IMetadataItem;
import com.aptana.ide.metadata.UserAgent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataItem
implements IMetadataItem,
Cloneable {
    private static final String EMPTY = "";
    private String name = "";
    private String description = "";
    private String deprecatedDescription = "";
    private String hint = "";
    private ArrayList<UserAgent> fUserAgents;

    @Override
    public void addUserAgent(UserAgent value) {
        if (this.fUserAgents == null) {
            this.fUserAgents = new ArrayList();
        }
        this.fUserAgents.add(value);
    }

    public UserAgent[] getUserAgents() {
        if (this.fUserAgents == null) {
            return new UserAgent[0];
        }
        return this.fUserAgents.toArray(new UserAgent[0]);
    }

    @Override
    public void setName(String name) {
        this.name = name == null ? EMPTY : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description == null ? EMPTY : description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDeprecatedDescription(String deprecatedDescription) {
        this.deprecatedDescription = deprecatedDescription == null ? EMPTY : deprecatedDescription;
    }

    public String getDeprecatedDescription() {
        return this.deprecatedDescription;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint == null ? EMPTY : hint;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.name = input.readUTF();
        this.description = input.readUTF();
        this.hint = input.readUTF();
        int size = input.readInt();
        if (size > 0) {
            this.fUserAgents = new ArrayList();
            int i = 0;
            while (i < size) {
                UserAgent param = new UserAgent();
                param.read(input);
                this.fUserAgents.add(param);
                ++i;
            }
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.name);
        output.writeUTF(this.description);
        output.writeUTF(this.hint);
        if (this.fUserAgents != null) {
            output.writeInt(this.fUserAgents.size());
            int i = 0;
            while (i < this.fUserAgents.size()) {
                UserAgent param = this.fUserAgents.get(i);
                param.write(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
    }

    protected void writeArrayList(DataOutput output, ArrayList<IMetadataItem> list) throws IOException {
        output.writeInt(list.size());
        for (IMetadataItem item : list) {
            item.write(output);
        }
    }

    protected void writeHashtable(DataOutput output, Hashtable<String, IMetadataItem> list) throws IOException {
        output.writeInt(list.size());
        for (IMetadataItem item : list.values()) {
            item.write(output);
        }
    }

    @Override
    public String[] getUserAgentPlatformNames() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.fUserAgents != null) {
            int i = 0;
            while (i < this.fUserAgents.size()) {
                UserAgent param = this.fUserAgents.get(i);
                al.add(param.getPlatform());
                ++i;
            }
        }
        return al.toArray(new String[al.size()]);
    }

    public void merge(MetadataItem element) {
        String desc;
        if (this.getName().equals(EMPTY) && !element.getName().equals(EMPTY)) {
            this.setName(element.getName());
        }
        if (!element.getDescription().equals(EMPTY)) {
            desc = this.getDescription();
            if (!desc.equals(EMPTY)) {
                desc = String.valueOf(desc) + " ";
            }
            this.setDescription(String.valueOf(desc) + element.getDescription());
        }
        if (!element.getDeprecatedDescription().equals(EMPTY)) {
            desc = this.getDeprecatedDescription();
            if (!desc.equals(EMPTY)) {
                desc = String.valueOf(desc) + " ";
            }
            this.setDeprecatedDescription(String.valueOf(desc) + element.getDeprecatedDescription());
        }
        if (!element.getHint().equals(EMPTY)) {
            desc = this.getHint();
            if (!desc.equals(EMPTY)) {
                desc = String.valueOf(desc) + " ";
            }
            this.setHint(String.valueOf(desc) + element.getHint());
        }
        UserAgent[] ua = element.getUserAgents();
        int i = 0;
        while (i < ua.length) {
            this.addUserAgent(ua[i]);
            ++i;
        }
    }
}

