/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.matcher.AbstractCharacterMatcher;
import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.AndMatcher;
import com.aptana.ide.lexer.matcher.CharacterClassMatcher;
import com.aptana.ide.lexer.matcher.CharacterMatcher;
import com.aptana.ide.lexer.matcher.DigitMatcher;
import com.aptana.ide.lexer.matcher.EndOfFileMatcher;
import com.aptana.ide.lexer.matcher.EndOfLineMatcher;
import com.aptana.ide.lexer.matcher.LookaheadMatcher;
import com.aptana.ide.lexer.matcher.OneOrMoreMatcher;
import com.aptana.ide.lexer.matcher.OptionalMatcher;
import com.aptana.ide.lexer.matcher.OrMatcher;
import com.aptana.ide.lexer.matcher.RepetitionMatcher;
import com.aptana.ide.lexer.matcher.StartOfFileMatcher;
import com.aptana.ide.lexer.matcher.StartOfLineMatcher;
import com.aptana.ide.lexer.matcher.StringMatcher;
import com.aptana.ide.lexer.matcher.WhitespaceMatcher;
import com.aptana.ide.lexer.matcher.WordBoundaryMatcher;
import com.aptana.ide.lexer.matcher.WordMatcher;
import com.aptana.ide.lexer.matcher.ZeroOrMoreMatcher;
import com.aptana.ide.parsing.bnf.AbstractHandler;
import com.aptana.ide.parsing.bnf.IReductionContext;
import com.aptana.xml.INode;

public class RegexMatcherHandler
extends AbstractHandler {
    private boolean _caseInsensitive;

    public RegexMatcherHandler() {
        this(false);
    }

    public RegexMatcherHandler(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public Object onAddAndExpression(IReductionContext context) {
        OrMatcher result;
        Object[] nodes = context.getNodes();
        INode node1 = (INode)nodes[0];
        INode node2 = (INode)nodes[2];
        if (node1 instanceof OrMatcher) {
            OrMatcher orMatcher = (OrMatcher)node1;
            orMatcher.appendChild(node2);
            result = orMatcher;
        } else {
            OrMatcher matcher = new OrMatcher();
            matcher.appendChild(node1);
            matcher.appendChild(node2);
            result = matcher;
        }
        return result;
    }

    public Object onAddCCExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = (CharacterClassMatcher)nodes[0];
        CharacterClassMatcher rhs = (CharacterClassMatcher)nodes[1];
        matcher.addCharacters(rhs.getCharacters());
        return matcher;
    }

    public Object onAddFactor(IReductionContext context) {
        AndMatcher result;
        Object[] nodes = context.getNodes();
        INode node1 = (INode)nodes[0];
        INode node2 = (INode)nodes[1];
        if (node1 instanceof AndMatcher) {
            AndMatcher and1 = (AndMatcher)node1;
            and1.appendChild(node2);
            result = and1;
        } else {
            AndMatcher matcher = new AndMatcher();
            matcher.appendChild(node1);
            matcher.appendChild(node2);
            result = matcher;
        }
        return result;
    }

    public Object onCC(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[1];
    }

    public Object onCharacter(IReductionContext context) {
        AbstractCharacterMatcher result;
        Object[] nodes = context.getNodes();
        char c = ((Lexeme)nodes[0]).getText().charAt(0);
        if (this._caseInsensitive && Character.isLetter(c)) {
            CharacterClassMatcher ccMatcher = new CharacterClassMatcher();
            ccMatcher.addCharacter(Character.toLowerCase(c));
            ccMatcher.addCharacter(Character.toUpperCase(c));
            result = ccMatcher;
        } else {
            result = new CharacterMatcher(c);
        }
        return result;
    }

    public Object onCharacterClass(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onCharacterExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        char c = ((Lexeme)nodes[0]).getText().charAt(0);
        if (this._caseInsensitive && Character.isLetter(c)) {
            matcher.addCharacter(Character.toLowerCase(c));
            matcher.addCharacter(Character.toUpperCase(c));
        } else {
            matcher.addCharacter(c);
        }
        return matcher;
    }

    public Object onCharacterRangeExpression(IReductionContext context) {
        char c;
        char c2;
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        char c1 = ((Lexeme)nodes[0]).getText().charAt(0);
        if (c1 > (c2 = ((Lexeme)nodes[2]).getText().charAt(0))) {
            char tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        if (this._caseInsensitive && Character.isLetter(c1) && Character.isLetter(c2)) {
            c = Character.toLowerCase(c1);
            while (c <= Character.toLowerCase(c2)) {
                matcher.addCharacter(c);
                c = (char)(c + '\u0001');
            }
            c = Character.toUpperCase(c1);
            while (c <= Character.toUpperCase(c2)) {
                matcher.addCharacter(c);
                c = (char)(c + '\u0001');
            }
        } else {
            c = c1;
            while (c <= c2) {
                matcher.addCharacter(c);
                c = (char)(c + '\u0001');
            }
        }
        return matcher;
    }

    public Object onDot(IReductionContext context) {
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        matcher.setNegate(true);
        matcher.addCharacters(new char[]{'\r', '\n'});
        return matcher;
    }

    public Object onEmptyCC(IReductionContext context) {
        return new CharacterClassMatcher();
    }

    public Object onEndOrExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        AndMatcher matcher = new AndMatcher();
        EndOfLineMatcher endLine = new EndOfLineMatcher();
        matcher.appendChild((INode)nodes[0]);
        matcher.appendChild(endLine);
        return matcher;
    }

    public Object onEscapedCharacter(IReductionContext context) {
        AbstractTextMatcher result;
        Object[] nodes = context.getNodes();
        char c = ((Lexeme)nodes[0]).getText().charAt(1);
        switch (c) {
            case 'A': {
                result = new StartOfFileMatcher();
                break;
            }
            case 'b': {
                result = new WordBoundaryMatcher();
                break;
            }
            case 'B': {
                WordBoundaryMatcher wordBoundary = new WordBoundaryMatcher();
                wordBoundary.setNegate(true);
                result = wordBoundary;
                break;
            }
            case 'D': {
                DigitMatcher noDigits = new DigitMatcher();
                noDigits.setNegate(true);
                result = noDigits;
                break;
            }
            case 'd': {
                result = new DigitMatcher();
                break;
            }
            case 'f': {
                result = new CharacterMatcher('\f');
                break;
            }
            case 'n': {
                result = new CharacterMatcher('\n');
                break;
            }
            case 'r': {
                result = new CharacterMatcher('\r');
                break;
            }
            case 'S': {
                WhitespaceMatcher noWhitespace = new WhitespaceMatcher();
                noWhitespace.setNegate(true);
                result = noWhitespace;
                break;
            }
            case 's': {
                result = new WhitespaceMatcher();
                break;
            }
            case 't': {
                result = new CharacterMatcher('\t');
                break;
            }
            case 'v': {
                result = new CharacterMatcher('\u000b');
                break;
            }
            case 'W': {
                WordMatcher wordMatcher = new WordMatcher();
                wordMatcher.setNegate(true);
                result = wordMatcher;
                break;
            }
            case 'w': {
                result = new WordMatcher();
                break;
            }
            case 'z': {
                result = new EndOfFileMatcher();
                break;
            }
            default: {
                result = new CharacterMatcher(c);
            }
        }
        return result;
    }

    public Object onFirstAndExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onFirstCCExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onFirstFactor(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onMinusCC(IReductionContext context) {
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = (CharacterClassMatcher)nodes[2];
        matcher.addCharacter('-');
        return matcher;
    }

    public Object onMinusOnlyCC(IReductionContext context) {
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        matcher.addCharacter('-');
        return matcher;
    }

    public Object onNegatedCC(IReductionContext context) {
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = (CharacterClassMatcher)nodes[2];
        matcher.setNegate(true);
        return matcher;
    }

    public Object onNegatedEmptyCC(IReductionContext context) {
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        matcher.setNegate(true);
        return matcher;
    }

    public Object onNegativeLookahead(IReductionContext context) {
        Object[] nodes = context.getNodes();
        LookaheadMatcher matcher = new LookaheadMatcher();
        matcher.setNegate(true);
        matcher.appendChild((INode)nodes[1]);
        return matcher;
    }

    public Object onNegatedMinusCC(IReductionContext context) {
        Object[] nodes = context.getNodes();
        CharacterClassMatcher matcher = (CharacterClassMatcher)nodes[3];
        matcher.setNegate(true);
        matcher.addCharacter('-');
        return matcher;
    }

    public Object onNegatedMinusOnlyCC(IReductionContext context) {
        CharacterClassMatcher matcher = new CharacterClassMatcher();
        matcher.setNegate(true);
        matcher.addCharacter('-');
        return matcher;
    }

    public Object onOrExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onOrExprGroup(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[1];
    }

    public Object onPositiveLookahead(IReductionContext context) {
        Object[] nodes = context.getNodes();
        LookaheadMatcher matcher = new LookaheadMatcher();
        matcher.appendChild((INode)nodes[1]);
        return matcher;
    }

    public Object onStartAndEndOrExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        AndMatcher matcher = new AndMatcher();
        StartOfLineMatcher startLine = new StartOfLineMatcher();
        EndOfLineMatcher endLine = new EndOfLineMatcher();
        matcher.appendChild(startLine);
        matcher.appendChild((INode)nodes[1]);
        matcher.appendChild(endLine);
        return matcher;
    }

    public Object onStartOrExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        AndMatcher matcher = new AndMatcher();
        StartOfLineMatcher startLine = new StartOfLineMatcher();
        matcher.appendChild(startLine);
        matcher.appendChild((INode)nodes[1]);
        return matcher;
    }

    public Object onTerm(IReductionContext context) {
        Object[] nodes = context.getNodes();
        return nodes[0];
    }

    public Object onTermPlus(IReductionContext context) {
        Object[] nodes = context.getNodes();
        OneOrMoreMatcher matcher = new OneOrMoreMatcher();
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermQuestion(IReductionContext context) {
        Object[] nodes = context.getNodes();
        OptionalMatcher matcher = new OptionalMatcher();
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermRepeat(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String repeatString = ((Lexeme)nodes[2]).getText();
        int repeatCount = Integer.parseInt(repeatString);
        RepetitionMatcher matcher = new RepetitionMatcher(repeatCount, repeatCount);
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermRepeatLowerBound(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String lowerBoundString = ((Lexeme)nodes[2]).getText();
        int lowerBound = Integer.parseInt(lowerBoundString);
        RepetitionMatcher matcher = new RepetitionMatcher(lowerBound, Integer.MAX_VALUE);
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermRepeatUpperBound(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String upperBoundString = ((Lexeme)nodes[3]).getText();
        int upperBound = Integer.parseInt(upperBoundString);
        RepetitionMatcher matcher = new RepetitionMatcher(0, upperBound);
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermRepeatRange(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String lowerBoundString = ((Lexeme)nodes[2]).getText();
        String upperBoundString = ((Lexeme)nodes[4]).getText();
        int lowerBound = Integer.parseInt(lowerBoundString);
        int upperBound = Integer.parseInt(upperBoundString);
        RepetitionMatcher matcher = new RepetitionMatcher(lowerBound, upperBound);
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onTermStar(IReductionContext context) {
        Object[] nodes = context.getNodes();
        ZeroOrMoreMatcher matcher = new ZeroOrMoreMatcher();
        matcher.appendChild((INode)nodes[0]);
        return matcher;
    }

    public Object onWhitespace(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String whitespace = ((Lexeme)nodes[0]).getText();
        AbstractTextMatcher result = whitespace.length() > 1 ? new StringMatcher(whitespace) : new CharacterMatcher(whitespace.charAt(0));
        return result;
    }

    public Object onWhitespaceExpression(IReductionContext context) {
        Object[] nodes = context.getNodes();
        String whitespace = ((Lexeme)nodes[0]).getText();
        return new CharacterClassMatcher(whitespace);
    }
}

