/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.xml.INode;

public class OrMatcher
extends AbstractTextMatcher {
    private MatcherMap _firstCharacters;

    public void addChildTypes() {
        this.addChildType(ITextMatcher.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        MatcherMap localMap = null;
        if (this._firstCharacters == null) {
            localMap = new MatcherMap();
        }
        int i = 0;
        while (i < this.getChildCount()) {
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher) {
                ITextMatcher matcher = (ITextMatcher)child;
                matcher.addFirstCharacters(map, target);
                if (localMap != null) {
                    matcher.addFirstCharacters(localMap);
                }
            }
            ++i;
        }
        if (localMap != null) {
            this._firstCharacters = localMap;
            this._firstCharacters.setSealed();
        }
    }

    public boolean buildFirstCharacterMap() {
        MatcherMap map = new MatcherMap();
        int i = 0;
        while (i < this.getChildCount()) {
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher) {
                ITextMatcher matcher = (ITextMatcher)child;
                matcher.addFirstCharacters(map);
            }
            ++i;
        }
        this._firstCharacters = map;
        this._firstCharacters.setSealed();
        return !this._firstCharacters.hasUncategorizedMatchers();
    }

    public boolean canMatchNothing() {
        boolean result = false;
        int i = 0;
        while (i < this.getChildCount()) {
            ITextMatcher matcher;
            INode child = this.getChild(i);
            if (child instanceof ITextMatcher && (matcher = (ITextMatcher)child).canMatchNothing()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public int match(char[] source, int offset, int eofset) {
        int result = -1;
        if (this._firstCharacters != null) {
            ITextMatcher[] matchers;
            if (offset < eofset) {
                char c = source[offset];
                matchers = this._firstCharacters.getMatchers(c);
            } else {
                matchers = this._firstCharacters.getUncategorizedMatchers();
            }
            int i = 0;
            while (i < matchers.length) {
                ITextMatcher matcher = matchers[i];
                result = matcher.match(source, offset, eofset);
                if (result != -1) {
                    this.accept(source, offset, result, this.token);
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getChildCount()) {
                ITextMatcher matcher = (ITextMatcher)this.getChild(i);
                result = matcher.match(source, offset, eofset);
                if (result != -1) {
                    this.accept(source, offset, result, this.token);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int childCount = this.getChildCount();
        if (childCount > 0) {
            buffer.append("(");
            buffer.append(this.getChild(0));
            int i = 1;
            while (i < childCount) {
                buffer.append(" | ");
                buffer.append(this.getChild(i));
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

