/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import java.util.Arrays;

public class IdentifierMatcher
extends AbstractTextMatcher {
    private static final char[] NO_CHARACTERS = new char[0];
    private char[] _startCharacters = NO_CHARACTERS;
    private char[] _partCharacters = NO_CHARACTERS;

    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this._startCharacters != null) {
            int i = 0;
            while (i < this._startCharacters.length) {
                map.addCharacterMatcher(this._startCharacters[i], target);
                ++i;
            }
        }
        map.addLetterMatcher(target);
    }

    public int match(char[] source, int offset, int eofset) {
        char c;
        int result = offset;
        if (result < eofset && (Character.isLetter(c = source[result]) || Arrays.binarySearch(this._startCharacters, c) >= 0)) {
            ++result;
            while (result < eofset) {
                c = source[result];
                if (!Character.isLetterOrDigit(c) && Arrays.binarySearch(this._partCharacters, c) < 0) break;
                ++result;
            }
        }
        if (result != offset) {
            this.accept(source, offset, result, this.token);
        } else {
            result = -1;
        }
        return result;
    }

    public void setPartCharacters(String partCharacters) {
        if (partCharacters == null || partCharacters.length() == 0) {
            this._partCharacters = NO_CHARACTERS;
        } else {
            this._partCharacters = partCharacters.toCharArray();
            Arrays.sort(this._partCharacters);
        }
    }

    public void setStartCharacters(String startCharacters) {
        if (startCharacters == null || startCharacters.length() == 0) {
            this._startCharacters = NO_CHARACTERS;
        } else {
            this._startCharacters = startCharacters.toCharArray();
            Arrays.sort(this._startCharacters);
        }
    }
}

