/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Messages;
import com.aptana.ide.lexer.Token;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TokenList
implements ITokenList {
    private static final String[] NO_STRINGS = new String[0];
    private String _language;
    private List<IToken> _tokens = new ArrayList<IToken>();
    private int[] _ignoreSet;
    private String _currentGroupName;
    private IEnumerationMap _categories;
    private IEnumerationMap _types;
    private Map<String, Integer> _groups = new HashMap<String, Integer>();
    private Map<Integer, String> _groupByIndex = new HashMap<Integer, String>();
    private boolean _isSealed;

    public TokenList(String language) {
        this();
        this._language = language;
        this._currentGroupName = "";
    }

    public TokenList() {
    }

    public IEnumerationMap getCategoryMap() {
        return this._categories;
    }

    public void setCategoryMap(IEnumerationMap map) {
        this._categories = map;
    }

    public IEnumerationMap getTypeMap() {
        return this._types;
    }

    public void setTypeMap(IEnumerationMap map) {
        this._types = map;
    }

    public String[] getTokenCategoriesByName() {
        String[] result = NO_STRINGS;
        if (this._categories != null) {
            result = this._categories.getNames();
        }
        return result;
    }

    public String[] getTokenTypesByName() {
        String[] result = NO_STRINGS;
        if (this._types != null) {
            result = this._types.getNames();
        }
        return result;
    }

    public String getGroup(int index) {
        String result = "";
        if (this._groupByIndex.containsKey(index)) {
            result = this._groupByIndex.get(index);
        }
        return result;
    }

    protected int getGroupCount() {
        return this._groups.size();
    }

    protected int getGroupIndex(String groupName) {
        int result = -1;
        if (this._groups.containsKey(groupName)) {
            result = this._groups.get(groupName);
        }
        return result;
    }

    protected void setGroupIndex(String groupName, int index) {
        this._groups.put(groupName, index);
        this._groupByIndex.put(index, groupName);
    }

    public void seal() throws LexerException {
        this.setSealed();
        int i = 0;
        while (i < this._tokens.size()) {
            IToken token = this.get(i);
            token.seal();
            ++i;
        }
    }

    protected void setSealed() {
        this._isSealed = true;
    }

    public IToken get(int index) {
        return this._tokens.get(index);
    }

    public String getCurrentGroup() {
        return this._currentGroupName;
    }

    public void setCurrentGroup(String groupName) throws LexerException {
        this._currentGroupName = groupName;
    }

    public void setCurrentGroup(int index) {
        String groupName = this._groupByIndex.get(index);
        if (groupName != null) {
            this._currentGroupName = groupName;
        }
    }

    public String[] getGroupNames() {
        Set<String> keys = this._groups.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public int[] getIgnoreSet() {
        return this._ignoreSet;
    }

    public void setIgnoreSet(int[] set) {
        if (set != null) {
            Arrays.sort(set);
        }
        this._ignoreSet = set;
    }

    public String getLanguage() {
        return this._language;
    }

    protected void setLanguage(String language) {
        this._language = language;
    }

    protected void internalAdd(IToken token) {
        this._tokens.add(token);
    }

    public int add(String category, String type, String displayName) {
        IToken token = this.createToken();
        token.setCategory(category);
        token.setType(type);
        token.setDisplayName(displayName);
        return this.add(token);
    }

    public int add(String category, String type, String displayName, String group) {
        IToken token = this.createToken();
        token.setCategory(category);
        token.setType(type);
        token.setDisplayName(displayName);
        token.setLexerGroup(group);
        token.setNewLexerGroup(group);
        return this.add(token);
    }

    public int add(String category, String type, String displayName, String group, String newGroup) {
        IToken token = this.createToken();
        token.setCategory(category);
        token.setType(type);
        token.setDisplayName(displayName);
        token.setLexerGroup(group);
        token.setNewLexerGroup(newGroup);
        return this.add(token);
    }

    public int add(IToken token) {
        int newGroupIndex;
        int groupIndex;
        String category = token.getCategory();
        String type = token.getType();
        String lexerGroup = token.getLexerGroup();
        String newLexerGroup = token.getNewLexerGroup();
        int categoryIndex = this._categories.getIntValue(category);
        if (categoryIndex == -1) {
            String message = MessageFormat.format(Messages.TokenList_Category_Not_Defined, category);
            throw new IllegalArgumentException(message);
        }
        token.setCategoryIndex(categoryIndex);
        int typeIndex = this._types.getIntValue(type);
        if (typeIndex == -1) {
            String message = MessageFormat.format(Messages.TokenList_Type_Not_Defined, type);
            throw new IllegalArgumentException(message);
        }
        token.setTypeIndex(typeIndex);
        if (this._groups.containsKey(lexerGroup)) {
            groupIndex = this._groups.get(lexerGroup);
            token.setLexerGroupIndex(groupIndex);
        } else {
            groupIndex = this._groups.size();
            this.setGroupIndex(lexerGroup, groupIndex);
            token.setLexerGroupIndex(groupIndex);
        }
        if (this._groups.containsKey(newLexerGroup)) {
            newGroupIndex = this._groups.get(newLexerGroup);
            token.setNewLexerGroupIndex(newGroupIndex);
        } else {
            newGroupIndex = this._groups.size();
            this.setGroupIndex(newLexerGroup, newGroupIndex);
            token.setNewLexerGroupIndex(newGroupIndex);
        }
        this.internalAdd(token);
        token.setIndex(this._tokens.size() - 1);
        return token.getIndex();
    }

    public int size() {
        return this._tokens.size();
    }

    public boolean isSealed() {
        return this._isSealed;
    }

    public IToken createToken() {
        return new Token(this);
    }

    public boolean hasGroup(String groupName) {
        Set<String> keys = this._groups.keySet();
        return keys.contains(groupName);
    }
}

