/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.Messages;

public class Range
implements IRange {
    public static final Range Empty = new Range(0, 0);
    private int _startingOffset;
    private int _endingOffset;

    public Range() {
        this.clear();
    }

    public Range(int startingOffset, int endingOffset) {
        this.setRange(startingOffset, endingOffset);
    }

    public void clear() {
        this._startingOffset = Integer.MAX_VALUE;
        this._endingOffset = Integer.MIN_VALUE;
    }

    public boolean containsOffset(int offset) {
        boolean result = false;
        if (!this.isEmpty()) {
            result = this._startingOffset <= offset && offset <= this._endingOffset;
        }
        return result;
    }

    public int getEndingOffset() {
        return this._endingOffset;
    }

    public int getLength() {
        return this._endingOffset - this._startingOffset;
    }

    public int getStartingOffset() {
        return this._startingOffset;
    }

    public void includeInRange(int offset) {
        if (this._startingOffset > offset) {
            this._startingOffset = offset;
        }
        if (this._endingOffset < offset) {
            this._endingOffset = offset;
        }
    }

    public void includeInRange(Lexeme lexeme) {
        if (this.isEmpty()) {
            this._startingOffset = lexeme.offset;
            this._endingOffset = lexeme.getEndingOffset();
        } else {
            this.includeInRange(lexeme.offset);
            this.includeInRange(lexeme.getEndingOffset());
        }
    }

    public boolean isEmpty() {
        return this._startingOffset >= this._endingOffset;
    }

    public void setRange(int startingOffset, int endingOffset) {
        if (startingOffset > endingOffset) {
            throw new IllegalArgumentException(Messages.Range_Swapped_Endpoints);
        }
        this._startingOffset = startingOffset;
        this._endingOffset = endingOffset;
    }

    public void setRange(IRange range) {
        this.setRange(range.getStartingOffset(), range.getEndingOffset());
    }
}

