/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.io;

import com.aptana.ide.io.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public class TabledInputStream
implements DataInput {
    private InputStream _inputStream;
    private DataInputStream _internalStream;
    private String _stringTable;
    private int[] _offsets;
    private int _stringTableIndex;
    private int[] _intTable;
    private int _intTableIndex;

    public TabledInputStream(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.TabledInputStream_Input_Undefined);
        }
        this._inputStream = input;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copyInputStream(input, baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this._internalStream = new DataInputStream(bais);
        byte major = this._internalStream.readByte();
        byte minor = this._internalStream.readByte();
        if (major != 1 || minor != 0) {
            Object[] messageArgs = new Object[]{};
            String message = MessageFormat.format(Messages.TabledInputStream_Incompatible_Format, messageArgs);
            throw new IllegalArgumentException(message);
        }
        int offsetCount = this._internalStream.readInt();
        this._offsets = new int[offsetCount];
        int i = 0;
        while (i < offsetCount) {
            int value;
            this._offsets[i] = value = this._internalStream.readInt();
            ++i;
        }
        int tableByteCount = this._internalStream.readInt();
        byte[] stringData = new byte[tableByteCount];
        this._internalStream.read(stringData);
        this._stringTable = new String(stringData, "utf-8");
        int intCount = this._internalStream.readInt();
        this._intTable = new int[intCount];
        int i2 = 0;
        while (i2 < intCount) {
            this._intTable[i2] = this._internalStream.readInt();
            ++i2;
        }
        this._stringTableIndex = 0;
        this._intTableIndex = 0;
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[0x100000];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    public void close() throws IOException {
        this._internalStream.close();
        this._inputStream.close();
    }

    public byte readByte() throws IOException {
        return this._internalStream.readByte();
    }

    public char readChar() throws IOException {
        return this._internalStream.readChar();
    }

    public double readDouble() throws IOException {
        return this._internalStream.readDouble();
    }

    public float readFloat() throws IOException {
        return this._internalStream.readFloat();
    }

    public int readInt() throws IOException {
        int result = 0;
        if (this._intTableIndex < this._intTable.length) {
            result = this._intTable[this._intTableIndex];
            ++this._intTableIndex;
        }
        return result;
    }

    public int readUnsignedByte() throws IOException {
        return this._internalStream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this._internalStream.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this._internalStream.readLong();
    }

    public short readShort() throws IOException {
        return this._internalStream.readShort();
    }

    public boolean readBoolean() throws IOException {
        return this._internalStream.readBoolean();
    }

    public int skipBytes(int n) throws IOException {
        return this._internalStream.skipBytes(n);
    }

    public void readFully(byte[] b) throws IOException {
        this._internalStream.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._internalStream.readFully(b, off, len);
    }

    public String readLine() throws IOException {
        return "";
    }

    public String readUTF() throws IOException {
        int length = this._offsets.length;
        String result = null;
        if (this._stringTableIndex < length) {
            int start = this._offsets[this._stringTableIndex];
            ++this._stringTableIndex;
            int end = this._stringTableIndex < length ? this._offsets[this._stringTableIndex] : this._stringTable.length();
            result = this._stringTable.substring(start, end);
        }
        return result;
    }
}

