/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.io;

import com.aptana.ide.io.Messages;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FileUtilities {
    private static char[] _buffer;

    static {
        FileUtilities.makeBuffer(16384);
    }

    private FileUtilities() {
    }

    private static void makeBuffer(int size) {
        _buffer = new char[size];
    }

    public static String readString(DataInputStream input) throws IOException {
        int length = input.readInt();
        if (length > _buffer.length) {
            FileUtilities.makeBuffer(length);
        }
        int i = 0;
        while (i < length) {
            FileUtilities._buffer[i] = input.readChar();
            ++i;
        }
        return new String(_buffer, 0, length);
    }

    public static void writeString(DataOutputStream output, String text) throws IOException {
        if (text == null) {
            throw new IllegalArgumentException(Messages.FileUtilities_Text_Undefined);
        }
        char[] chars = text.toCharArray();
        int length = chars.length;
        output.writeInt(length);
        int i = 0;
        while (i < length) {
            output.writeChar(chars[i]);
            ++i;
        }
    }
}

