/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.core.ui.wizards.IBaseWizardPage;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preview.PreviewTypeSelectionBlock;
import com.aptana.ide.server.core.IServer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreviewWizardPage
extends WizardPage
implements IBaseWizardPage {
    private Composite displayArea;
    private PreviewTypeSelectionBlock block;
    private Button defineProjectSettings;

    public PreviewWizardPage(String pageName) {
        super(pageName);
    }

    public void performFinish() {
        try {
            IProject project = ((BaseWizard)this.getWizard()).getCreatedProject();
            if (this.defineProjectSettings.getSelection() && project != null) {
                String type = "";
                type = this.block.getServerButton().getSelection() ? (this.block.getServerAppendButton().getSelection() ? "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE" : "com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE") : (this.block.getConfigurationButton().getSelection() ? "com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE" : (this.block.getStartURLButton().getSelection() ? "com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE" : "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE"));
                String value = "";
                if (this.block.getServerButton().getSelection()) {
                    Object obj = this.block.getServerText().getData();
                    value = obj != null && obj instanceof IServer ? ((IServer)obj).getId() : this.block.getServerText().getText();
                } else if (this.block.getConfigurationButton().getSelection()) {
                    value = this.block.getConfigurationText().getText();
                } else if (this.block.getStartURLButton().getSelection()) {
                    value = this.block.getStartURLText().getText().trim();
                }
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE"), type);
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE"), value);
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"), "true");
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.CONTEXT_ROOT"), "/");
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE"), HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE"));
            } else {
                project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"), "false");
            }
        }
        catch (CoreException coreException) {}
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(true);
        }
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.verticalSpacing = 15;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defineProjectSettings = new Button(this.displayArea, 32);
        this.defineProjectSettings.setText("Define custom preview settings for this project");
        this.defineProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewWizardPage.this.block.setEnabled(PreviewWizardPage.this.defineProjectSettings.getSelection());
                PreviewWizardPage.this.block.updateControls();
            }
        });
        this.block = new PreviewTypeSelectionBlock();
        this.block.useSampleURL();
        String type = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE");
        String value = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE");
        this.block.createStartActionSection(this.displayArea, type, value);
        this.block.setCurrentURLLabel("Sample URL:");
        this.block.setEnabled(false);
        this.block.updateControls();
        this.block.updateCurrentURL();
        Link l = new Link(this.displayArea, 32);
        l.setText("You may set your preview preferences for all projects in your <a>workspace preferences</a>.");
        l.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.html.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.html.preferences.PreviewPreferencePage"}, null);
                dialog.open();
            }
        });
        this.setControl((Control)this.displayArea);
    }
}

