/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preview.IPreviewConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class PreviewConfigurations {
    private static final String EXTENSION_POINT_NAME = "previewConfiguration";
    private static final String CONFIGURATION_ELEMENT_NAME = "configuration";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String FILE_EXTENSION_ATTRIBUTE_NAME = "fileExtension";
    private static final String PRIORITY_ATTRIBUTE_NAME = "priority";

    public static IPreviewConfiguration getConfiguration(String fileExtension) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(HTMLPlugin.ID, EXTENSION_POINT_NAME);
        int maxPriority = -1;
        IPreviewConfiguration toReturn = null;
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String currentExtension;
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(CONFIGURATION_ELEMENT_NAME) && (currentExtension = element.getAttribute(FILE_EXTENSION_ATTRIBUTE_NAME)).equals(fileExtension)) {
                        int priority = 0;
                        String priorityString = element.getAttribute(PRIORITY_ATTRIBUTE_NAME);
                        if (priorityString != null) {
                            try {
                                priority = Integer.parseInt(priorityString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)("Wrong priority format in " + elementName + " preview configuration declaration"));
                            }
                        }
                        if (priority > maxPriority) {
                            try {
                                toReturn = (IPreviewConfiguration)element.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
                            }
                            catch (CoreException e) {
                                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)"Unable creating preview configuration", (Throwable)e);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return toReturn;
    }

    private PreviewConfigurations() {
    }
}

