/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preferences;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preferences.Messages;
import com.aptana.ide.ui.editors.preferences.formatter.CompilationUnitPreview;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialogTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class BaseHTMLFormatterPage
extends FormatterTabPage {
    protected String editor;
    protected static String[] FALSE_TRUE = new String[]{"false", "true"};
    protected static final String PREVIEW = "<!DOCTYPE html\r\n    PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\r\n    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\r\n<head>\r\n <title>HTML Formatting Sample</title><style type=\"text/css\">\r\n\r\n@import url(\"/shared.css\");\r\n\r\n#footer {\r\n\tborder:1px solid white;\r\n}\r\n\r\n#banner {\r\n  background-color: #636D84;\r\n  padding-right:40px;\r\n  padding-top:10px;\r\n  height:40px;\r\n}\r\n</style>\r\n <script type=\"text/javascript\" src=\"/trac/chrome/common/js/trac.js\"></script>\r\n</head>\r\n<body>\r\n\r\n<div id=\"navigation\">\r\n   \t\t<div id=\"header\">\r\n\t\t<h1><a title=\"Return to home page\" accesskey=\"1\" href=\"/\">Aptana</a></h1>\r\n\t</div>\r\n\t<div>\r\n\t\t<ul>\r\n\t\t\t<li><a href=\"/dev\">contribute</a></li>\r\n\t\t\t<li><a href=\"/forums\">forums</a></li>\r\n\t\t\t<li><a href=\"/download_all.php\">products</a></li>\r\n\t\t\t<li><a href=\"/support.php\">support</a></li>\r\n\t\t\t<li><a href=\"/about.php\">about</a></li>\r\n\t\t</ul>\r\n\t</div>\r\n</div>\r\n </body>\r\n</html>";
    protected CompilationUnitPreview fPreview;

    public BaseHTMLFormatterPage(ModifyDialogTabPage.IModificationListener modifyListener, Map workingValues) {
        super(modifyListener, workingValues);
    }

    protected Preview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent, this.editor, null);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    protected void update() {
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected class NewLineController {
        private Group nodeGroup;
        private Composite buttons;
        private Table foldingTable;
        private Button add;
        private Button remove;
        private String title;
        private String key;

        public NewLineController(String title, String key) {
            this.title = title;
            this.key = key;
        }

        protected void doCreatePartControl(Composite composite) {
            this.nodeGroup = new Group(composite, 0);
            GridLayout groupLayout = new GridLayout(1, true);
            this.nodeGroup.setLayout((Layout)groupLayout);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 3;
            this.nodeGroup.setLayoutData((Object)gridData);
            this.nodeGroup.setText(this.title);
            this.buttons = new Composite((Composite)this.nodeGroup, 0);
            GridLayout buttonsLayout = new GridLayout(2, true);
            buttonsLayout.marginHeight = 0;
            buttonsLayout.marginWidth = 0;
            this.buttons.setLayout((Layout)buttonsLayout);
            this.add = new Button(this.buttons, 8);
            this.add.setImage(HTMLPlugin.getImage("icons/add_obj.gif"));
            this.add.setToolTipText(Messages.NewLinesTabPage_ADD_TOOLTIP);
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog dialog = new InputDialog(NewLineController.this.nodeGroup.getShell(), Messages.NewLinesTabPage_ADD_TITLE, Messages.NewLinesTabPage_ADD_DESCRIPTION, null, null);
                    int rc = dialog.open();
                    if (rc == 0) {
                        String newNodes = dialog.getValue();
                        String[] nodes = newNodes.split(",");
                        ArrayList<String> nodeList = new ArrayList<String>();
                        int i = 0;
                        while (i < nodes.length) {
                            String trimmed = nodes[i].trim();
                            if (trimmed.length() > 0) {
                                nodeList.add(trimmed);
                            }
                            ++i;
                        }
                        TableItem[] items = NewLineController.this.foldingTable.getItems();
                        int i2 = 0;
                        while (items != null && i2 < items.length) {
                            if (!nodeList.contains(items[i2].getText())) {
                                nodeList.add(items[i2].getText());
                            }
                            ++i2;
                        }
                        Collections.sort(nodeList);
                        NewLineController.this.foldingTable.removeAll();
                        i2 = 0;
                        while (i2 < nodeList.size()) {
                            TableItem item = new TableItem(NewLineController.this.foldingTable, 16384);
                            item.setText((String)nodeList.get(i2));
                            item.setImage(HTMLPlugin.getImage("icons/element_icon.gif"));
                            ++i2;
                        }
                        BaseHTMLFormatterPage.this.update();
                    }
                }
            });
            this.remove = new Button(this.buttons, 8);
            this.remove.setImage(HTMLPlugin.getImage("icons/delete_obj.gif"));
            this.remove.setToolTipText(Messages.NewLinesTabPage_REMOVE_TOOLTIP);
            this.remove.setEnabled(false);
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] items = NewLineController.this.foldingTable.getSelection();
                    int[] indices = NewLineController.this.foldingTable.getSelectionIndices();
                    if (items != null) {
                        int i = 0;
                        while (i < items.length) {
                            items[i].dispose();
                            ++i;
                        }
                        if (indices.length > 1) {
                            int last = indices[indices.length - 1];
                            if (NewLineController.this.foldingTable.getItemCount() - 1 >= last) {
                                NewLineController.this.foldingTable.setSelection(last);
                            } else if (NewLineController.this.foldingTable.getItemCount() > 0) {
                                NewLineController.this.foldingTable.setSelection(NewLineController.this.foldingTable.getItemCount() - 1);
                            }
                        } else if (indices.length == 1) {
                            if (NewLineController.this.foldingTable.getItemCount() - 1 >= indices[0]) {
                                NewLineController.this.foldingTable.setSelection(indices[0]);
                            } else if (NewLineController.this.foldingTable.getItemCount() > 0) {
                                NewLineController.this.foldingTable.setSelection(NewLineController.this.foldingTable.getItemCount() - 1);
                            }
                        }
                    }
                    BaseHTMLFormatterPage.this.update();
                    NewLineController.this.remove.setEnabled(NewLineController.this.foldingTable.getSelectionCount() > 0);
                }
            });
            this.buttons.setLayoutData((Object)new GridData(4, 4, true, false));
            this.foldingTable = new Table((Composite)this.nodeGroup, 2818);
            this.foldingTable.setLayoutData((Object)gridData);
            this.foldingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewLineController.this.remove.setEnabled(true);
                }
            });
            String foldedNodeList = (String)((ModifyDialogTabPage)BaseHTMLFormatterPage.this).fWorkingValues.get(this.key);
            if (foldedNodeList == null) {
                return;
            }
            String[] nodes = foldedNodeList.split(",");
            int i = 0;
            while (i < nodes.length) {
                String trim = nodes[i].trim();
                if (trim.length() > 0) {
                    TableItem item = new TableItem(this.foldingTable, 16384);
                    item.setText(trim);
                    item.setImage(HTMLPlugin.getImage("icons/element_icon.gif"));
                }
                ++i;
            }
        }

        protected String createString() {
            String nodeListPref = "";
            int i = 0;
            while (i < this.foldingTable.getItemCount()) {
                TableItem item = this.foldingTable.getItem(i);
                nodeListPref = String.valueOf(nodeListPref) + item.getText() + Messages.NewLinesTabPage_9;
                ++i;
            }
            return nodeListPref;
        }
    }
}

