/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing;

import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNodeFactory;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParseStateChild;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLParseState
extends ParseStateChild {
    private static final String HTML_2_0 = "-//IETF//DTD HTML//EN";
    private static final String HTML_3_2 = "-//W3C//DTD HTML 3.2 Final//EN";
    private static final String HTML_4_0_1_STRICT = "-//W3C//DTD HTML 4.01//EN";
    private static final String HTML_4_0_1_TRANSITIONAL = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String HTML_4_0_1_FRAMESET = "-//W3C//DTD HTML 4.01 Frameset//EN";
    private static final String XHTML_1_0_STRICT = "-//W3C//DTD XHTML 1.0 Strict//EN";
    private static final String XHTML_1_0_TRANSITIONAL = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private static final String XHTML_1_0_FRAMESET = "-//W3C//DTD XHTML 1.0 Frameset//EN";
    private static final String XHTML_1_1_STRICT = "-//W3C//DTD XHTML 1.1//EN";
    private static Pattern _docTypeSniffer = Pattern.compile("<!DOCTYPE\\s+(\\S+)\\s+PUBLIC\\s+((?:'[^']+')|(?:\"[^\"]+\"))(?:\\s+((?:'[^']+')|(?:\"[^\"]+\")))?");
    private static HashMap _docTypeIndex = new HashMap();
    private static HashMap _endTagInfo;
    private String _rootElement;
    private String _pubId;
    private String _system;
    private int _documentType;

    static {
        _docTypeIndex.put(HTML_2_0, new Integer(1));
        _docTypeIndex.put(HTML_3_2, new Integer(2));
        _docTypeIndex.put(HTML_4_0_1_STRICT, new Integer(3));
        _docTypeIndex.put(HTML_4_0_1_TRANSITIONAL, new Integer(4));
        _docTypeIndex.put(HTML_4_0_1_FRAMESET, new Integer(5));
        _docTypeIndex.put(XHTML_1_0_STRICT, new Integer(6));
        _docTypeIndex.put(XHTML_1_0_TRANSITIONAL, new Integer(7));
        _docTypeIndex.put(XHTML_1_0_FRAMESET, new Integer(8));
        _docTypeIndex.put(XHTML_1_1_STRICT, new Integer(9));
        _endTagInfo = new HashMap();
        _endTagInfo.put("area", new Integer(12));
        _endTagInfo.put("base", new Integer(12));
        _endTagInfo.put("basefont", new Integer(12));
        _endTagInfo.put("body", new Integer(2));
        _endTagInfo.put("br", new Integer(12));
        _endTagInfo.put("col", new Integer(12));
        _endTagInfo.put("colgroup", new Integer(2));
        _endTagInfo.put("dd", new Integer(2));
        _endTagInfo.put("dt", new Integer(2));
        _endTagInfo.put("frame", new Integer(12));
        _endTagInfo.put("area", new Integer(2));
        _endTagInfo.put("hr", new Integer(12));
        _endTagInfo.put("html", new Integer(2));
        _endTagInfo.put("img", new Integer(12));
        _endTagInfo.put("input", new Integer(12));
        _endTagInfo.put("isindex", new Integer(12));
        _endTagInfo.put("li", new Integer(2));
        _endTagInfo.put("link", new Integer(12));
        _endTagInfo.put("meta", new Integer(12));
        _endTagInfo.put("option", new Integer(2));
        _endTagInfo.put("p", new Integer(2));
        _endTagInfo.put("param", new Integer(12));
        _endTagInfo.put("tbody", new Integer(2));
        _endTagInfo.put("td", new Integer(2));
        _endTagInfo.put("tfoot", new Integer(2));
        _endTagInfo.put("th", new Integer(2));
        _endTagInfo.put("thead", new Integer(2));
        _endTagInfo.put("tr", new Integer(2));
    }

    public int getDocumentType() {
        return this._documentType;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public String getPubId() {
        return this._pubId;
    }

    public String getSystem() {
        return this._system;
    }

    public HTMLParseState() {
        super("text/html");
    }

    public HTMLParseState(IParseState parent) {
        super("text/html", parent);
    }

    protected IParseNodeFactory createParseNodeFactory() {
        return new HTMLParseNodeFactory((IParseState)this);
    }

    public int getCloseTagType(String tagName) {
        String key;
        int result = 1;
        if (this._documentType < 6 && _endTagInfo.containsKey(key = tagName.toLowerCase())) {
            result = (Integer)_endTagInfo.get(key);
            result &= 7;
        }
        return result;
    }

    public boolean isEmptyTagType(String tagName) {
        boolean result = false;
        String key = tagName.toLowerCase();
        if (_endTagInfo.containsKey(key)) {
            int flags = (Integer)_endTagInfo.get(key);
            result = (flags & 8) == 8;
        }
        return result;
    }

    public void setEditState(String source, String insertedSource, int offset, int removeLength) {
        Matcher match;
        super.setEditState(source, insertedSource, offset, removeLength);
        int documentType = 0;
        int indexOf = source.indexOf("<!DOCTYPE");
        if (indexOf != -1 && (match = _docTypeSniffer.matcher(source.substring(indexOf))).find()) {
            this._rootElement = match.group(1);
            this._pubId = match.group(2);
            this._system = match.group(3);
            this._pubId = this._pubId.substring(1, this._pubId.length() - 1);
            if (this._system != null && this._system.length() > 0) {
                this._system = this._system.substring(1, this._system.length() - 1);
            }
            if ((this._rootElement.equals("html") || this._rootElement.equals("HTML")) && _docTypeIndex.containsKey(this._pubId)) {
                documentType = (Integer)_docTypeIndex.get(this._pubId);
            }
        }
        this._documentType = documentType;
    }
}

