/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLEditor;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.HTMLSourceEditor;
import com.aptana.ide.editor.html.IHTMLEditorPart;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.preview.HTMLPreviewHelper;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.ServerFileTypeHandlers;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IElementStateListener;

public class SplitPageHTMLEditor
extends EditorPart
implements IHTMLEditorPart {
    private HTMLSourceEditor editor;
    private HTMLEditor wrapper;
    private boolean isHorizontal;
    private SplitEditorSite site;
    private IEditorInput _editorInput;
    private IPropertyListener _propertyListener;
    private boolean isDisposing = false;
    private SashForm sash;
    private SashForm browserSash;
    private String browserWeightPreference;
    private String editorToBrowserWeightPreference;
    private IElementStateListener elementListener = new IElementStateListener(){

        public void elementMoved(Object originalElement, Object movedElement) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementDeleted(Object element) {
            if (element.equals(SplitPageHTMLEditor.this.getEditorInput())) {
                IWorkbenchPartSite site = SplitPageHTMLEditor.this.getSite();
                if (site == null) {
                    return;
                }
                IWorkbenchWindow window = site.getWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                page.closeEditor((IEditorPart)SplitPageHTMLEditor.this, true);
            }
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            IEditorInput newInput;
            if (propId == 258 && source instanceof HTMLSourceEditor && (newInput = ((HTMLSourceEditor)((Object)source)).getEditorInput()) != null) {
                SplitPageHTMLEditor.this.setInput(newInput);
                SplitPageHTMLEditor.this.setPartName(newInput.getName());
                SplitPageHTMLEditor.this.setTitleToolTip(newInput.getToolTipText());
            }
        }
    };
    private List<ContributedBrowser> browsers;

    public SplitPageHTMLEditor(HTMLEditor wrapper, boolean isHorizontal, HTMLSourceEditor editor) {
        if (wrapper == null) {
            throw new IllegalArgumentException(Messages.SplitPageHTMLEditor_WrapperCannotBeNull);
        }
        if (editor == null) {
            throw new IllegalArgumentException(Messages.SplitPageHTMLEditor_EditorCannotBeNull);
        }
        this.browsers = new ArrayList<ContributedBrowser>();
        this.wrapper = wrapper;
        this.editor = editor;
        this.isHorizontal = isHorizontal;
    }

    public Browser getBrowser2() {
        return null;
    }

    public HTMLSourceEditor getSourceEditor() {
        return this.editor;
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.doSave(monitor);
        this.setInput(this.editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
        this.wrapper.updatePreview();
        this.saveWeightPreferences();
    }

    public void doSaveAs() {
        this.editor.doSaveAs();
        this.setInput(this.editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
        this.wrapper.updatePreview();
        this.saveWeightPreferences();
    }

    private void saveWeightPreferences() {
        int[] weights;
        if (this.browsers.size() == 2 && this.browserSash != null && this.browserWeightPreference != null && (weights = this.browserSash.getWeights()) != null && weights.length == 2) {
            String browserWeight = String.valueOf(weights[0]) + "," + weights[1];
            HTMLPlugin.getDefault().getPreferenceStore().setValue(this.browserWeightPreference, browserWeight);
        }
        if (this.sash != null && this.editorToBrowserWeightPreference != null && (weights = this.sash.getWeights()) != null & weights.length == 2) {
            String editorToBrowserWeight = String.valueOf(weights[0]) + "," + weights[1];
            HTMLPlugin.getDefault().getPreferenceStore().setValue(this.editorToBrowserWeightPreference, editorToBrowserWeight);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this._editorInput = editorInput;
        this.setInput(editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isDirty() {
        if (this.editor != null) {
            return this.editor.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this._propertyListener != null) {
            this.editor.removePropertyListener(this._propertyListener);
            this._propertyListener = null;
        }
        if (this.browsers != null && this.browsers.size() != 0) {
            this.disposeBrowsers();
            this.browsers = null;
        }
        if (this.wrapper != null) {
            this.wrapper.dispose();
            this.wrapper = null;
        }
        if (this.site != null) {
            this.site.dispose();
            this.site = null;
        }
        if (this._editorInput != null) {
            this._editorInput = null;
        }
        if (this.editor != null) {
            if (this.editor.getDocumentProvider() != null) {
                this.editor.getDocumentProvider().removeElementStateListener(this.elementListener);
            }
            this.editor.removePropertyListener(this.propertyListener);
            this.editor.dispose();
            this.editor = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        try {
            this.sash = null;
            if (this.isHorizontal) {
                this.sash = new SashForm(parent, 512);
                this.editorToBrowserWeightPreference = "com.aptana.ide.editor.html.EDITOR_BROWSER_WEIGHT_HORIZONTAL";
            } else {
                this.sash = new SashForm(parent, 256);
                this.editorToBrowserWeightPreference = "com.aptana.ide.editor.html.EDITOR_BROWSER_WEIGHT_VERTICAL";
            }
            this.site = new SplitEditorSite(this.editor, this.getEditorSite());
            this.editor.init(this.site, this.getEditorInput());
            this._propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    SplitPageHTMLEditor.this.firePropertyChange(propertyId);
                }
            };
            this.editor.addPropertyListener(this._propertyListener);
            this.editor.createPartControl((Composite)this.sash);
            this.editor.addPropertyListener(this.propertyListener);
            this.editor.getDocumentProvider().addElementStateListener(this.elementListener);
            this.loadBrowsers((Composite)this.sash);
            String editorWeight = HTMLPlugin.getDefault().getPreferenceStore().getString(this.editorToBrowserWeightPreference);
            if (editorWeight != null && !editorWeight.equals("") && this.browsers.size() > 0) {
                try {
                    String[] weights = editorWeight.split(",");
                    if (weights != null && weights.length == 2) {
                        int[] intWeights = new int[weights.length];
                        intWeights[0] = Integer.parseInt(weights[0]);
                        intWeights[1] = Integer.parseInt(weights[1]);
                        this.sash.setWeights(intWeights);
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
            this.wrapper.updatePreview();
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void gotoMarker(IMarker marker) {
        IDE.gotoMarker((IEditorPart)this.editor, (IMarker)marker);
    }

    public void setOffset(int offset) {
        this.editor.selectAndReveal(offset, 0);
    }

    public boolean isFileEditorInput() {
        return this.editor.isFileEditorInput();
    }

    public Object getAdapter(Class adapter) {
        if (this.editor != null) {
            return this.editor.getAdapter(adapter);
        }
        IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.SplitPageHTMLEditor_EditorIsNull, (String)adapter.toString()));
        return null;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.wrapper.firePropertyChange2(propertyId);
    }

    public void setBrowserURL(String url) {
        String browserURL = null;
        String value = null;
        String type = null;
        IEditorInput input = this.editor.getEditorInput();
        boolean isProjectFile = false;
        if (input instanceof IFileEditorInput) {
            isProjectFile = true;
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                String override = file.getProject().getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"));
                if ("true".equals(override)) {
                    type = file.getProject().getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE"));
                    value = file.getProject().getPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE"));
                }
            }
            catch (CoreException coreException) {
                type = null;
                value = null;
            }
        }
        if (type == null || value == null) {
            type = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE");
            value = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE");
        }
        ServerFileTypeHandlers.PreviewInfo previewInfo = ServerFileTypeHandlers.getPreviewInfoFromURL((String)url);
        String alternativeValue = null;
        String serverTypeRestriction = null;
        if (previewInfo != null) {
            alternativeValue = previewInfo.serverID;
            serverTypeRestriction = previewInfo.serverTypeID;
        }
        if ("com.aptana.ide.editor.html.preview.FILE_BASED_TYPE".equals(type)) {
            browserURL = url;
        } else if ("com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE".equals(type) || "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type)) {
            if (isProjectFile) {
                IServer curr;
                int i;
                IServer[] servers = ServerCore.getServerManager().getServers();
                browserURL = null;
                if (alternativeValue != null && alternativeValue.length() != 0) {
                    i = 0;
                    while (i < servers.length) {
                        curr = servers[i];
                        if (curr.getId().equals(alternativeValue) && curr.getServerType().getId().equals(serverTypeRestriction)) {
                            browserURL = HTMLPreviewHelper.getServerURL(curr, input, "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type), previewInfo.pathHeader);
                            break;
                        }
                        ++i;
                    }
                }
                if (browserURL == null) {
                    i = 0;
                    while (i < servers.length) {
                        curr = servers[i];
                        if (curr.getId().equals(value)) {
                            browserURL = alternativeValue != null && alternativeValue.length() == 0 & curr.getServerType().getId().equals(serverTypeRestriction) ? HTMLPreviewHelper.getServerURL(curr, input, "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type), previewInfo.pathHeader) : HTMLPreviewHelper.getServerURL(curr, input, "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE".equals(type));
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else if ("com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE".equals(type)) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
            try {
                ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(launchType);
                int i = 0;
                while (i < configs.length) {
                    ILaunchConfiguration current = configs[i];
                    if (current.getName().equals(value)) {
                        browserURL = HTMLPreviewHelper.getConfigURL(current, input);
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (browserURL == null) {
            browserURL = url;
        }
        int i = 0;
        while (i < this.browsers.size()) {
            this.browsers.get(i).setURL(browserURL);
            ++i;
        }
    }

    private void loadBrowsers(Composite sash) {
        List<IConfigurationElement> browserList = BrowserExtensionLoader.loadBrowsers();
        if (browserList.size() > 0) {
            this.browserSash = null;
            if (this.isHorizontal) {
                this.browserSash = new SashForm(sash, 512);
                this.browserWeightPreference = "com.aptana.ide.editor.html.TWO_BROWSER_WEIGHT_HORIZONTAL";
            } else {
                this.browserSash = new SashForm(sash, 256);
                this.browserWeightPreference = "com.aptana.ide.editor.html.TWO_BROWSER_WEIGHT_VERTICAL";
            }
            int j = 0;
            while (j < browserList.size()) {
                IConfigurationElement element = browserList.get(j);
                String name = BrowserExtensionLoader.getBrowserLabel(element);
                String outlineClass = element.getAttribute("outline");
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof ContributedBrowser) {
                        Object ol;
                        Composite comp = new Composite((Composite)this.browserSash, 0);
                        GridLayout layout = new GridLayout();
                        layout.numColumns = 1;
                        layout.makeColumnsEqualWidth = false;
                        layout.marginHeight = 0;
                        layout.marginWidth = 0;
                        layout.verticalSpacing = 0;
                        comp.setLayout((Layout)layout);
                        comp.setLayoutData((Object)new GridData(4, 4, true, true));
                        Label label = new Label(comp, 64);
                        label.setLayoutData((Object)new GridData(4, 4, true, false));
                        label.setText(StringUtils.format((String)Messages.SplitPageHTMLEditor_Preview, (String)name));
                        ContributedBrowser browser = (ContributedBrowser)obj;
                        browser.createControl(comp);
                        this.browsers.add(browser);
                        if (outlineClass != null && (ol = element.createExecutableExtension("outline")) instanceof ContributedOutline) {
                            ContributedOutline outline = (ContributedOutline)ol;
                            browser.setOutline(outline);
                            outline.setBrowser(browser);
                            this.editor.getOutlinePage().addOutline(outline, name);
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.SplitPageHTMLEditor_UnableToCreateBrowserControl, (String)name), (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.SplitPageHTMLEditor_UnableToCreateBrowserControl, (String)name), (Throwable)e);
                }
                ++j;
            }
            String weights = HTMLPlugin.getDefault().getPreferenceStore().getString(this.browserWeightPreference);
            if (this.browsers.size() == 2 && weights != null && !weights.equals("")) {
                try {
                    String[] orderedWeights = weights.split(",");
                    if (orderedWeights != null && orderedWeights.length == 2) {
                        int[] intWeights = new int[orderedWeights.length];
                        intWeights[0] = Integer.parseInt(orderedWeights[0]);
                        intWeights[1] = Integer.parseInt(orderedWeights[1]);
                        this.browserSash.setWeights(intWeights);
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
    }

    private void disposeBrowsers() {
        int i = 0;
        while (i < this.browsers.size()) {
            this.browsers.get(i).dispose();
            ++i;
        }
    }

    private static class SplitEditorSite
    implements IEditorSite {
        private HTMLSourceEditor editor;
        private IEditorSite site;
        private ArrayList menuExtenders;

        public SplitEditorSite(HTMLSourceEditor editor, IEditorSite site) {
            this.editor = editor;
            this.site = site;
        }

        public IEditorActionBarContributor getActionBarContributor() {
            return this.site.getActionBarContributor();
        }

        public IActionBars getActionBars() {
            return this.site.getActionBars();
        }

        public String getId() {
            return this.site.getId();
        }

        public IKeyBindingService getKeyBindingService() {
            return this.site.getKeyBindingService();
        }

        public String getPluginId() {
            return this.site.getPluginId();
        }

        public String getRegisteredName() {
            return this.site.getRegisteredName();
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
            this.site.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            if (this.menuExtenders == null) {
                this.menuExtenders = new ArrayList(1);
            }
            this.menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, (IWorkbenchPart)this.editor));
        }

        public IWorkbenchPage getPage() {
            return this.site.getPage();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.site.getSelectionProvider();
        }

        public Shell getShell() {
            return this.site.getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return this.site.getWorkbenchWindow();
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            this.site.setSelectionProvider(provider);
        }

        public Object getAdapter(Class adapter) {
            return this.site.getAdapter(adapter);
        }

        public void dispose() {
            if (this.menuExtenders != null) {
                int i = 0;
                while (i < this.menuExtenders.size()) {
                    ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
                    ++i;
                }
                this.menuExtenders = null;
            }
        }

        public IWorkbenchPart getPart() {
            return this.editor;
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.registerContextMenu(menuManager, selectionProvider);
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            this.registerContextMenu(menuId, menuManager, selectionProvider);
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }
}

