/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.editors.unified.ChildOffsetMapper;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.Token;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.ICodeLocation;

public class HTMLOffsetMapper
extends ChildOffsetMapper {
    public HTMLOffsetMapper(IParentOffsetMapper parent) {
        super(parent);
    }

    public String getNameHash() {
        String name = "";
        int position = this.getCurrentLexemeIndex();
        while (position >= 0) {
            Lexeme curLexeme = this.getLexemeList().get(position);
            if (curLexeme.getText().equals(">")) {
                return "";
            }
            if (curLexeme.typeIndex == 0 && curLexeme.getText().equals("<")) {
                return "";
            }
            if (curLexeme.typeIndex == 41) {
                return curLexeme.getText().replaceAll("<", "");
            }
            --position;
        }
        return name;
    }

    public ICodeLocation findTarget(Lexeme lexeme) {
        if (lexeme.getToken().getLexerGroup().equals("attribute")) {
            LexemeList lexemeList = this.getFileService().getLexemeList();
            int index = this.getLexemeIndexFromDocumentOffset(lexeme.getStartingOffset() + 1);
            if (index < 2) {
                return null;
            }
            Lexeme srcLexeme = lexemeList.get(index - 2);
            if (srcLexeme.getText().equals("src")) {
                String name = lexeme.getText();
                if (name.startsWith("\"") || name.startsWith("'")) {
                    name = name.substring(1);
                }
                if (name.endsWith("\"") || name.endsWith("'")) {
                    name = name.substring(0, name.length() - 1);
                }
                Lexeme destLexeme = new Lexeme((IToken)new Token(null), "", 0);
                String pathToCurrent = this.getFileService().getSourceProvider().getSourceURI();
                String parentPath = pathToCurrent.substring(0, pathToCurrent.lastIndexOf(47));
                return new CodeLocation(String.valueOf(parentPath) + '/' + name, destLexeme);
            }
        }
        return null;
    }
}

