/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.unified.AbstractLanguageEnvironment;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.MetadataRuntimeEnvironment;
import com.aptana.ide.metadata.reader.MetadataObjectsReader;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;

public class HTMLLanguageEnvironment
extends AbstractLanguageEnvironment {
    public static int SLEEP_DELAY = 6000;
    private static HTMLLanguageEnvironment instance;
    private MetadataRuntimeEnvironment environment = new MetadataRuntimeEnvironment();

    HTMLLanguageEnvironment() {
        EnvironmentManager.addEnvironmentMapping((String)"text/html", (IRuntimeEnvironment)this.environment);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(SLEEP_DELAY);
                    HTMLLanguageEnvironment.this.loadEnvironment();
                }
                catch (Exception e1) {
                    IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLLanguageEnvironment_EnvironmentInitializationAborted, (Throwable)e1);
                }
            }
        }, Messages.HTMLLanguageEnvironment_HTMLLanguageThreadName);
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public static HTMLLanguageEnvironment getInstance() {
        if (instance == null) {
            instance = new HTMLLanguageEnvironment();
        }
        return instance;
    }

    public IRuntimeEnvironment getRuntimeEnvironment() {
        return this.environment;
    }

    public void loadEnvironment() {
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/com/aptana/ide/editor/html/parsing/HTMLMetadata.bin");
        MetadataEnvironment env = new MetadataEnvironment();
        env = MetadataEnvironment.getMetadataFromResource((InputStream)input, (MetadataEnvironment)env);
        this.environment.addEnvironment(env);
        Hashtable xmlFiles = new Hashtable();
        this.addFromExtension(xmlFiles, "xml-file", "text/html");
        Enumeration keys = xmlFiles.keys();
        while (keys.hasMoreElements()) {
            env = new MetadataEnvironment();
            MetadataObjectsReader reader = new MetadataObjectsReader(env);
            URL key = (URL)keys.nextElement();
            String userAgent = (String)xmlFiles.get(key);
            try {
                reader.loadXML(key.openStream());
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLLanguageEnvironment_ErrorLoadingEnvironment, (Throwable)e);
            }
            this.environment.addEnvironment(env);
        }
    }

    public void cleanEnvironment() {
    }

    public void setProfileMemberOnAll(boolean value) {
    }

    public void attachFile(FileService fileService) {
    }

    public void removeFile(FileService fileService) {
    }
}

