/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.HTMLEnvironmentLoader;
import com.aptana.ide.editor.html.HTMLLanguageEnvironment;
import com.aptana.ide.editor.html.HTMLOffsetMapper;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.help.HelpResource;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import java.util.ArrayList;
import java.util.Iterator;

public class HTMLFileLanguageService
extends BaseFileLanguageService {
    private HTMLOffsetMapper offsetMapper;
    private IMetadataEnvironment environment;
    HTMLEnvironmentLoader loader;
    private boolean isProfileMember;
    private IFileContextListener _delayedFileListener;
    private static boolean isFirstConnection = true;

    public HTMLFileLanguageService(FileService fileService, IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        super(fileService, parseState, parser, mapper);
        this.createOffsetMapper(mapper);
        this.environment = (IMetadataEnvironment)HTMLLanguageEnvironment.getInstance().getRuntimeEnvironment();
        this.loader = new HTMLEnvironmentLoader((IRuntimeEnvironment)this.environment);
        final IParseState finalParseState = parseState;
        this._delayedFileListener = new IFileContextListener(){

            public void onContentChanged(FileContextContentEvent evt) {
                IFileService context = HTMLFileLanguageService.this.getFileContext();
                if (context == null) {
                    throw new IllegalStateException(Messages.HTMLFileLanguageService_IFileContextShouldNotBeNull);
                }
                HTMLFileLanguageService.this.loader.reloadEnvironment(finalParseState, context.getLexemeList(), finalParseState.getFileIndex());
            }
        };
        this.fileService.addDelayedFileListener(this._delayedFileListener);
    }

    public String getDocumentationTitleFromLexeme(Lexeme lexeme) {
        String title = "HTML Editor";
        if (lexeme == null) {
            return "HTML Editor";
        }
        String titleLower = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 41) {
            title = "'" + titleLower + ">' tag";
        } else if (lexeme.typeIndex == 27) {
            title = titleLower.replaceAll("</", "");
            title = "'<" + title + ">' tag";
        } else if (lexeme.typeIndex == 43) {
            FieldMetadata el = (FieldMetadata)this.environment.getGlobalFields().get(titleLower);
            if (el != null) {
                title = "'" + titleLower + "' attribute";
            } else {
                EventMetadata fm = (EventMetadata)this.environment.getGlobalEvents().get(titleLower);
                if (fm != null) {
                    title = "'" + titleLower + "' event";
                }
            }
        }
        return title;
    }

    public HelpResource[] getDocumentationResourcesFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return new HelpResource[0];
        }
        ArrayList topics = new ArrayList();
        ArrayList<HelpResource> generalTopics = new ArrayList<HelpResource>();
        String lowerName = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 41) {
            this.addStartTagHelpTopics(topics, generalTopics, lowerName);
        } else if (lexeme.typeIndex == 27) {
            this.addEndTagHelpTopics(topics, generalTopics, lowerName);
        } else if (lexeme.typeIndex == 43) {
            this.addAttributeHelpTopics(topics, generalTopics, lowerName);
            this.addEventHelpTopics(topics, generalTopics, lowerName);
            IFileService context = this.getFileContext();
            Lexeme openTag = HTMLUtils.getTagOpenLexeme(lexeme.offset, context.getLexemeList());
            if (openTag != null) {
                String lowerTagName = openTag.getText().toLowerCase();
                this.addStartTagHelpTopics(topics, generalTopics, lowerTagName);
            }
        }
        if (generalTopics.size() == 0) {
            HelpResource index = new HelpResource("HTML Reference", "/com.aptana.ide.documentation/html/reference/api/HTML.index.html");
            generalTopics.add(index);
        }
        Iterator iter = generalTopics.iterator();
        while (iter.hasNext()) {
            topics.add(iter.next());
        }
        return topics.toArray(new HelpResource[0]);
    }

    private void addAttributeHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        FieldMetadata el = (FieldMetadata)this.environment.getGlobalFields().get(lowerName);
        String anchor = "";
        if (el != null) {
            anchor = el.getName();
            String url = "/com.aptana.ide.documentation/html/reference/api/HTML.field." + el.getName() + ".html";
            HelpResource hr = new HelpResource("'" + el.getName() + "' Attribute", url);
            topics.add(hr);
            HelpResource index = new HelpResource("HTML Attribute Reference", "/com.aptana.ide.documentation/html/reference/api/HTML.index-fields.html#" + anchor);
            generalTopics.add(index);
        }
    }

    private void addEventHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        EventMetadata fm = (EventMetadata)this.environment.getGlobalEvents().get(lowerName);
        String anchor = "";
        if (fm != null) {
            anchor = fm.getName();
            String url = "/com.aptana.ide.documentation/html/reference/api/HTML.event." + fm.getName() + ".html";
            HelpResource hr = new HelpResource("'" + fm.getName() + "' Event", url);
            topics.add(hr);
            HelpResource index = new HelpResource("HTML Event Reference", "/com.aptana.ide.documentation/html/reference/api/HTML.index-events.html#" + anchor);
            generalTopics.add(index);
        }
    }

    private void addStartTagHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        lowerName = lowerName.replaceAll("<", "");
        ElementMetadata el = this.environment.getElement(lowerName);
        String anchor = "";
        if (el != null) {
            anchor = el.getFullName();
            String url = "/com.aptana.ide.documentation/html/reference/api/HTML.element." + el.getFullName() + ".html";
            HelpResource hr = new HelpResource("<" + lowerName + "> Element", url);
            topics.add(hr);
        }
        HelpResource index = new HelpResource("HTML Element Reference", "/com.aptana.ide.documentation/html/reference/api/HTML.index-elements.html#" + anchor);
        generalTopics.add(index);
    }

    private void addEndTagHelpTopics(ArrayList topics, ArrayList generalTopics, String lowerName) {
        lowerName = lowerName.replaceAll("</", "");
        ElementMetadata el = this.environment.getElement(lowerName);
        String anchor = "";
        if (el != null) {
            anchor = el.getFullName();
            String url = "/com.aptana.ide.documentation/html/reference/api/HTML.element." + el.getFullName() + ".html";
            HelpResource hr = new HelpResource("<" + lowerName + "> Element", url);
            topics.add(hr);
        }
        HelpResource index = new HelpResource("HTML Element Reference", "/com.aptana.ide.documentation/html/reference/api/HTML.index-elements.html#" + anchor);
        generalTopics.add(index);
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        if (lexeme == null) {
            return "";
        }
        String docs = "";
        String lowerName = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 41) {
            ElementMetadata el = this.environment.getElement(lowerName = lowerName.replaceAll("<", ""));
            docs = el != null ? String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{el.getName(), el.getDescription()}) : String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_NoInformationAvailableHTML, (String)lexeme.getType());
        } else if (lexeme.typeIndex == 27) {
            ElementMetadata el = this.environment.getElement(lowerName = lowerName.replaceAll("</", ""));
            docs = el != null ? String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableEndTagHTML, (Object[])new String[]{el.getName(), el.getDescription()}) : String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_NoInformationAvailableHTML, (String)lexeme.getType());
        } else if (lexeme.typeIndex == 43) {
            FieldMetadata el = (FieldMetadata)this.environment.getGlobalFields().get(lowerName);
            if (el != null) {
                docs = String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{el.getName(), el.getDescription()});
            }
        } else if (lexeme.typeIndex == 44) {
            docs = String.valueOf(docs) + Messages.HTMLFileLanguageService_StringLiteralHTML;
            docs = String.valueOf(docs) + lexeme.getText();
        } else {
            docs = String.valueOf(docs);
        }
        return docs;
    }

    public Lexeme getValidDocumentationLexeme(Lexeme lexeme) {
        return this.findPreviousValidLexeme(lexeme);
    }

    private Lexeme findPreviousValidLexeme(Lexeme lexeme) {
        if (this.isLexemeOfInterest(lexeme)) {
            return lexeme;
        }
        LexemeList ll = this.getFileContext().getLexemeList();
        if (ll == null) {
            return null;
        }
        Lexeme newLexeme = null;
        int index = ll.getLexemeIndex(lexeme);
        while (index > 0) {
            Lexeme l = ll.get(index);
            if (l == null) {
                return null;
            }
            if (this.isLexemeOfInterest(l)) {
                newLexeme = l;
                break;
            }
            --index;
        }
        return newLexeme;
    }

    private boolean isLexemeOfInterest(Lexeme lexeme) {
        return lexeme.typeIndex == 43 || lexeme.getCategoryIndex() == 3 || lexeme.typeIndex == 41 || lexeme.typeIndex == 27;
    }

    public String getDefaultLanguage() {
        return "text/html";
    }

    public IOffsetMapper getOffsetMapper() {
        return this.offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this.offsetMapper = new HTMLOffsetMapper(parent);
    }

    public static HTMLFileLanguageService getHTMLFileLanguageService(IFileService fileContext) {
        HTMLFileLanguageService languageService = (HTMLFileLanguageService)fileContext.getLanguageService("text/html");
        if (languageService == null) {
            throw new IllegalStateException(Messages.HTMLFileLanguageService_NoHTMLLanguageServiceAvailable);
        }
        return languageService;
    }

    public void connectSourceProvider(IFileSourceProvider sourceProvider) {
        if (isFirstConnection) {
            isFirstConnection = false;
        }
    }

    public void disconnectSourceProvider(IFileSourceProvider sourceProvider) {
        if (this._delayedFileListener != null) {
            this.fileService.addDelayedFileListener(this._delayedFileListener);
            this._delayedFileListener = null;
        }
        this.loader.unloadEnvironment(this.getParseState().getFileIndex());
        this.offsetMapper.dispose();
        this.offsetMapper = null;
        this.loader = null;
        this.environment = null;
    }

    public boolean isProfileMember() {
        return this.isProfileMember;
    }

    public void setProfileMember(boolean isProfileMember) {
        this.isProfileMember = isProfileMember;
    }

    public void reset(boolean resetFileIndex) {
    }
}

