/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.BaseDocumentProvider;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.UniformResourceMarkerAnnotationModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public final class HTMLDocumentProvider
extends BaseDocumentProvider {
    private static HTMLDocumentProvider _unifiedDocumentProvider = null;

    public static HTMLDocumentProvider getInstance() {
        if (_unifiedDocumentProvider == null) {
            _unifiedDocumentProvider = new HTMLDocumentProvider();
        }
        return _unifiedDocumentProvider;
    }

    private HTMLDocumentProvider() {
    }

    public TextFileDocumentProvider.FileInfo getFileInfoPublic(Object element) {
        return this.getFileInfo(element);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new HTMLFileInfo();
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo;
        IAnnotationModel annotationModel = super.getAnnotationModel(element);
        if (annotationModel == null && (fileInfo = this.getFileInfo(element)) != null) {
            annotationModel = fileInfo.fModel;
        }
        return annotationModel;
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info;
        block9: {
            if (!(element instanceof IEditorInput)) {
                return null;
            }
            try {
                info = super.createFileInfo(element);
                if (info instanceof HTMLFileInfo) break block9;
                return null;
            }
            catch (RuntimeException ex) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.HTMLDocumentProvider_CantCreateFileInfo, (Throwable)ex);
                return null;
            }
        }
        HTMLFileInfo cuInfo = (HTMLFileInfo)info;
        if (element instanceof IAdaptable) {
            cuInfo.fModel = cuInfo.fTextFileBuffer.getAnnotationModel();
            if (cuInfo.fModel == null || cuInfo.fModel.getClass().equals(AnnotationModel.class)) {
                IUniformResource uniformResource = (IUniformResource)((IAdaptable)element).getAdapter(IUniformResource.class);
                if (uniformResource != null) {
                    cuInfo.fModel = new UniformResourceMarkerAnnotationModel(uniformResource);
                } else if (cuInfo.fModel == null) {
                    cuInfo.fModel = new AnnotationModel();
                }
            }
        }
        return info;
    }

    public void disconnect(Object element) {
        String uri;
        HTMLFileInfo cuInfo = (HTMLFileInfo)this.getFileInfo(element);
        if (cuInfo != null && cuInfo.fCount == 1 && (uri = cuInfo.sourceProvider.getSourceURI()) != null) {
            FileContextManager.disconnectSourceProvider((String)uri, (IFileSourceProvider)cuInfo.sourceProvider);
        }
        try {
            super.disconnect(element);
        }
        catch (RuntimeException ex) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.HTMLDocumentProvider_ErrorDisconnectingDocumentProvider, (Throwable)ex);
        }
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
    }

    protected static class HTMLFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public IFileSourceProvider sourceProvider;

        protected HTMLFileInfo() {
        }
    }
}

