/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.ui.editors.preferences.formatter.CompilationUnitPreview;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialog;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialogTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentationTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "class Example {" + "  int [] myArray= {1,2,3,4,5,6};" + "  int theInt= 1;" + "  String someString= \"Hello\";" + "  double aDouble= 3.0;" + "  void foo(int a, int b, int c, int d, int e, int f) {" + "    switch(a) {" + "    case 0: " + "      Other.doFoo();" + "      break;" + "    default:" + "      Other.doBaz();" + "    }" + "  }" + "  void bar(List v) {" + "    for (int i= 0; i < 10; i++) {" + "      v.add(new Integer(i));" + "    }" + "  }" + "}" + "\n" + "enum MyEnum {" + "    UNDEFINED(0) {" + "        void foo() {}" + "    }" + "}" + "@interface MyAnnotation {" + "    int count() default 1;" + "}";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;
    private String editor;

    public IndentationTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues, String editor) {
        super(modifyDialog, workingValues);
        this.editor = editor;
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{" ", "\t", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "com.aptana.ide.editors.codeassist.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "com.aptana.ide.editors.codeassist.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        if (tabchar == null) {
            tabchar = " ";
        }
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group typeMemberGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_field_alignment_group_title);
        this.createCheckboxPref((Composite)typeMemberGroup, numColumns, FormatterMessages.IndentationTabPage_field_alignment_group_align_fields_in_columns, "com.aptana.ide.editors.codeassist.formatter.align_type_members_on_columns", FALSE_TRUE);
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_class_body, "com.aptana.ide.editors.codeassist.formatter.indent_body_declarations_compare_to_type_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_enum_decl, "com.aptana.ide.editors.codeassist.formatter.indent_body_declarations_compare_to_enum_declaration_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_enum_const, "com.aptana.ide.editors.codeassist.formatter.indent_body_declarations_compare_to_enum_constant_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_within_annot_decl, "com.aptana.ide.editors.codeassist.formatter.indent_body_declarations_compare_to_annotation_declaration_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "com.aptana.ide.editors.codeassist.formatter.indent_empty_lines", FALSE_TRUE);
    }

    @Override
    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    @Override
    protected Preview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent, this.editor, null);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if (" ".equals(this.fOldTabChar) || "\t".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if (" ".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("\t".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        String tabSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        String indentSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.indentation.size");
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.indentation.size", tabSize);
    }
}

