/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.codeassist.Activator;
import com.aptana.ide.internal.ui.dialogs.PreferencesAccess;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterProfileManager;
import com.aptana.ide.ui.editors.preferences.formatter.ProfileManager;
import com.aptana.ide.ui.editors.preferences.formatter.ProfileStore;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";
    private String pluginID;

    public FormatterProfileStore(String pluginId) {
        super(PREF_FORMATTER_PROFILES, pluginId);
        this.pluginID = pluginId;
    }

    public List readProfiles(IScopeContext scope) throws CoreException {
        List profiles = super.readProfiles(scope);
        if (profiles == null) {
            profiles = this.readOldForCompatibility(scope);
        }
        return profiles;
    }

    private List readOldForCompatibility(IScopeContext instanceScope) {
        block8: {
            List list;
            File file = Activator.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            try {
                List res = FormatterProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    this.writeProfiles(res, instanceScope);
                }
                file.delete();
                list = res;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    break block8;
                }
                catch (IOException e) {
                    IdeLog.log((Plugin)Activator.getDefault(), (int)4, (String)e.getMessage(), (Throwable)e);
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    public void checkCurrentOptionsVersion() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        IScopeContext instanceScope = access.getInstanceScope();
        IEclipsePreferences uiPreferences = instanceScope.getNode(this.pluginID);
        try {
            FormatterProfileManager manager;
            ArrayList profiles = new FormatterProfileStore(this.pluginID).readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            if ((manager = new FormatterProfileManager(profiles, instanceScope, access, this.pluginID)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges(instanceScope);
            }
            uiPreferences.putInt("org.eclipse.jdt.ui.formatterprofiles.version", 1);
            this.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IScopeContext scope = access.getProjectScope(projects[i]);
                if (manager.hasProjectSpecificSettings(scope)) {
                    manager = new FormatterProfileManager(profiles, scope, access, this.pluginID);
                    manager.commitChanges(scope);
                    this.savePreferences(scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        catch (BackingStoreException e) {
            IdeLog.log((Plugin)Activator.getDefault(), (int)4, (String)e.getMessage(), (Throwable)e);
        }
    }

    private void savePreferences(IScopeContext context) throws BackingStoreException {
        try {
            context.getNode(this.pluginID).flush();
        }
        finally {
            context.getNode(this.pluginID).flush();
        }
    }
}

