/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.preferences.Messages;
import com.aptana.ide.editors.unified.errors.ErrorDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ErrorDescriptorInfoDialog
extends TitleAreaDialog {
    private Text message;
    private String messageText;
    private Button okButton;
    private ErrorDescriptor error;

    public ErrorDescriptorInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ErrorDescriptorInfoDialog_IgnoreWarningError);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.file_extension_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(Messages.ErrorDescriptorInfoDialog_IgnoreWarningError);
        this.setMessage(Messages.ErrorDescriptorInfoDialog_AddRegEx);
        Label label = new Label(contents, 16384);
        label.setText(StringUtils.makeFormLabel((String)Messages.ErrorDescriptorInfoDialog_Message));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.message = new Text(contents, 2052);
        this.message.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (event.widget == ErrorDescriptorInfoDialog.this.message && ErrorDescriptorInfoDialog.this.okButton != null) {
                    ErrorDescriptorInfoDialog.this.okButton.setEnabled(ErrorDescriptorInfoDialog.this.validateErrorDescriptor());
                }
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.message.setLayoutData((Object)data);
        this.message.setFocus();
        if (this.error != null) {
            this.message.setText(this.error.getMessage());
        }
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private boolean validateErrorDescriptor() {
        if ("".equals(this.message.getText())) {
            return false;
        }
        this.messageText = this.message.getText();
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(this.validateErrorDescriptor());
    }

    public String getMessage() {
        return this.messageText;
    }

    public void setItem(ErrorDescriptor ed) {
        this.error = ed;
    }
}

