/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.codeassist.Activator;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class OpenWithMenuExternal
extends ContributionItem {
    private IVirtualFile file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private ViewPart view;
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenuExternal(ViewPart view, IVirtualFile file) {
        super(ID);
        this.view = view;
        this.file = file;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.file.getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.file.getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenuExternal.this.openEditor(descriptor);
                        break;
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = null;
        try {
            preferredEditor = IDE.getEditorDescriptor((String)this.file.getName());
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)e.getMessage());
        }
        IContentType finalType = null;
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = 0;
        int n2 = iContentTypeArray.length;
        while (n < n2) {
            block14: {
                IContentType type = iContentTypeArray[n];
                if (finalType != null) break;
                try {
                    String settings;
                    String[] stringArray = type.getSettings(null).getFileSpecs(4);
                    int n3 = 0;
                    int n4 = stringArray.length;
                    while (n3 < n4) {
                        settings = stringArray[n3];
                        if (settings.equals(this.file.getName())) {
                            finalType = type;
                            break;
                        }
                        ++n3;
                    }
                    if (finalType != null) break block14;
                    stringArray = type.getSettings(null).getFileSpecs(8);
                    n3 = 0;
                    n4 = stringArray.length;
                    while (n3 < n4) {
                        settings = stringArray[n3];
                        if (settings.equals(FileUtils.getExtension((String)this.file.getName()))) {
                            finalType = type;
                            break;
                        }
                        ++n3;
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error finding content type", (Throwable)e);
                }
            }
            ++n;
        }
        IEditorDescriptor[] editors = this.registry.getEditors(this.file.getName(), finalType);
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        String editorId = editor == null ? "org.eclipse.ui.systemExternalEditor" : editor.getId();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor desc = editorReg.findEditor(editorId);
        CoreUIUtils.openFileInEditor((IVirtualFile)this.file, (IEditorDescriptor)desc);
    }
}

