/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.professional.licensing;

import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.licensing.ClientKeyService;
import java.math.BigInteger;
import java.util.zip.CRC32;

public class LicensingUtilities {
    public static final ClientKey getActivationKey() {
        return ClientKeyService.getClientKey();
    }

    public static boolean isKeyValid() {
        boolean valid = false;
        ClientKey key = LicensingUtilities.getActivationKey();
        if (key != null) {
            valid = key.isValid() && (key.isPro() || key.isTrial() && !key.isExpired());
        }
        return valid;
    }

    public static ClientKey decrypt(String encrypted, String email) {
        String modulus = "115801190261221214754334668902722425936509505416457970789287297728816388753627896293249501578830570324705253515546383166989625001335561947096747210280001245977114030627247212292377290543869343996595819188362915644707269064020812435233012510929338706599216007185654748959001143012936618501934698642942289379979";
        String exponent = "65537";
        if (encrypted != null) {
            encrypted = encrypted.trim();
        }
        Decrypt decrypter = new Decrypt(exponent, modulus);
        return LicensingUtilities.decrypt(decrypter, encrypted, email);
    }

    private static ClientKey decrypt(Decrypt decrypter, String encrypted, String email) {
        String value = decrypter.decrypt(encrypted);
        if (value == null) {
            return new ClientKey(1, null, 0L);
        }
        String[] values = value.split(";");
        int type = 1;
        String genedEmail = null;
        long expiration = 0L;
        if (values.length == 3) {
            if ("p".equals(values[0].toLowerCase())) {
                type = 0;
            }
            if ((genedEmail = values[1]) != null) {
                if (!genedEmail.equalsIgnoreCase(email)) {
                    genedEmail = "EMAILS_NON_MATCHING";
                }
            } else {
                genedEmail = null;
            }
            try {
                expiration = Long.parseLong(values[2]);
            }
            catch (Exception exception) {
                expiration = 0L;
            }
        }
        return new ClientKey(type, genedEmail, expiration);
    }

    private static class Decrypt {
        private BigInteger modulus;
        private BigInteger exponent;

        Decrypt(String exponent, String modulus) {
            this.modulus = new BigInteger(modulus);
            this.exponent = new BigInteger(exponent);
        }

        public String decrypt(String encrypted) {
            try {
                encrypted = encrypted == null ? "" : ClientKey.trimEncryptedLicense((String)encrypted);
                BigInteger big = new BigInteger(encrypted);
                BigInteger decrypted = big.modPow(this.exponent, this.modulus);
                long crc32Value = (long)decrypted.intValue() & 0xFFFFFFFFL;
                decrypted = decrypted.shiftRight(32);
                byte[] bytes = decrypted.toByteArray();
                CRC32 crc32 = new CRC32();
                crc32.update(bytes);
                if (crc32Value == crc32.getValue()) {
                    return new String(bytes);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return null;
        }
    }
}

